<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

//
// initialization
//
$apikey = '';
$op = '';
$output = null;

//
// setup
//
if( isset($_REQUEST['op'] ) ) $op = strtoupper(trim($_REQUEST['op']));
if( isset($_REQUEST['apikey']) ) $apikey = trim($_REQUEST['apikey']);

// validation check
if( $apikey == '' ) cgsa_utils::return_error('No Authentication Information');
if( $op == '' ) cgsa_utils::return_error('Operation not specified');

// validate the apikey.
$access_info = cgsa_utils::validate_apikey($apikey);
if( !is_object($access_info) ) cgsa_utils::return_error('Invalid authentication information');

//
// handle the request
//
switch( $op ) {
 case 'LIST': // list social networks we know about
   try {
     if( !$access_info->check_permission(cgsa_apikey_perms::PERM_SOCIAL_READ) )
       throw new CmsException('Insufficient Permissions');
     if( !cgsa_utils::is_get_request() ) throw new CmsException('Invalid request method');
     $output = cgsa_social::get_network_list();
   }
   catch( Exception $e ) {
     cgsa_utils::return_error($e->getMessage());
   }
   break;

 case 'GETKEY': // get user credentials
   try {
     if( !$access_info->check_permission(cgsa_apikey_perms::PERM_SOCIAL_READ) )
       throw new CmsException('Insufficient Permissions');
     // todo: check for HTTPS
     if( !cgsa_utils::is_get_request() ) throw new CmsException('Invalid request method');
     if( !isset($_REQUEST['uid']) || !isset($_REQUEST['v']) || !isset($_REQUEST['network']) )
       cgsa_utils::return_error('Insufficient data');
     $uid = trim($_REQUEST['uid']);
     $v = trim($_REQUEST['v']);
     $network = trim($_REQUEST['network']);
     if( md5($apikey.$uid.$network) != $v ) throw new CmsException('Data validation error');
     $feu = cge_utils::get_module(MOD_FRONTENDUSERS);
     if( !$feu ) throw new CmsException('Internal error');
     if( $feu->LoggedInId() != $uid ) throw new CmsException('User validation error');
     $networkmod = cgsa_social::find_network_module($network);
     if( !$networkmod ) throw new CmsException('Invalid network specified: '.$network);
     $mod = cms_utils::get_module($networkmod);
     if( !is_object($mod) ) throw new CmsException('Social network module '.$networkmod.' not foun');
     $output = $mod->get_user_key($uid); // may return null... not an error.
   }
   catch( Exception $e ) {
     cgsa_utils::return_error($e->getMessage());
   }
   break;

 case 'SETKEY': // set user credentials
   try {
     if( !$access_info->check_permission(cgsa_apikey_perms::PERM_SOCIAL_READ) && 
	 !$access_info->check_permission(cgsa_apikey_perms::PERM_SOCIAL_WRITE) )
       throw new CmsException('Insufficient Permissions');
     // todo, check for HTTPS
     if( !cgsa_utils::is_post_request() ) throw new CmsException('Invalid request method');
     if( !isset($_REQUEST['uid']) || !isset($_REQUEST['v']) || !isset($_REQUEST['network']) || 
	 !isset($_REQUEST['token']) || !isset($_REQUEST['secret']) )
       cgsa_utils::return_error('Insufficient data');
     $uid = trim($_REQUEST['uid']);
     $v = trim($_REQUEST['v']);
     $network = trim($_REQUEST['network']);
     $token = trim($_REQUEST['token']);
     $secret = trim($_REQUEST['secret']);
     $x = md5($apikey.$uid.$network.$token.$secret);
     if( $x != $v ) throw new CmsException("Data validation error $x vs $v");
     $feu = cge_utils::get_module(MOD_FRONTENDUSERS);
     if( !$feu ) throw new CmsException('Internal error');
     if( ($x = $feu->LoggedInId()) != $uid ) throw new CmsException('User validation error '.$x.'/'.$uid);
     $mod = cms_utils::get_module($network);
     if( !is_object($mod) ) throw new CmsException('Social network module '.$network.' not foun');
     debug_to_log('set user key '.$network.' to '.$token.' - '.$secret);
     $mod->set_user_key($uid,$token,$secret);
   }
   catch( Exception $e ) {
     cgsa_utils::return_error($e->getMessage());
   }
   break;
} // switch

cgsa_utils::return_success($output);

#
# EOF
#
?>