<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

//
// initialization
//
$apikey = '';
$op = '';
$output = null;

//
// setup
//
if( isset($_REQUEST['op'] ) ) $op = strtoupper(trim($_REQUEST['op']));
if( isset($_REQUEST['apikey']) ) $apikey = trim($_REQUEST['apikey']);

// dependency check.
$cdmod = cms_utils::get_module('CompanyDirectory');
if( !$cdmod ) cgsa_utils::return_error('CompanyDirectory module not found');

// validation check
if( $apikey == '' ) cgsa_utils::return_error('No Authentication Information');
if( $op == '' ) cgsa_utils::return_error('Operation not specified');

// validate the apikey.
$access_info = cgsa_utils::validate_apikey($apikey);
if( !is_object($access_info) ) cgsa_utils::return_error('Invalid authentication information');
$disallowed_location_fields = array('url','picture_location','logo_location','status','owner_id');

// 
// handle the request
//
switch( $op ) {
 case 'HIERARCHY':
   try {
     if( !$access_info->check_permission(cgsa_apikey_perms::PERM_LOCATIONS_READ) ) {
       throw new Exception('Insufficient Permissions');
     }
     $output = cd_utils::get_hierarchy(TRUE);
   }
   catch( Exception $e ) {
     $this->Audit('',$this->GetName(),'LOCATION/HIERARCHY: '.$e->GetMessage());
     cgsa_utils::return_error($e->GetMessage());
   }
   break;

 case 'CATEGORIES':
   try {
     if( !$access_info->check_permission(cgsa_apikey_perms::PERM_LOCATIONS_READ) ) {
       throw new Exception('Insufficient Permissions');
     }
     $output = $cdmod->GetCategories();
   }
   catch( Exception $e ) {
     $this->Audit('',$this->GetName(),'LOCATION/CATEGORIES: '.$e->GetMessage());
     cgsa_utils::return_error($e->GetMessage());
   }
   break;
   
 case 'LIST':
   // a list of companies.
   try {
     if( !$access_info->check_permission(cgsa_apikey_perms::PERM_LOCATIONS_READ) ) {
       throw new Exception('Insufficient Permissions');
     }
     
     $filter = null;
     if( isset($_REQUEST['filter']) ) {
       $params = json_decode($_REQUEST['filter'],TRUE);
       if( !isset($params['pagelimit']) ) $params['pagelimit'] = 50;

       $filter = new cd_company_filter(json_decode($_REQUEST['filter'],TRUE));
     }
     else {
       if( !isset($_REQUEST['pagelimit']) ) $_REQUEST['pagelimit'] = 50;
       $filter = new cd_company_filter($_REQUEST);
     }
     cd_company_query::set_result_mode(cd_company_query::RESULTS_ARRAY);
     $obj = new cd_company_query($filter);
     
     $output = array();
     $res = array_values($obj->get_results());
     $output['num_matches'] = $obj->get_total_matches();
     $output['locations'] = $res;
   }
   catch( Exception $e ) {
     $this->Audit('',$this->GetName(),'LOCATION/LIST: '.$e->GetMessage());
     cgsa_utils::return_error($e->GetMessage());
   }
   break;

 case 'GET':
   try {
     if( !$access_info->check_permission(cgsa_apikey_perms::PERM_LOCATIONS_READ) ) {
       throw new Exception('Insufficient Permissions');
     }

     if( !isset($_REQUEST['location']) ) throw new Exception('Insufficient data');
     
     cd_company_query::set_result_mode(cd_company_query::RESULTS_ARRAY);
     $output = cd_utils::get_company($_REQUEST['location']);
   }
   catch( Exception $e ) {
     $this->Audit('',$this->GetName(),'LOCATION/GET: '.$e->GetMessage());
     cgsa_utils::return_error($e->GetMessage());
   }
   break;

 case 'ADD':
   try {
     // check permissions and settings.
     if( !$this->GetPreference('newlocation_allow',1) ) {
       throw new Exception('Adding locations is not permitted at this time');
     }
     if( !$access_info->check_permission(cgsa_apikey_perms::PERM_LOCATIONS_READ) ) {
       throw new Exception('Insufficient Permissions');
     }
     if( !cgsa_utils::is_post_request() ) throw new Exception('Invalid request method');
     $feu = cms_utils::get_module('FrontEndUsers');
     if( !$feu ) throw new Exception('Internal Error');

     if( !isset($_POST['company_name']) || !isset($_POST['owner']) ) throw new Exception('Insufficient data');

     $uid = $feu->LoggedInId();
     $owner = (int)$_POST['owner'];
     if( $uid != $owner ) throw new Exception("Invalid owner got $owner, but expected $uid");

     // do rate checking.
     $numlimit = (int)$this->GetPreference('newlocation_numlimit',0);
     $timelimit = (int)$this->GetPreference('newlocation_numlimit',0);
     if( $numlimit > 0 && $timelimit > 0 ) {
       // by time.
       $filter = new cd_company_filter();
       $filter['modified_since'] = time()-$timelimit*60;
       $filter['owner_id'] = $owner;
       $filter['pagelimit'] = $numlimit+1; // yep, try to get one more than our limit.
       $query = new cd_company_query($filter);
       if( $query->get_result_count() > $numlimit ) {
	 throw new Exception('You have created or edited too many locations lately.  Please try again later');
       }
     }

     // build the record.
     unset($_POST['owner']);
     unset($_POST['apikey']);
     unset($_POST['op']);
     $company = new cd_company;
     foreach( $_POST as $key => $value ) {
       if( in_array($key,$disallowed_location_fields) ) throw new Exception("Cannot set field $key when adding a location");
	  
       if( cd_company::is_valid_key($key) ) {
	 $company->$key = $value;
       }
       else if( startswith($key,'F:') ) {
	 $key = substr($key,2);
	 if( !cd_company::is_valid_field($key) )  throw new Exception("Field $key is invalid");
	 $company->set_field($key,$value);
       }
       else if( startswith($key,'C:') ) {
	 $key = substr($key,2);
	 if( !cd_company::is_valid_category($key) ) throw new Exception("Category $key is invalid");
	 $company->set_category($key,cge_utils::to_bool($value));
       }
       else {
	 throw new Exception("$key is an invalid location field");
       }
     }
     $company->owner_id = $owner;
     $company->status = $this->GetPreference('newlocation_status','draft');
     $company->save();

     // it worked (theoretically)
     $this->Audit($company->id,$this->GetName(),'LOCATION/ADD: by '.$uid);
     $output = $company->id;
   }
   catch( Exception $e ) {
     $this->Audit('',$this->GetName(),'LOCATION/ADD: '.$e->GetMessage());
     cgsa_utils::return_error($e->GetMessage());
   }
   break;

  case 'EDIT':
    try {
      if( !$this->GetPreference('newlocation_allowedit',1) ) throw new Exception('Editing locations is not permitted at this time');
      // check permission
      if( !$access_info->check_permission(cgsa_apikey_perms::PERM_LOCATIONS_WRITE) ) throw new Exception('Insufficient Permissions');
      if( !cgsa_utils::is_post_request() ) throw new Exception('Invalid request method');
      $feu = cms_utils::get_module('FrontEndUsers');
      if( !$feu ) throw new Exception('Internal Error');

      if( !isset($_POST['location']) || !isset($_POST['owner']) ) throw new Exception('Insufficient data');

      $uid = $feu->LoggedInId();
      $owner = (int)$_POST['owner'];
      if( $uid != $owner ) throw new Exception("Invalid owner got $owner, but expected $uid");

      // get the record
      $company = cd_company::load_by_id((int)$_POST['location']);

      // check ownership
      if( $company->owner_id != $uid ) throw new Exception('Attempt to edit a location with a different owner');

      // check status (disabled means you can't edit it).
      if( $company->status == 'disabled' ) throw new Exception('Attempt to edit a disabled location');

      // do rate checking.
      $numlimit = (int)$this->GetPreference('newlocation_numlimit',0);
      $timelimit = (int)$this->GetPreference('newlocation_numlimit',0);
      if( $numlimit > 0 && $timelimit > 0 ) {
	// by time.
	$filter = new cd_company_filter();
	$filter['modified_since'] = time()-$timelimit*60;
	$filter['owner_id'] = $owner;
	$filter['pagelimit'] = $numlimit+1; // yep, try to get one more than our limit.
	$query = new cd_company_query($filter);
	if( $query->get_result_count() > $numlimit ) {
	  throw new Exception('You have created or edited too many locations lately.  Please try again later');
	}
      }

      // edit the record
      $modified = FALSE;
      foreach( $_POST as $key => $value ) {
	if( in_array($key,array('op','apikey','owner','location')) ) continue;

	if( cd_company::is_valid_key($key) ) {
	  $company->$key = $value;
	  $modified = TRUE;
	}
	else if( startswith($key,'F:') ) {
	  $key = substr($key,2);
	  if( cd_company::is_valid_field($key) ) {
	    $field = $this->get_field($key);
	    if( is_object($field) ) {
	      if( $field->type != 'album' ) {
		$company->set_field($key,$value);
		$modified = TRUE;
	      }
	    }
	  }
	}
	else if( startswith($key,'C:') ) {
	  if( cd_company::is_valid_category($key) ) {
	    $company->set_category($key,$value);
	    $modified = TRUE;
	  }
	}
	else {
	  throw new Exception($key.' is an invalid company field');
	}
      }
      $company->url = '';

      if( $modified ) {
	// save the record
	$company->save();

	// audit the thing
	$this->Audit($copany->id,$this->GetName(),'LOCATION/EDIT: by '.$uid);
      }
    }
    catch( Exception $e ) {
      $this->Audit('',$this->GetName(),'LOCATION/EDIT: '.$e->GetMessage());
      cgsa_utils::return_error($e->GetMessage());
    }
    break;

  case 'PHOTOUPLOAD':
    try {
      if( !$this->GetPreference('newlocation_allowedit',1) )
	throw new Exception('Editing locations is not permitted at this time');
      // check permission
      if( !$access_info->check_permission(cgsa_apikey_perms::PERM_LOCATIONS_WRITE) )
	throw new Exception('Insufficient Permissions');
      if( !cgsa_utils::is_post_request() ) throw new Exception('Invalid request method');
      if( !isset($_FILES) || !is_array($_FILES) || !count($_FILES) ) throw new Exception('No files attached to request');
      $feu = cms_utils::get_module('FrontEndUsers');
      if( !$feu ) throw new Exception('Internal Error');

      if( !isset($_POST['location']) || !isset($_POST['owner']) ) throw new Exception('Insufficient data');

      $uid = $feu->LoggedInId();
      $owner = (int)$_POST['owner'];
      if( $uid != $owner ) throw new Exception("Invalid owner got $owner, but expected $uid");

      // get the record
      $company = cd_company::load_by_id((int)$_POST['location']);

      // check ownership
      if( $company->owner_id != $uid ) throw new Exception('Attempt to edit a location with a different owner');

      // check status (disabled means you can't edit it).
      if( $company->status == 'disabled' ) throw new Exception('Attempt to edit a disabled location');

      // see if we have an album field...
      $tmp = $company->list_fields();
      $fields = $company->get_fields();
      $fdid = '';
      if( is_array($fields) && count($fields) ) {
	foreach( $fields as $one ) {
	  if( $one->type == 'album' ) {
	    $fdid = $one->id;
	    break;
	  }
	}
      }
      if( !$fdid ) throw new Exception('No album information found');

      // do rate checking.
      $numlimit = (int)$this->GetPreference('newlocation_numlimit',0);
      $timelimit = (int)$this->GetPreference('newlocation_numlimit',0);
      if( $numlimit > 0 && $timelimit > 0 ) {
	// by time.
	$filter = new cd_company_filter();
	$filter['modified_since'] = time()-$timelimit*60;
	$filter['owner_id'] = $owner;
	$filter['pagelimit'] = $numlimit+1; // yep, try to get one more than our limit.
	$query = new cd_company_query($filter);
	if( $query->get_result_count() > $numlimit ) {
	  throw new Exception('You have created or edited too many locations lately.  Please try again later');
	}
      }

      // we're ready to handle the upload...
      $config = cmsms()->GetConfig();
      $options = array();
      $options['param_name'] = 'file';
      $options['compid'] = $company->id;
      $options['company'] = $company;
      $options['fdid'] = $fdid; // todo: get this
      $options['upload_dir'] = cms_join_path($config['uploads_path'],'companydirectory','id'.$company->id,'album_'.$fdid).'/';
      $options['upload_url'] = $config['uploads_url']."/companydirectory/id".$company->id."/album_$fdid/";
      $upload_handler = new CompanyDirectoryJQueryUploadHandler($options);
      $upload_handler->post(); // company gets saved in the handler.
      exit;
    }
    catch( Exception $e ) {
      $this->Audit('',$this->GetName(),'LOCATION/PHOTOUPLOAD: '.$e->GetMessage());
      cgsa_utils::return_error($e->GetMessage());
    }
    break;

  case 'PHOTODELETE':
    try {
      if( !$this->GetPreference('newlocation_allowedit',1) ) throw new Exception('Editing locations is not permitted at this time');
      // check permission
      if( !$access_info->check_permission(cgsa_apikey_perms::PERM_LOCATIONS_WRITE) ) throw new Exception('Insufficient Permissions');
      if( !cgsa_utils::is_post_request() ) throw new Exception('Invalid request method');
      $feu = cms_utils::get_module('FrontEndUsers');
      if( !$feu ) throw new Exception('Internal Error');
      if( !isset($_POST['location']) || !isset($_POST['owner']) || !isset($_POST['file']) ) throw new Exception('Insufficient data');

      $uid = $feu->LoggedInId();
      $owner = (int)$_POST['owner'];
      if( $uid != $owner ) throw new Exception("Invalid owner got $owner, but expected $uid");
      $files = $_POST['file'];

      // get the record
      $company = cd_company::load_by_id((int)$_POST['location']);

      // check ownership
      if( $company->owner_id != $uid ) throw new Exception('Attempt to edit a location with a different owner');

      // check status (disabled means you can't edit it).
      if( $company->status == 'disabled' ) throw new Exception('Attempt to edit a disabled location');

      // see if we have an album field...
      $tmp = $company->list_fields();
      $fields = $company->get_fields();
      $fdid = '';
      if( is_array($fields) && count($fields) ) {
	foreach( $fields as $one ) {
	  if( $one->type == 'album' ) {
	    $fdid = $one->id;
	    break;
	  }
	}
      }
      if( !$fdid ) throw new Exception('No album information found');

      $fnd = 0;
      foreach( $files as $filename ) {
	$filename = basename($filename);
	if( $company->delete_album_file($fdid,$filename) ) {
	  $fnd++;
	}
      }

      if( !$fnd ) throw new Exception("Problem deleting $filename for field $fdid");

      //done.
      $company->save();
    }
    catch( Exception $e ) {
      $this->Audit('',$this->GetName(),'LOCATION/PHOTOUPLOAD: '.$e->GetMessage());
      cgsa_utils::return_error($e->GetMessage());
    }
    break;

 case 'FAVORITES':
   try {
     if( !$access_info->check_permission(cgsa_apikey_perms::PERM_LOCATIONS_READ) ||
	 !$access_info->check_permission(cgsa_apikey_perms::PERM_FAVORITES_READ) ) {
       throw new Exception('Insufficient Permissions');
     }

     if( !cgsa_utils::is_get_request() ) throw new Exception('Invalid request method');
     $feu = cms_utils::get_module('FrontEndUsers');
     if( !$feu ) throw new Exception('Internal Error');
     if( !isset($_POST['owner']) ) throw new Exception('Insufficient data');
     $uid = $feu->LoggedInId();
     $owner = (int)$_POST['owner'];
     if( $uid != $owner )  throw new Exception("Invalid owner got $owner, but expected $uid");

     $favs = cgsa_favorites::get($uid);
     if( is_array($favs) && count($favs) ) $filter = new cd_company_filter(array('idlist'=>$favs));
     cd_company_query::set_result_mode(cd_company_query::RESULTS_ARRAY);
     $obj = new cd_company_query($filter);

     $output = array();
     $res = array_values($obj->get_results());
     $output['num_matches'] = $obj->get_total_matches();
     $output['locations'] = $res;
   }
   catch( Exception $e ) {
     $this->Audit('',$this->GetName(),'LOCATION/FAVORITES: '.$e->GetMessage());
     cgsa_utils::return_error($e->GetMessage());
   }
   break;

 case 'MOSTCHECKINS':
   try {
     if( !$access_info->check_permission(cgsa_apikey_perms::PERM_LOCATIONS_READ) ||
	 !$access_info->check_permission(cgsa_apikey_perms::PERM_CHECKINS_READ) ) {
       throw new Exception('Insufficient Permissions');
     }

     $parms = $_REQUEST;
     $parms['sortby'] = 'mostcheckins';
     $parms['sortorder'] = 'DESC';
     $filter = new cd_company_filter($parms);

     cd_company_query::set_result_mode(cd_company_query::RESULTS_ARRAY);
     $obj = new cd_company_query($filter);
     $res = array_values($obj->get_results());
     $output = array();
     $output['num_matches'] = $obj->get_total_matches();
     $output['locations'] = $res;
   }
   catch( Exception $e ) {
     $this->Audit('',$this->GetName(),'LOCATION/MOSTCHECKINS: '.$e->GetMessage());
     cgsa_utils::return_error($e->GetMessage());
   }
   break;

 case 'MOSTFAVORITE':
   try {
     if( !$access_info->check_permission(cgsa_apikey_perms::PERM_LOCATIONS_READ) ||
	 !$access_info->check_permission(cgsa_apikey_perms::PERM_FAVORITES_READ) ) {
       throw new Exception('Insufficient Permissions');
     }

     if( !cgsa_utils::is_get_request() ) throw new Exception('Invalid request method');

     $parms = $_REQUEST;
     $parms['sortby'] = 'mostfavorite';
     $parms['sortorder'] = 'DESC';

     // get users friends list.
     $friends = null;
     if( isset($_POST['byfriends']) && cms_to_bool($_POST['byfriends']) ) {
       $friends = cgsa_friends::get_friends($uid,$limit,$offset);
       debug_to_log($friends,'friends');
       if( is_array($friends) && count($friends) > 0 ) {
	 $parms['ownerlist'] = $friends;
       }
     }

     $filter = new cd_company_filter($parms);

     cd_company_query::set_result_mode(cd_company_query::RESULTS_ARRAY);
     $obj = new cd_company_query($filter);
     $res = array_values($obj->get_results());
     $output = array();
     $output['num_matches'] = $obj->get_total_matches();
     $output['locations'] = $res;
   }
   catch( Exception $e ) {
     $this->Audit('',$this->GetName(),'LOCATION/MOSTFAVORITE: '.$e->GetMessage());
     cgsa_utils::return_error($e->GetMessage());
   }
   break;

  default:
    cgsa_utils::return_error('Unknown command');
  }

cgsa_utils::return_success($output);

#
# EOF
#
?>