<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

//
// initialization
//
$apikey = '';
$op = '';
$output = null;

//
// setup
//
if( isset($_REQUEST['op'] ) ) $op = strtoupper(trim($_REQUEST['op']));
if( isset($_REQUEST['apikey']) ) $apikey = trim($_REQUEST['apikey']);

// validation check
if( $apikey == '' ) cgsa_utils::return_error('No Authentication Information');
if( $op == '' ) cgsa_utils::return_error('Operation not specified');

// validate the apikey.
$access_info = cgsa_utils::validate_apikey($apikey);
if( !is_object($access_info) ) cgsa_utils::return_error('Invalid authentication information');

//
// handle the request
//
switch( $op ) {
 case 'ADD':
   try {
     if( !$access_info->check_permission(cgsa_apikey_perms::PERM_FAVORITES_WRITE) ) {
       throw new Exception('Insufficient Permissions');
     }
     if( !cgsa_utils::is_post_request() ) throw new Exception('Invalid request method');
     $feu = cms_utils::get_module('FrontEndUsers');
     if( !$feu ) throw new Exception('Internal Error');
     if( !isset($_POST['location']) || !isset($_POST['owner']) ) throw new Exception('Insufficient data');

     $uid = $feu->LoggedInId();
     $owner = (int)$_POST['owner'];
     $location = (int)$_POST['location'];
     if( $uid != $owner ) throw new Exception("Invalid owner got $owner, but expected $uid");

     // validate the company.
     $company = cd_utils::get_company($params['companyid'],$returnid,TRUE);
     if( is_object($company) ) {
       cgsa_favorites::add($owner,$location);
     }
   }
   catch( Exception $e ) {
     $this->Audit('',$this->GetName(),'FAVORITES/ADD: '.$e->GetMessage());
     cgsa_utils::return_error($e->GetMessage());
   }
   break;

 case 'LIST':
   try {
     if( !$access_info->check_permission(cgsa_apikey_perms::PERM_FAVORITES_READ) ) {
       throw new Exception('Insufficient Permissions');
     }
     if( !cgsa_utils::is_get_request() ) throw new Exception('Invalid request method');
     $feu = cms_utils::get_module('FrontEndUsers');
     if( !$feu ) throw new Exception('Internal Error');
     if( !isset($_GET['owner']) ) throw new Exception('Insufficient data');

     $uid = $feu->LoggedInId();
     $owner = (int)$_GET['owner'];
     if( $uid != $owner ) throw new Exception("Invalid owner got $owner, but expected $uid");

     $tmp = cgsa_favorites::list_for_user($owner);
     // get the list of companies in this list.. that match.
     $filter = new cd_company_filter(array('idlist'=>$tmp));
     $rs = new cd_company_query($filter);
     
     $output = array();
     while( !$rs->EOF() ) {
       if( !in_array($query->fields['id'],$tmp) ) continue;
       $output[] = $query->fields['id'];
       $rs->MoveNext();
     }
   }
   catch( Exception $e ) {
     $this->Audit('',$this->GetName(),'FAVORITES/ISFAVORITE: '.$e->GetMessage());
     cgsa_utils::return_error($e->GetMessage());
   }
   break;

 case 'ISFAVORITE':
   try {
     if( !$access_info->check_permission(cgsa_apikey_perms::PERM_FAVORITES_READ) ) {
       throw new Exception('Insufficient Permissions');
     }
     if( !cgsa_utils::is_get_request() ) throw new Exception('Invalid request method');
     $feu = cms_utils::get_module('FrontEndUsers');
     if( !$feu ) throw new Exception('Internal Error');
     if( !isset($_GET['location']) || !isset($_GET['owner']) ) throw new Exception('Insufficient data');

     $uid = $feu->LoggedInId();
     $owner = (int)$_GET['owner'];
     $location = (int)$_GET['location'];
     if( $uid != $owner ) throw new Exception("Invalid owner got $owner, but expected $uid");

     $company = cd_utils::get_company($params['companyid'],$returnid,TRUE);
     if( is_object($company) ) {
       $output = cgsa_favorites::check($owner,$location)?1:0;
     }
   }
   catch( Exception $e ) {
     $this->Audit('',$this->GetName(),'FAVORITES/ISFAVORITE: '.$e->GetMessage());
     cgsa_utils::return_error($e->GetMessage());
   }
   break;

 case 'DEL':
 case 'DELETE':
   try {
     if( !$access_info->check_permission(cgsa_apikey_perms::PERM_FAVORITES_WRITE) ) {
       throw new Exception('Insufficient Permissions');
     }
     if( !cgsa_utils::is_post_request() ) throw new Exception('Invalid request method');
     $feu = cms_utils::get_module('FrontEndUsers');
     if( !$feu ) throw new Exception('Internal Error');
     if( !isset($_POST['location']) || !isset($_POST['owner']) ) throw new Exception('Insufficient data');

     $uid = $feu->LoggedInId();
     $owner = (int)$_POST['owner'];
     $location = (int)$_POST['location'];
     if( $uid != $owner ) throw new Exception("Invalid owner got $owner, but expected $uid");

     // don't care to check for company.
     cgsa_favorites::delete($owner,$location)?1:0;
   }
   catch( Exception $e ) {
     $this->Audit('',$this->GetName(),'FAVORITES/ISFAVORITE: '.$e->GetMessage());
     cgsa_utils::return_error($e->GetMessage());
   }
   break;

 default:
   cgsa_utils::return_error('Unknown command');
   break;
}

cgsa_utils::return_success($output);

#
# EOF
#
?>