<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission('Modify Site Preferences') ) exit;

//
// initialization
//
$this->SetCurrentTab('activities');
$activities = cgsa_activity::load_all_as_tree();
if( !is_array($activities) || count($activities) == 0 ) {
  $this->SetError($this->Lang('error_noactivities'));
  $this->RedirectToTab($id);
}

if( isset($params['cancel']) ) {
  $this->SetMessage('operation_cancelled');
  $this->RedirectToTab($id);
}
if( isset($params['submit']) ) {

  function __flatten_activities($data,$parent_id = -1)
  {
    $out = array();
    $id = null;
    $order = 1;
    foreach( $data as $one ) {
      if( is_array($one) && count($one) == 2 ) {
	$id = substr($one[0],strlen('act_'));
	$out[] = array('id'=>$id,'parent_id'=>$parent_id,'item_order'=>$order);
	if( isset($one[1]) && is_array($one[1]) ) {
	  $out = array_merge($out,__flatten_activities($one[1],$id));
	}
      }
      else {
	$id = substr($one,strlen('act_'));
	$out[] = array('id'=>$id,'parent_id'=>$parent_id,'item_order'=>$order);
      }
      $order++;
    }
    return $out;
  }

  if( isset($params['ajaxdata']) ) {
    // doing this via ajax.
    $data = json_decode($params['ajaxdata']);
    
    $flat = __flatten_activities($data);
    cgsa_activity::bulk_update($flat);
    echo 'success';
    exit;
  }

  $this->SetMessage('operation_successful');
  $this->RedirectToTab($id);
}

//
// give everything to smarty
//
$smarty->assign('formstart',$this->CGCreateFormStart($id,'admin_orderactivity'));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('activities',$activities);
echo $this->ProcessTemplate('admin_orderactivity.tpl');

#
# EOF
#
?>