<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission('Modify Site Preferences') ) return;

$this->SetCurrentTab('friendsettings');

if( isset($params['cancel']) ) {
  $this->SetMessage($this->Lang('operation_cancelled'));
  $this->RedirectToTab($id,'','','admin_settings');
}
else if( isset($params['resetreq']) ) {
  $this->SetPreference('friendreq_bodytpl',file_get_contents(__DIR__.'/templates/friendreq_body.tpl'));
  $this->SetMessage($this->Lang('operation_successful'));
  $this->RedirectToTab($id,'','','admin_settings');
}
else if( isset($params['resetapproved']) ) {
  $this->SetPreference('friendapproved_bodytpl',file_get_contents(__DIR__.'/templates/friendapproved_body.tpl'));
  $this->SetMessage($this->Lang('operation_successful'));
  $this->RedirectToTab($id,'','','admin_settings');
}
else if( isset($params['submit']) ) {
  $this->SetPreference('friendreq_email',(int)$params['friendreq_email']);
  $this->SetPreference('friendreq_emailhtml',(int)$params['friendreq_emailhtml']);
  $this->SetPreference('friendreq_subject',trim($params['friendreq_subject']));
  $this->SetPreference('friendreq_bodytpl',trim($params['friendreq_bodytpl']));

  $this->SetPreference('friendapproved_email',(int)$params['friendapproved_email']);
  $this->SetPreference('friendapproved_emailhtml',(int)$params['friendapproved_emailhtml']);
  $this->SetPreference('friendapproved_subject',trim($params['friendapproved_subject']));
  $this->SetPreference('friendapproved_bodytpl',trim($params['friendapproved_bodytpl']));

  $this->SetMessage($this->Lang('operation_successful'));
  $this->RedirectToTab($id,'','','admin_settings');
}
#
# EOF
#
?>