<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2012 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission($this::PERMISSION_CHECKINS) ) return;

if( !isset($params['doubleconfirm']) ) {
  $params['orig_action'] = 'admin_checkins_tab';
  $this->Redirect($id,'admin_doubleconfirm',$returnid,$params);
}
$this->SetCurrentTab('checkins');

switch($params['checkin_action']) {
 case 'delallcheckins':
   $query = 'TRUNCATE TABLE '.CGSOCIAL_TABLE_CHECKINS;
   $res = $db->Execute($query);
   $n = $db->Affected_Rows();
   $this->SetMessage($this->Lang('msg_checkins_deleted',$n));
   break;

 case 'delbaduser':
   $feu = cms_utils::get_module(MOD_FRONTENDUSERS);
   $feuq = new feu_user_query();
   $rs = $feuq->execute();
   $list = array();
   while( !$rs->EOF() ) {
     $list[] = $rs->fields['id'];
     $rs->MoveNext();
   }
   $query = 'DELETE FROM '.CGSOCIAL_TABLE_CHECKINS.' WHERE owner NOT IN ('.implode(',',$list).')';
   $res = $db->Execute($query);

   $n = $db->Affected_Rows();
   $this->SetMessage($this->Lang('msg_checkins_deleted',$n));
   break;
   
 case 'delbadloc':
   $cdmod = cms_utils::get_module(MOD_COMPANYDIRECTORY);
   $filter = new cd_company_filter();
   $cdq = new cd_company_query($filter);
   $list = array();
   while( !$cdq->EOF() ) {
     $list[] = $cdq->fields['id'];
     $cdq->MoveNext();
   }

   $query = 'DELETE FROM '.CGSOCIAL_TABLE_CHECKINS.' WHERE location NOT IN ('.implode(',',$list).')';
   $res = $db->Execute($query);

   $n = $db->Affected_Rows();
   $this->SetMessage($this->Lang('msg_checkins_deleted',$n));
   break;
}

$this->RedirectToAdminTab();

#
# EOF
#
?>