<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2012 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission(CGSocialApp::PERMISSION) ) exit;

//
// initialization
//
$this->SetCurrentTab('leaderboards');
if( isset($params['cancel']) ) {
  $this->RedirectToTab($id);
}
$leaderboard = new cgsa_leaderboard();
if( !isset($params['leaderboard']) || $params['leaderboard'] == '' ) {
  $params['leaderboard'] = -1;
}
else if( $params['leaderboard'] > 0 ) {
  $leaderboard = cgsa_leaderboard::load_by_id($params['leaderboard']);
}

if( isset($params['submit']) ) {
  try {
    $data = $params;
    unset($data['submit']);
    unset($data['action']);
    unset($data['leaderboard']);
    unset($data['delete_image']);
    $data['id'] = $params['leaderboard'];

    $dir = cgsa_utils::get_leaderboard_filepath();
    $uploader = cge_setup::get_uploader($id,$dir);
    if( $uploader->check_upload_attempted('image') && $leaderboard->image != '' ) {
      // we're uploading another image, delete the first one.
      $params['delete_image'] = 1;
    }

    if( isset($params['delete_image']) && $leaderboard->image != '') {
      // delete image checkbox was checked.
      unset($params['delete_image']);
      cgsa_utils::delete_image($dir,$leaderboard->image);
      $leaderboard->image = '';
    }

    $leaderboard = cgsa_leaderboard::load_from_data($data);

    // handle uploaded file.
    $uploader = cge_setup::get_uploader($id,$dir);
    if( $uploader->check_upload_attempted('image') ) {
      // we're uploading a file.
      @mkdir($dir,0777,TRUE);
      $res = $uploader->handle_upload('image');
      if( !$res ) throw new CmsException($this->GetUploadErrorMessage($uploader->get_error()));
      $leaderboard->image = $res;
    }

    $leaderboard->set_dirty();
    $leaderboard->save();

    $this->SetMessage($this->Lang('msg_leaderboard_updated'));
    $this->RedirectToTab($id);
  }
  catch( Exception $e ) {
    echo $this->ShowErrors($e->GetMessage());
  }
}

$smarty->assign('leaderboard',$leaderboard);
$smarty->assign('formstart',$this->CGCreateFormStart($id,'admin_addedit_leaderboard','',array('leaderboard'=>$params['leaderboard'])));
$smarty->assign('formend',$this->CreateFormEnd());
{
  $ktypes = $leaderboard->get_types();
  $tmp = array();
  foreach( $ktypes as $key ) {
    $tmp[$key] = $this->Lang('leaderboard_'.$key);
  }
  $smarty->assign('boardtypes',$tmp);
}

echo $this->ProcessTemplate('admin_addedit_leaderboard.tpl');
# 
# EOF
#
?>
