<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: FrontEndUsers (c) 2012 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission(CGSocialApp::PERMISSION) ) exit;
if( !isset($params['leaderboard']) ) return;

if( isset($params['cancel']) ) {
  $this->SetMessage($this->Lang('operation_cancelled'));
  $this->Redirect($id,'admin_listbadges','',array('leaderboard'=>$params['leaderboard']));
}

$leaderboard = cgsa_leaderboard::load_by_id((int)$params['leaderboard']);
if( !is_object($leaderboard) ) return;
$badge = new cgsa_badge;
if( isset($params['badge']) ) {
  $badge = cgsa_badge::load_by_id($params['badge']);
}

if( isset($params['submit']) ) {
  $parms = $params;
  $parms['leaderboard_id'] = $parms['leaderboard'];
  unset($parms['leaderboard']);
  $parms['id'] = -1;
  $newbadge = 1;
  if( isset($parms['badge']) ) {
    $newbadge = 0;
    $parms['id'] = $parms['badge'];
    unset($parms['badge']);
  }
  unset($parms['submit']);
  unset($parms['action']);
  unset($parms['delete_image']);

  try {
    foreach( $parms as $key => $value ) {
      $badge->$key = $value;
    }

    if( $badge->id > 0 ) {
      $dir = cgsa_utils::get_badge_filepath($badge);
      $uploader = cge_setup::get_uploader($id,$dir);
      if( $uploader->check_upload_attempted('image') && $leaderboard->image != '' ) {
	// we're uploading another image, delete the first one.
	$params['delete_image'] = 1;
      }

      if( isset($params['delete_image']) && $leaderboard->image != '') {
	// delete image checkbox was checked.
	unset($params['delete_image']);
	cgsa_utils::delete_image($dir,$badge->image);
	$badge->image = '';
      }

      // handle uploaded file.
      if( $uploader->check_upload_attempted('image') ) {
	// we're uploading a file.
	@mkdir($dir,0777,TRUE);
	$res = $uploader->handle_upload('image');
	if( !$res ) throw new CmsException($this->GetUploadErrorMessage($uploader->get_error()));
	$badge->image = $res;
      }
    }

    $badge->save();
    if( $newbadge ) {
      $this->SetMessage($this->Lang('msg_badgecreated'));
    }
    else {
      $this->SetMessage($this->Lang('msg_badgeupdated'));
    }
    $this->Redirect($id,'admin_listbadges','',array('leaderboard'=>$params['leaderboard']));
  }
  catch( Exception $e ) {
    echo $this->ShowErrors($e->GetMessage());
  }
}

$to_opts = array();
$to_opts['admin'] = $this->Lang('lbl_notify_default_profile');
$to_opts['user'] = $this->Lang('lbl_notify_user_profile');
$smarty->assign('to_opts',$to_opts);

$priorities = array();
$priorities[-1] = $this->Lang('off');
$priorities[notification_message::PRIORITY_HIGH] = $this->Lang('high');
$priorities[notification_message::PRIORITY_NORMAL] = $this->Lang('normal');
$priorities[notification_message::PRIORITY_LOW] = $this->Lang('low');
$smarty->assign('priorities',$priorities);

$parms = array('leaderboard'=>$params['leaderboard']);
if( isset($params['badge']) ) $parms['badge'] = $params['badge'];
$smarty->assign('formstart',$this->CGCreateFormStart($id,'admin_addedit_badge','',$parms));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('leaderboard',$leaderboard);
$smarty->assign('badge',$badge);
echo $this->ProcessTemplate('admin_addedit_badge.tpl');

#
# EOF
#
?>