<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
$feu = cms_utils::get_module(MOD_FRONTENDUSERS);
if( !$feu ) return; // no feu
if( !isset($params['location']) ) return;
$uid = $feu->LoggedInId(); 
$error = '';
$message = '';
$location_id = (int)$params['location'];
$cdmod = cms_utils::get_module(MOD_COMPANYDIRECTORY);
$company = cd_utils::get_company($location_id,'',TRUE);
if( !is_object($company) || $company->status != 'published' ) return;
$activities = cgsa_activity::load_all_as_dropdown();
$activities = array_merge(array(-1=>$this->Lang('none')),$activities);

// past here, we can display something.
if( $uid < 1 ) $error = $this->Lang('msg_notloggedin');

if( !$error && isset($params['cgs_checkin']) ) {
  try {
    // validate and clean data
    $msg = '';
    $lat = '';
    $long = '';
    $activity = '';
    if( isset($params['cgs_msg']) ) {
      $msg = trim(strip_tags(cms_html_entity_decode($params['cgs_msg'])));
      $msg = substr($msg,0,255);
    }
    if( isset($params['cgs_lat']) ) {
      $lat = (float)$params['cgs_lat'];
      $long = (float)$params['cgs_long'];
    }
    if( isset($params['cgs_activity']) ) $activity = (int)$params['cgs_activity'];

    if( $msg == '' && get_parameter_value($params,'msgrequired',0) ) {
      throw new CmsException($this->Lang('error_messagerequired'));
    }

    if( ($lat == '' || $long == '') && 
	get_parameter_value($params,'coordsrequired',$this->GetPreference('locationrequired',0)) ) {
      throw new CmsException($this->Lang('error_coordsrequired'));
    }

    if( ($tmp = $this->GetPreference('checkinratelimiting')) ) {
      // do rate limiting
      $rl = explode(',',$tmp);
      if( in_array('bylocation',$rl) && 
	  ($rad = (int)$this->GetPreference('checkinratelimiting_bylocation')) ) {
	if( $lat == '' ) throw new CmsException($this->Lang('error_coordsrequired'));

	if( $rad > 0 ) {
	    // ratelimiting by radius (in miles)		    
	    // get the location information of this company.
	    if( !$company->latitude || !$company->longitude )
	      throw new Exception($this->Lang('error_nolocationcoords'));

	    $lat1 = $company->latitude;
	    $lat2 = $lat;
	    $lon1 = $company->longitude;
	    $lon2 = $long;

	    $theta = $lon1 - $lon2;
	    $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta)); 
	    $dist = acos($dist); 
	    $dist = rad2deg($dist); 
	    $miles = $dist * 60 * 1.1515;

	    if( $miles > $rad )
	      throw new Exception($this->Lang('error_checkindistance'));
	  }
      }

      if( in_array('bytime',$rl) && 
	  ($tl = (int)$this->GetPreference('checkinratelimiting_bytime',10)) > 0 ) {
	// rate limiting by time limit.
	// get the last checkin by this user.
	// and get its created time.
	$ocheckin = cgsa_checkin::load_by_user($uid,1);
	if( is_object($ocheckin) ) {
	  $now = time();
	  if( $now - $ocheckin->created < ($tl * 60) ) {
	    $rem = ceil($tl - ($now - $ocheckin->created)/60);
	    throw new Exception('Checkin failed... please try again in '.$rem.' minutes');
	  }
	}
      }
    }

    // create the checkin
    // and save it.
    $checkin = new cgsa_checkin;
    $checkin->owner = $uid;
    $checkin->location = $location_id;
    $checkin->activity = $activity;
    $checkin->parent_id = -1;
    $checkin->msg = $msg;
    $checkin->lat = $lat;
    $checkin->lng = $long;
    $checkin->approved = 0;
    if( !cgsa_utils::is_checkin_approval_required($checkin->location) ) {
      $checkin->approved = 1;
    }

    $data = null;
    if( isset($_FILES) && is_array($_FILES) && count($_FILES) ) {
      $config = cmsms()->GetConfig();
      $destdir = cms_join_path($config['uploads_path'],'_'.$this->GetName());
      @mkdir($destdir);

      $data = array();
      foreach( $_FILES as $key => $value ) {
	if( is_array($_FILES[$key]['name']) ) {
	  $n = count($_FILES[$key]['name']);
	  for( $i = 0; $i < $n; $i++ ) {
	    if( $_FILES[$key]['name'][$i] == '' ) continue;
	    $handler = cge_setup::get_uploader('',$destdir);
	    $filename = cgsa_utils::get_unique_filename($checkin->obid);
	    $res = $handler->handle_upload($key,$filename,$i);
	    $err = $handler->get_error();
	    if( !$res && $err != cg_fileupload::NOFILE ) {
	      die('error '.$err);
	      throw new Exception('Upload Error '.$handler->get_errormsg());
	    }
	    $data[] = $res;
	  }
	}
	else {
	  $handler = cge_setup::get_uploader('',$destdir);
	  $filename = cgsa_utils::get_unique_filename($checkin->obid);
	  $res = $handler->handle_upload($key,$filename);
	  $err = $handler->get_error();
	  if( !$res && $err != cg_fileupload::NOFILE )
	    throw new Exception('Upload Error '.$handler->get_errormsg());
	  $data[] = $res;
	}
      }
    }
    if( count($data) ) $checkin->extra_files = $data;
    $res = $checkin->save();

    // handle any leaderboards that need to be updated.
    $this->UpdateLeaderboards($checkin);

    // send an event
    cgsa_utils::send_event('OnCheckin',array('checkin'=>$checkin));

    // if we got here, everything is golden.
    $message = $this->Lang('msg_checkinsuccess');
  }
  catch( Exception $e ) {
    $error = $e->GetMessage();
  }
}

$tplname = $this->GetPreference('current_add_checkin_template');
if( isset($params['template']) ) $tplname = trim($params['template']);
if( !$tplname ) return;

$tpl = $smarty->createTemplate($this->GetDatabaseResource('add_checkin'.$tplname));
if( $message != '' ) {
  $tpl->assign('message',$message);
}
$tpl->assign('returnid',$returnid);
$tpl->assign('mod',$this);
$tpl->assign('actionid',$id);
$tpl->assign('error',$error);
$tpl->assign('location_id',$location_id);
$tpl->assign('location',$company);
$tpl->assign('activities',$activities);
if( !$error && !$message ) {
  $tpl->assign('formstart',$this->CGCreateFormStart($id,'addcheckin',$returnid,$params));
  $tpl->assign('formend',$this->CreateFormEnd());
}
echo $tpl->fetch();

#
# EOF
#
?>