<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class CGSocialApp extends CGExtensions
{
  const PERMISSION = 'Manage Social API Keys';
  const PERMISSION_CHECKINS = 'Manage Social Checkins';

  function __construct()
  {
    require_once(__DIR__.'/defines.php');
    parent::__construct();

    $smarty = cmsms()->GetSmarty();
    $smarty->register_function('cgsa_getactivity',array('cgsa_utils','smarty_getactivity'));
    $smarty->register_function('cgsa_selactivity',array('cgsa_utils','smarty_selactivity'));

    $this->AddImageDir('images');
  }

  function GetName() { return get_class($this); }
  function AllowAutoInstall() { return FALSE; }
  function AllowAutoUpgrade() { return FALSE; }
  function GetFriendlyName() { return $this->GetPreference('friendlyname',$this->Lang('friendlyname')); }
  function GetVersion() { return '1.3.1'; }
  function GetHelp() { return @file_get_contents(__DIR__.'/help.html.inc');  }
  function GetAuthor() { return 'Robert Campbell (calguy1000)'; }
  function GetAuthorEmail() { return 'calguy1000@cmsmadesimple.org'; }
  function IsPluginModule() { return TRUE; }
  function HasAdmin() { return TRUE; }
  function GetAdminSection() { return 'content'; }
  function GetAdminDescription() { return $this->Lang('moddescription'); }
  function MinimumCMSVersion() { return '1.11.2'; }
  function InstallPostMessage() { return $this->Lang('postinstall'); }
  function UninstallPostMessage() { return $this->Lang('postuninstall'); }
  function UninstallPreMessage() { return $this->Lang('preuninstall'); }
  function HandlesEvents() { return TRUE; }
  function LazyLoadAdmin() { return TRUE; }
  function LazyLoadFrontend() { return FALSE; } // not using static routes (yet).

  function GetChangeLog()
  {
    $fn = __DIR__.'/changelog.inc';
    return file_get_contents($fn);
  }

  function GetHeaderHTML()
  {
    $txt = parent::GetHeaderHTML();
    $obj = cge_utils::get_module('JQueryTools');
    if( is_object($obj) ) {
      $tmpl = <<<EOT
{JQueryTools action='incjs' exclude='form'}
{JQueryTools action='ready'}
EOT;
      $txt .= $this->ProcessTemplateFromData($tmpl);
    }
    return $txt;
  }

  function InitializeFrontend()
  {
    $this->RestrictUnknownParams();
    $pageid = cmsms()->GetContentOperations()->GetDefaultContent();

    // route for RESTFUL api
    $this->RegisterRoute('/app\/v1\/users$/',array('action'=>'api_users','showtemplate'=>'false','returnid'=>$pageid));
    $this->RegisterRoute('/app\/v1\/activities$/',array('action'=>'api_activities','showtemplate'=>'false','returnid'=>$pageid));
    $this->RegisterRoute('/app\/v1\/checkins$/',array('action'=>'api_checkins','showtemplate'=>'false','returnid'=>$pageid));
    $this->RegisterRoute('/app\/v1\/friends$/',array('action'=>'api_friends','showtemplate'=>'false','returnid'=>$pageid));
    $this->RegisterRoute('/app\/v1\/locations$/',array('action'=>'api_locations','showtemplate'=>'false','returnid'=>$pageid));
    $this->RegisterRoute('/app\/v1\/leaderboards$/',array('action'=>'api_leaderboards','showtemplate'=>'false','returnid'=>$pageid));
    $this->RegisterRoute('/app\/v1\/badges$/',array('action'=>'api_badges','showtemplate'=>'false','returnid'=>$pageid));
    $this->RegisterRoute('/app\/v1\/social$/',array('action'=>'api_social','showtemplate'=>'false','returnid'=>$pageid));
    $this->RegisterRoute('/app\/v1\/favorites$/',array('action'=>'api_favorites','showtemplate'=>'false','returnid'=>$pageid));

    // routes for various views
    $this->RegisterRoute('/activity\/(?P<returnid>[0-9]+)\/(?P<activity>[0-9]+)\/(?P<junk>.*?)$/',array('action'=>'view_activity'));

    // parameters for frontend list checkins.
    $this->SetParameterType('badge',CLEAN_INT);
    $this->SetParameterType('checkin',CLEAN_INT);
    $this->SetParameterType('location',CLEAN_NONE);
    $this->SetParameterType('activity',CLEAN_INT);
    $this->SetParameterType('activityparent',CLEAN_INT);
    $this->SetParameterType('timelimit',CLEAN_INT);
    $this->SetParameterType('owner',CLEAN_INT);
    $this->SetParameterType('owners',CLEAN_NONE);
    $this->SetParameterType('limit',CLEAN_INT);
    $this->SetParameterType('offset',CLEAN_INT);
    $this->SetParameterType('sortby',CLEAN_STRING);
    $this->SetParameterType('sortorder',CLEAN_STRING);
    $this->SetParameterType('template',CLEAN_STRING); 
    $this->SetParameterType('msgrequired',CLEAN_INT);
    $this->SetParameterType('coordsrequired',CLEAN_INT);
    $this->SetParameterType('noredirect',CLEAN_INT);

    // for togglefavorite
    $this->SetParameterType('dest',CLEAN_STRING);

    // for send friend request.
    $this->SetParameterType('user',CLEAN_INT);

    // parameters for list activities
    $this->SetParameterType('list_template',CLEAN_STRING);
    $this->SetParameterType('start',CLEAN_STRING);
    $this->SetParameterType('junk',CLEAN_STRING);
    $this->SetParameterType(CLEAN_REGEXP.'/cgs_.*/',CLEAN_STRING);

    $smarty = cmsms()->GetSmarty();
    $smarty->register_function('cgsa_get_favorites',array('cgsa_utils','smarty_get_favorites'));
    $smarty->register_function('cgsa_get_friends',array('cgsa_utils','smarty_get_friends'));
    $smarty->register_function('cgsa_togglefavorite_link',array('cgsa_utils','smarty_togglefavorite_link'));
    $smarty->register_function('cgsa_friendreq_link',array('cgsa_utils','smarty_friendreq_link'));
  }

  function InitializeAdmin()
  {
    $this->CreateParameter('checkin','',$this->Lang('param_checkin'));
    $this->CreateParameter('badge','',$this->Lang('param_badge'));
    $this->CreateParameter('action','',$this->Lang('param_action'));
    $this->CreateParameter('location','',$this->Lang('param_location'));
    $this->CreateParameter('activity','',$this->Lang('param_activity'));
    $this->CreateParameter('activityparent','',$this->Lang('param_activityparent'));
    $this->CreateParameter('timelimit','',$this->Lang('param_timelimit'));
    $this->CreateParameter('owner','',$this->Lang('param_owner'));
    $this->CreateParameter('owners','',$this->Lang('param_owners'));
    $this->CreateParameter('limit','',$this->Lang('param_limit'));
    $this->CreateParameter('offset','',$this->Lang('param_offset'));
    $this->CreateParameter('sortby','created',$this->Lang('param_sortby'));
    $this->CreateParameter('sortorder','DESC',$this->Lang('param_sortorder'));
    $this->CreateParameter('template','',$this->Lang('param_template'));
    $this->CreateParameter('list_template','',$this->Lang('param_list_template'));
    $this->CreateParameter('start','',$this->Lang('param_start'));
    $this->CreateParameter('msgrequired','',$this->Lang('param_msgrequired'));
    $this->CreateParameter('coordsrequired','',$this->Lang('param_coordsrequired'));
    $this->CreateParameter('noredirect','',$this->Lang('param_noredirect'));

    $this->CreateParameter('user','',$this->Lang('param_user'));
  }

  function VisibleToAdminUser()
  {
    return $this->CheckPermission(self::PERMISSION) ||
      $this->CheckPermission(self::PERMISSION_CHECKINS) ||
      $this->CheckPermission('Modify Site Preferences') ||
      $this->CheckPermission('Modify Templates');
  }

  function GetDependencies()
  {
    return array('FrontEndUsers'=>'1.21.14','CompanyDirectory'=>'1.18.1',
		 'CGExtensions'=>'1.32.6','CGSimpleSmarty'=>'1.5','CGJobMgr'=>'1.2.7',
		 'CGFavs'=>'1.0.5');
  }

  public function GetEventDescription($eventname)
  {
    return $this->Lang('describe_event_'.$eventname);
  }

  public function GetEventHelp($eventname)
  {
    return $this->Lang('help_event_'.$eventname);
  }

  public function get_pretty_url($id,$action,$returnid = '',$params = array(),$inline = false)
  {
    switch( $action ) {
    case 'view_activity':
      if( isset($params['activity']) && !isset($params['template']) ) {
	$activity = (int)$params['activity'];
	$obj = cgsa_activity::load_by_id($activity);
	if( is_object($obj) ) {
	  return sprintf("activity/%d/%d/%s",$returnid,$activity,munge_string_to_url($obj->name));
	}
      }
      break;
    }
  }

  /**
   * This method is used to update the applicable leaderboards givena checkin.
   * This is a protected member in this class, because putting it in another class would require it to be public.
   *
   * @internal
   * @access private
   * @ignore
   */
  protected function UpdateLeaderboards(cgsa_checkin $checkin)
  {
    // 1.  given the checkin ... find any and all matching leaderboards
    // for each match 
    //  increment the score for this user on that leaderboard
    //  then 
  }

  /**
   * Setup CGJobMgr Jobs
   *
   * @internal
   * @access private
   * @ignore
   */
  protected function SetupJobs()
  {
    $job = new cgjobmgr_job($this->GetName().' update leaderboards');
    $job->set_recur_interval($this->GetPreference('interval_updateleaderboards',15));
    $task = new cgjobmgr_iterativetask('process one leaderboard');
    $task->set_function(array('cgsa_leaderboard_tasks','update_one_leaderboard'));
    $job->add_task($task);
    $job->save();
    $this->SetPreference('job: update leaderboards',$job->id);

    $job = new cgjobmgr_job($this->GetName().' update badges');
    $job->set_recur_interval($this->GetPreference('interval_updatebadges',30));
    $task = new cgjobmgr_iterativetask('process badges for leaderboard');
    $task->set_function(array('cgsa_leaderboard_tasks','update_badges_for_leaderboard'));
    $job->add_task($task);
    $job->save();
  }
}

?>