<h3>What Does This Do?</h3>
<p>This module allows your e-commerce customers to view the invoices from the orders that they have created on your site in the past.  It reads the order information directly from the Orders module and uses an invoice template from the Orders module to generate invoices.</p>
<h3>Features:</h3>
<ul>
  <li>Support for anonymous users.
    <p>If you allow anonymous checkout, you can allow anonymous users to view their past orders merely by entering their email address.</p>
  </li>
  <li>Works with logged in Frontend Users
    <p>The default action will detect the currently logged in users user identifier, and query the database for the orders placed by that FEU user.</p>
  </li>
  <li>Allows limiting the number of views.
    <p>A module preference can be set to ensure that a user does not view an invoice more than N times.  This can be useful with digital downloads that generate time limited URLS from the invoice template.  Thereby your users cannot re-generate a time limited url to a download indefinately.</p>
  </li>
</ul>
<h3>How do I use it:</h3>
<p>Once the module is installed, you should visit the modules admin panel and adjust the settings to suit the needs on your site.</p>
<p>If you are not allowing anonymous checkout, then the simplest way to use this module is to place the <code>{CGMyOrders}</code> tag onto a page only accessible by logged in users.  This will immediately generate a list of the orders for that user.</p>
<p>If you are allowing anonymous checkout, you may want to call the module as follows: <code>{CGMyOrders action=&quot;userid&q
uot;}</code>.  This will provide a simple form that allows the user to enter their email address to find orders matching the email address.</p>
<h4>Reordering</h4>
<p>This feature allows some users to re-order items from a previous order.  It can be triggered by using the reorder action. i.e.: <code>{CGMyOrders action=&quot;reorder&quot; order='orderid'}</code>.</p>
<p>This feature has several limitations at this time:</p>
<ul>
  <li>A site preference indicates wether reordering is permitted at all.</li>
  <li>The order id must be provided.</li>
  <li>The user must be logged in to FEU.</li>
  <li>The owner for the order, and the userid must match.</li>
  <li>Instantaneous discounts will not be applied (but checkout based discounts will be).</li>
  <li>Does not in any way check for stock on hand.</li>
  <li>Works with product ids and not skus at this point. <em>(subject to change)</em> </li>
</ul>
  <p><strong>Tip:</strong> If you are allowing reordering, you may want to provide a reorder link on an invoice view.  Code similar to this should work fine:</p>
  <pre><code>{if isset($allow_reorder) && $allow_reorder && isset($reorder_url) && isset($CGMyOrders)}
&lt;a href="{$reorder_url}"&gt;{$CGMyOrders->Lang('reorder_this')}&lt;/a&gt;{/if}</code></pre>
  <p>Additionally, you could use the CGSimpleSmarty function <code>{module_action_link}</code> to build a url, and then an action to a reorder link.  i.e.:</p>
  <pre><code>{module_action_link module=CGMyOrders action=reorder order=$order_id text='Reorder This'}</code></pre>
<h3>Future Development</h3>
<p>Future versions of this module may include:
  <ul>
    <li>Extra security measures for the userid action.</li>
    <li>Sorting, Filtering, and pagination options for the order list view.</li>
    <li>The ability to communicate with the site administrators regarding issues with a particular order or invoice.</li>
  </ul>
</p>
<h3>Support:</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>For the latest version of this module, FAQs, or to file a Bug Report or buy commercial support, please visit calguy\'s
module homepage at <a href="http://calguy1000.com">calguy1000.com</a>.</li>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
<li>The author, calguy1000, can often be found in the <a href="irc://irc.freenode.net/#cms">CMS IRC Channel</a>.</li>
<li>Lastly, you may have some success emailing the author directly.</li>  
</ul>
<h3>Copyright and License:</h3>
<p>Copyright &copy; 2008, Robert Campbel <a href="mailto:calguy1000@cmsmadesimple.org">&lt;calguy1000@cmsmadesimple.org&gt;</a>. All Rights Are Reserved.</p>
<p>This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.</p>
<p>However, as a special exception to the GPL, this software is distributed
as an addon module to CMS Made Simple.  You may not use this software
in any Non GPL version of CMS Made simple, or in any version of CMS
Made simple that does not indicate clearly and obviously in its admin 
section that the site was built with CMS Made simple.</p>
<p>This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
Or read it <a href="http://www.gnu.org/licenses/licenses.html#GPL">online</a></p>