<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGMyOrders (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module to allow for customers to see and intereact with past
#  invoices.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->GetPreference('allow_reorder') ) return;

//
// NOTE: This action will only work with product id's and not sku's
// so, at this time, only for those sites that are using Cart and not Cart2
//

//
// initialize
//
$feu = cms_utils::get_module(MOD_FRONTENDUSERS);
if( !$feu ) return;
if( !$feu->LoggedInId() ) return;

$orders_mod = cms_utils::get_module(MOD_ORDERS);
$cart_mod = cg_ecomm::get_cart_module();
$the_template = $this->GetPreference('dflt_reorder_template');
if( isset($params['reordertemplate']) ) $the_template = trim($params['reordertemplate']);

//
// get parameters
//
if( !isset($params['order']) ) return;
$order_id = (int)$params['order'];
$order_obj = orders_ops::load_by_id($order_id);
if( !is_object($order_obj) ) {
  $this->Audit($order_id,$this->GetName(),'Attempt to reorder invalid order');
  return;
}

// get the items from the order
$destinations = $order_obj->get_destinations();
if( !is_array($destinations) || count($destinations) == 0 ) {
  $this->Audit($order_id,$this->GetName(),'Order does not have any destinations');
  return;
}

$item_ids = array();
$all_items = array();
for( $i = 0; $i < count($destinations); $i++ ) {
  $items = $destinations[$i]->get_items();
  if( !is_array($items) || count($items) == 0 ) {
    $this->Audit($order_id,$this->GetName(),'Order destination does not have any items');
    continue;
  }

  for( $j = 0; $j < count($items); $j++ ) {
    $item = $items[$j];
    if( $item->get_item_type() != line_item::ITEMTYPE_PRODUCT ) continue;
    if( strtolower($item->get_source()) != 'products' ) continue;
    if( $item->get_item_id() < 1 ) continue;
    if( $item->get_quantity() < 1 ) continue;

    $item_id = $item->get_item_id();
    $item_ids[] = $item_id;
    if( isset($all_items[$item_id]) ) {
      $tmp =& $all_items[$item_id];
      $tmp->set_quantity($tmp->get_quantity()+$item->get_quantity());
    }
    else {
      $all_items[$item_id] = $item;
    }
  }
}

if( count($all_items) == 0 ) {
  // uhm... problem here.
  $this->Audit($order_id,$this->GetName(),'Order does not have any valid items');
  return;
}

// load all the products
$found_ids = array();
$found_items = array();
$query = new products_query(array('productlist'=>$item_ids));
$rs = $query->execute();
while( !$rs->EOF() ) {
  $product = $rs->get_product();
  if( !is_object($product) ) {
    $this->Audit($order_id,$this->GetName(),'reorder action - some products could not be found');
    $rs->MoveNext();
    continue;
  }
  if( !isset($all_items[$product->id]) ) {
    // dunno how this could happen.
    $this->Audit($order_id,$this->GetName(),'reorder action - found a product we did not ask for');
    $rs->MoveNext();
    continue;
  }

  $line_item = $all_items[$product->id];
  $line_item->set_unit_price($product->price);
  $line_item->set_master_price(0);
  $found_ids[] = $product->id;
  $found_items[$product->id] = $line_item;
  $cart_item = new cg_ecomm_cartitem($product->sku,$product->id,$line_item->get_quantity());
  $cart_item->set_type($cart_item::TYPE_PRODUCT);
  $cart_item->set_source($line_item->get_source());
  $cart_item->set_product_id($line_item->get_item_id());
  $cart_item->set_unit_weight($line_item->get_weight());
  $cart_item->set_base_price($line_item->get_unit_price()); // use the product price.. not the price we originally bought it for.
  $cart_item->set_summary($line_item->get_description());
  $cart_mod->AddCartItem($cart_item);

  $rs->MoveNext();
}

//
// build our report
//

// calculate which products could not be found
$notfound_ids = array();
foreach( $item_ids as $one ) {
  if( !in_array($one,$found_ids) ) $notfound_ids[] = $one;
}
$notfound_items = array();
foreach( $notfound_ids as $one ) {
  if( !isset($all_items[$one]) ) continue;
  $notfound_items[$one] = $all_items[$one];
}

$smarty->assign('found_items',$found_items);
$smarty->assign('notfound_items',$notfound_items);
echo $this->ProcessTemplateFromDatabase('reorder_'.$the_template);

#
# EOF
#
?>