<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGMyOrders (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module to allow for customers to see and intereact with past
#  invoices.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

$cgextensions = cms_join_path($gCms->config['root_path'],'modules','CGExtensions','CGExtensions.module.php');
if( !is_readable( $cgextensions ) )
{
	echo '<h1><font color="red">ERROR: The CGExtensions module could not be found. Please install it.</font></h1>';
	return;
}
require_once($cgextensions);


final class CGMyOrders extends CGExtensions
{
  public function GetName() { return get_class($this); }
  public function GetFriendlyName() { return $this->Lang('friendlyname'); }
  public function GetVersion() { return '1.2'; }
  public function GetHelp() { return file_get_contents(__DIR__.'/help.inc'); }
  public function GetAuthor() { return 'Robert Campbell'; }
  public function GetAuthorEmail() { return 'calguy1000@cmsmadesimple.org'; }
  public function GetChangeLog() { return file_get_contents(__DIR__.'/changelog.inc'); }
  public function IsPluginModule() { return true; }
  public function HasAdmin() { return true; }
  public function GetAdminSection() { return 'ecommerce'; }
  public function GetAdminDescription() { return $this->Lang('moddescription'); }
  public function VisibleToAdminUser() {  
    return $this->CheckPermission('Modify Site Preferences') || $this->CheckPermission('Modify Templates');
  }
  public function GetDependencies()
  {
    return array('CGExtensions'=>'1.36',
		 'CGEcommerceBase'=>'1.4.3',
		 'Orders'=>'1.15.2');
  }
  public function MinimumCMSVersion() {  return '1.11.7'; }
  public function InstallPostMessage() { return $this->Lang('postinstall'); }
  public function UninstallPostMessage() { return $this->Lang('postuninstall'); }
  public function UninstallPreMessage() { return $this->Lang('really_uninstall'); }
  public function LazyLoadAdmin() {  return TRUE; }
  public function LazyLoadFrontend() {  return TRUE; }
	
  /**
   * @see CmsModule::SetParameters()
   * @abstract
   * @return void
   */
  public function SetParameters()
  {
    $this->RegisterModulePlugin();
    $this->RestrictUnknownParams();
    
    $this->CreateParameter('action','',$this->Lang('param_action'));
    $this->CreateParameter('useridtemplate','',$this->Lang('param_useridtemplate'));
    $this->CreateParameter('orderlisttemplate','',$this->Lang('param_orderlisttemplate'));
    $this->CreateParameter('reordertemplate','',$this->Lang('param_reordertemplate'));
    $this->CreateParameter('invoicetemplate','',$this->Lang('param_invoicetemplate'));
    $this->CreateParameter('order','',$this->Lang('param_order'));
    $this->CreateParameter('email','',$this->Lang('param_email'));

    $this->SetParameterType('useridtemplate',CLEAN_STRING);
    $this->SetParameterType('orderlisttemplate',CLEAN_STRING);
    $this->SetParameterType('reordertemplate',CLEAN_STRING);
    $this->SetParameterType('invoicetemplate',CLEAN_STRING);

    $this->SetParameterType('order',CLEAN_INT);
    $this->SetParameterType('email',CLEAN_STRING);
    $this->SetParameterType('userid_submit',CLEAN_STRING);
  }

} // class
