<?php
#-------------------------------------------------------------------------
# Module: Orders - A simple order processing module.
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in every page of
# its admin section that the site was built with CMS Made simple, and
# provide a link to the CMS Made Simple website.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class shipping_ops
{
  static public function &load_by_id($id)
    {
      // load the shipping record itself
      global $gCms;
      $db =& $gCms->GetDb();
      $query = 'SELECT * FROM '.cms_db_prefix().'module_orders_shipping
               WHERE id = ?';
      $row = $db->GetRow($query,array($id));
      if( !$row ) return FALSE;
      
      $shipping = new orders_shipping();
      $shipping->from_array($row);
      
      // load all the items.
      $query = 'SELECT id FROM '.cms_db_prefix().'module_orders_items
               WHERE shipping_id = ? ORDER BY item_type ASC';
      $tmp = $db->GetCol($query,array($id));
      foreach( $tmp as $item_id )
	{
	  $line_item = lineitem_ops::load_by_id($item_id);
	  $shipping->add_item($line_item,false);
	}
      return $shipping;
    }


  static public function insert(orders_shipping &$shipping)
  {
    global $gCms;
    $db =& $gCms->GetDb();
    $now = $db->DbTimeStamp(time());
    $query = 'INSERT INTO '.cms_db_prefix()."module_orders_shipping
              (order_id,name,shipping_company,
               shipping_first_name,shipping_last_name,shipping_address1,
               shipping_address2,shipping_city,shipping_state,shipping_postal,
               shipping_country,shipping_phone,shipping_fax,shipping_email,
               shipping_message,create_date,modified_date)
              VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,$now,$now)";

    $address = $shipping->get_shipping_address();
    $dbr = $db->Execute($query,
			array($shipping->get_order_id(),
			      $shipping->get_name(),
                              $address->get_company(),
			      $address->get_firstname(),
			      $address->get_lastname(),
			      $address->get_address1(),
			      $address->get_address2(),
			      $address->get_city(),
			      $address->get_state(),
			      $address->get_postal(),
			      $address->get_country(),
			      $address->get_phone(),
			      $address->get_fax(),
			      $address->get_email(),
			      $shipping->get_message()));

    if( !$dbr )
      {
	throw cg_db_error($db->sql."\n".$db->ErrorMsg());
	return FALSE;
      }
    $shipping->set_id($db->Insert_Id());
    $shipping->set_create_date($now);
    $shipping->set_modified_date($now);

    // insert the items.
    for( $i = 0; $i < $shipping->count_all_items(); $i++ )
      {
	$line_item =& $shipping->get_item($i);
	if( $line_item )
	  {
	    $line_item->set_order_id($shipping->get_order_id());
	    $line_item->set_shipping_id($shipping->get_id());
	    $line_item->set_id(null);
	    $res = $line_item->save();
	    if( !$res ) return FALSE;
	  }
      }
    return TRUE;
  }


  static public function update(orders_shipping &$shipping)
  {
    global $gCms;
    $db =& $gCms->GetDb();
    $now = $db->DbTimeStamp(time());
    $query = 'UPDATE '.cms_db_prefix()."module_orders_shipping
                SET order_id = ?,
                    shipping_company = ?,
                    shipping_first_name = ?,
                    shipping_last_name = ?,
                    shipping_address1 = ?,
                    shipping_address2 = ?,
                    shipping_city = ?,
                    shipping_state = ?,
                    shipping_postal = ?,
                    shipping_country = ?,
                    shipping_phone = ?,
                    shipping_fax = ?,
                    shipping_email = ?,
                    shipping_message = ?,
                    modified_date = $now
              WHERE id = ?";

    $address = $shipping->get_shipping_address();
    $dbr = $db->Execute($query,
			array($shipping->get_order_id(),
                              $address->get_company(),
			      $address->get_firstname(),
			      $address->get_lastname(),
			      $address->get_address1(),
			      $address->get_address2(),
			      $address->get_city(),
			      $address->get_state(),
			      $address->get_postal(),
			      $address->get_country(),
			      $address->get_phone(),
			      $address->get_fax(),
			      $address->get_email(),
			      $shipping->get_message(),
			      $shipping->get_id()));

    if( !$dbr ) 
      {
	throw cg_db_error($db->sql."\n".$db->ErrorMsg());
	return FALSE;
      }

    // insert the items.
    for( $i = 0; $i < $shipping->count_all_items(); $i++ )
      {
	$line_item =& $shipping->get_item($i);
	$res = $line_item->save();
	if( !$res ) return FALSE;
      }
    return TRUE;
  }

  static public function delete_by_id($id)
  {
    // a. delete the items
    $query = 'DELETE FROM '.cms_db_prefix().'module_orders_items 
               WHERE shipping_id = ?';
    $dbr = $db->Execute($query,array($id));
    if( !$dbr ) return FALSE;

    // b. delete the shipping.
    $query = 'DELETE FROM '.cms_db_prefix().'module_orders_shipping
               WHERE id = ?';
    $dbr = $db->Execute($query,array($id));
    if( !$dbr ) return FALSE;
    
    return TRUE;
  }
} // end class.

// EOF
?>