<?php
#-------------------------------------------------------------------------
# Module: Orders - A simple order processing module.
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in every page of
# its admin section that the site was built with CMS Made simple, and
# provide a link to the CMS Made Simple website.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class orders_shipping
{
  private $_id;
  private $_name;
  private $_order_id;
  private $_shipping_address;
  private $_message;
  private $_create_date;
  private $_modified_date;
  private $_lineitems;


  public function get_id()
  {
    return $this->_id;
  }


  public function set_id($val)
  {
    $this->_id = $val;
  }


  public function get_name()
  {
    return $this->_name;
  }


  public function set_name($val)
  {
    $this->_name = $val;
  }


  public function get_order_id()
  {
    return $this->_order_id;
  }


  public function set_order_id($val)
  {
    $this->_order_id = $val;
  }


  public function get_shipping_address()
  {
    return $this->_shipping_address;
  }


  public function set_shipping_address($val)
  {
    $this->_shipping_address = $val;
  }


  public function get_message()
  {
    return $this->_message;
  }


  public function set_message($val)
  {
    $this->_message = $val;
  }


  public function get_create_date()
  {
    return $this->_create_date;
  }


  public function set_create_date($val)
  {
    $this->_create_date = $val;
  }


  public function get_modified_date()
  {
    return $this->_modified_date;
  }


  public function set_modified_date($val)
  {
    $this->_modified_date = $val;
  }


  public function add_item(line_item &$item,$new = true)
  {
    if( $new ) $item->set_id(null);
    $item->set_order_id($this->get_order_id());
    $item->set_shipping_id($this->get_id());
    if( !is_array($this->_lineitems) ) $this->_lineitems = array();
    $this->_lineitems[] = $item;
  }


  public function del_item($idx)
  {
    $new = array();
    for( $i = 0; $i < count($this->_lineitems); $i++ ) {
      if( $i != $idx ) $new[] = $this->_lineitems[$i];
    }
  }


  public function get_items()
  {
    return $this->_lineitems;
  }


  public function &get_item($idx)
  {
    if( $idx >= 0 && $idx < $this->count_all_items() ) return $this->_lineitems[$idx];
  }


  public function set_item($idx,line_item $item)
  {
    if( $idx < $this->count_all_items() && $idx >= 0 ) $this->_lineitems[$idx] = $item;
  }


  public function count_real_items()
  {
    $count = 0;
    for( $i = 0; $i < $this->count_all_items(); $i++ ) {
      $item =& $this->_lineitems[$i];
      $type = $item->get_item_type();
      switch( $type ) {
      case line_item::ITEMTYPE_TAX:
      case line_item::ITEMTYPE_SHIPPING:
      case line_item::ITEMTYPE_DISCOUNT:
	break;
      default:
	$count += $item->get_quantity();
	break;
      }
    }
    return $count;
  }


  public function count_items()
  {
    $count = 0;
    for( $i = 0; $i < $this->count_all_items(); $i++ ) {
      $item =& $this->_lineitems[$i];
      $type = $item->get_item_type();
      switch( $type ) {
      case line_item::ITEMTYPE_TAX:
      case line_item::ITEMTYPE_SHIPPING:
      case line_item::ITEMTYPE_DISCOUNT:
	break;
      default:
	$count++;
	break;
      }
    }
    return $count;
  }


  public function count_all_items()
  {
    $count = 0;
    if( is_array($this->_lineitems) ) $count = count($this->_lineitems);
    return $count;
  }


  public function get_weight()
  {
    $weight = 0;
    for( $i = 0; $i < $this->count_all_items(); $i++ ) {
      $item =& $this->_lineitems[$i];
      switch( $item->get_item_type() ) {
      case line_item::ITEMTYPE_PRODUCT:
	$weight += $item->get_weight() * $item->get_quantity();
	break;
      default:
	break;
      }
    }
    return $weight;
  }


  public function get_subtotal()
  {
    $subtotal = 0;
    for( $i = 0; $i < $this->count_all_items(); $i++ ) {
      $item =& $this->_lineitems[$i];
      switch( $item->get_item_type() ) {
      case line_item::ITEMTYPE_TAX:
      case line_item::ITEMTYPE_SHIPPING:
      case line_item::ITEMTYPE_DISCOUNT:
	break;
      default:
	$subtotal += max($item->get_quantity() * $item->get_unit_price(),$item->get_master_price());
	break;
      }
    }
    return $subtotal;
  }


  public function get_shipping_cost()
  {
    $shipping = 0;
    for( $i = 0; $i < $this->count_all_items(); $i++ ) {
      $item =& $this->_lineitems[$i];
      switch( $item->get_item_type() ) {
      case line_item::ITEMTYPE_SHIPPING:
	$shipping += $item->get_net_price();
	break;
      default:
	break;
      }
    }
    return $shipping;
  }


  public function get_tax_cost()
  {
    $tax = 0;
    for( $i = 0; $i < $this->count_all_items(); $i++ ) {
      $item =& $this->_lineitems[$i];
      switch( $item->get_item_type() ) {
      default:
	break;

      case line_item::ITEMTYPE_TAX:
	$tax += $item->get_net_price();
	break;
      }
    }
    return $tax;
  }


  public function get_discount()
  {
    $discount = 0;
    for( $i = 0; $i < $this->count_all_items(); $i++ ) {
      $item =& $this->_lineitems[$i];
      switch( $item->get_item_type() ) {
      case line_item::ITEMTYPE_TAX:
      case line_item::ITEMTYPE_SHIPPING:
	break;

      case line_item::ITEMTYPE_DISCOUNT:
      default:
	$discount += ($item->get_discount() * $item->get_quantity());
	break;
      }
    }
    return $discount;
  }


  public function get_total()
  {
    return $this->get_subtotal() + $this->get_shipping_cost() + $this->get_tax_cost() + $this->get_discount();
  }

  
  public function is_all_shipped()
  {
    for( $i = 0; $i < $this->count_all_items(); $i++ ) {
      $item =& $this->_lineitems[$i];
      if( $item->get_status() != ITEMSTATUS_SHIPPED && $item->get_item_type() == line_item::ITEMTYPE_PRODUCT ) {
	return FALSE;
      }
    }
    return TRUE;
  }


  public function is_partially_shipped()
  {
    $have_shipped = false;
    $have_unshipped = false;
    for( $i = 0; $i < $this->count_all_items(); $i++ ) {
      $item =& $this->_lineitems[$i];
      if( $item->get_item_type() == line_item::ITEMTYPE_PRODUCT ) {
	if( $item->get_status() == ITEMSTATUS_SHIPPED )
	  $have_shipped = true;
	else if( $item->get_status() == ITEMSTATUS_NOTSHIPPED )
	  $have_unshipped = true;
      }
    }
    return ($have_shipped && $have_unshipped);
  }


  public function has_services()
  {
    for( $i = 0; $i < $this->count_all_items(); $i++ ) {
      $item =& $this->_lineitems[$i];
      if( $item->get_item_type() == line_item::ITEMTYPE_SERVICE ) return TRUE;
    }
    return FALSE;
  }


  public function is_service_only()
  {
    $have_products = FALSE;
    for( $i = 0; $i < $this->count_all_items(); $i++ ) {
      $item =& $this->_lineitems[$i];
      if( $item->get_item_type() == line_item::ITEMTYPE_PRODUCT ) {
	$have_products = TRUE;
	break;
      }
    }
    return !$have_products;
  }


  public function has_subscriptions()
  {
    for( $i = 0; $i < $this->count_all_items(); $i++ ) {
      $item =& $this->_lineitems[$i];
      if( $item->is_subscription() ) return TRUE;
    }
    return FALSE;
  }


  public function is_subscription_only()
  {
    $have_other = FALSE;
    $have_subscr = FALSE;
    for( $i = 0; $i < $this->count_all_items(); $i++ ) {
      $item =& $this->_lineitems[$i];
      if( $item->is_subscription() ) {
	$have_subscr = TRUE;
      }
      else if( $item->get_item_type() == line_item::ITEMTYPE_PRODUCT ||
	       $item->get_item_type() == line_item::ITEMTYPE_SERVICE ) {
	// make sure we exclude discount, shipping, and tax items.
	$have_other = TRUE;
      }
    }
    return ($have_subscr && !$have_other);
  }


  public function save()
  {
    if( $this->get_id() > 0 ) return shipping_ops::update($this);
    return shipping_ops::insert($this);
  }


  public function from_array($data)
  {
    $this->set_id($data['id']);
    $this->set_name($data['name']);
    $this->set_order_id($data['order_id']);
    $this->set_message($data['shipping_message']);
    $this->set_create_date($data['create_date']);
    $this->set_modified_date($data['modified_date']);
    $addr = new orders_address;
    $addr->from_array($data,'shipping_');
    $this->set_shipping_address($addr);
  }


  public function to_array()
  {
    // for backward compatibilty... remove me soon.
    $result = array();
    $result['id'] = $this->get_id();
    $result['name'] = $this->get_name();
    $result['order_id'] = $this->get_order_id();
    $result['message'] = $this->get_message();
    $result['create_date'] = $this->get_create_date();
    $result['modified_date'] = $this->get_modified_date();

    $addr = $this->get_shipping_address();
    $tmp = $addr->to_array('shipping_');
    $result = array_merge($tmp,$result);

    $result['items'] = array();
    for( $i = 0; $i < $this->count_all_items(); $i++ ) {
      $item = $this->get_item($i);
      $result['items'][] = $item->to_array();
    }

    $result['subtotal'] = $this->get_subtotal();
    $result['discount'] = $this->get_discount();
    $result['tax'] = $this->get_tax_cost();
    $result['shipping_total'] = $this->get_shipping_cost();
    $result['total'] = $this->get_total();

    return $result;
  }


  public function reset_ids()
  {
    $this->set_id(null);
    $this->set_order_id(null);
    for( $i = 0; $i < $this->count_all_items(); $i++ ) {
      $item =& $this->get_item($i);
      $item->reset_ids();
    }
  }
} // end of class

// EOF
?>