<?php
#-------------------------------------------------------------------------
# Module: Orders - A simple order processing module.
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in every page of
# its admin section that the site was built with CMS Made simple, and
# provide a link to the CMS Made Simple website.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class orders_helper extends module_helper
{
  static private $_encryption_key;
  static private $_invoice_prefix;
  static private $_security_key;

  protected function __construct() {}

  static public function &instance()
  {
    return self::get_instance('Orders');
  }

  static public function get_encryption_key()
  {
    if( is_null(self::$_encryption_key) ) {
      $module = self::instance();
      self::$_encryption_key = $module->_getRealEncryptionKey();
    }
    return self::$_encryption_key;
  }


  static public function can_manage_orders()
  {
    $module = self::instance();
    if( $module->CheckPermission(ORDERS_PERM_MANAGEORDERS) )
      {
	return TRUE;
      }
    return FALSE;
  }


  static public function postal_required()
  {
    $module = self::instance();
    return $module->GetPreference('require_postalcode',1);
  }


  static public function state_required()
  {
    $module = self::instance();
    return $module->GetPreference('require_state',1);
  }


  static public function set_invoice_prefix($txt)
  {
    self::$_invoice_prefix = $txt;
  }


  static public function make_invoice_number($order_id,$prefix = '')
  {
    if( !$prefix ) {
      $module = self::instance();
      $prefix = $module->GetPreference('ordernum_prefix','INV');
      if( !is_null(self::$_invoice_prefix) ) {
	$prefix = self::$_invoice_prefix;
      }
    }
    return $prefix.sprintf('%05d',$order_id);
  }


  static public function is_creditcard_number($str)
  {
    // uses the luhn/mod-10 algorithm.
    $number = preg_replace('/\D/', '', $number);
    $len = strlen($number);
    $parity = $len % 2;

    $total = 0;
    for( $i = 0; $i < $len; $i++ ) {
      $digit = $number[$i];
      if( $i % 2 == $parity ) {
	$digit *= 2;
	if( $digit > 9 ) $digit -= 9;
      }
      $total += $digit;
    }
    return ($total %10 == 0) ? TRUE : FALSE;
  }


  static public function requires_creditcard_number()
  {
    $module = self::instance();
    $allow_creditcard = $module->GetPreference('allow_creditcard_entry');
    $gateway_requires_creditcard = '';
    {
      $gateway_module = cg_ecomm::get_payment_module();
      if( is_object($gateway_module) )
	{
	  $gateway_requires_creditcard = $gateway_module->RequiresCreditCardInfo();
	}
    }
    if( $allow_creditcard || $gateway_requires_creditcard ) 
      {
	return TRUE;
      }
    return FALSE;
  }


  static public function creditcard_requires_ssl()
  {
    $module = self::instance();
    $force_ssl = $module->GetPreference('force_ssl');
    $requires_creditcard = self::requires_creditcard_number();
    $gateway_module = cg_ecomm::get_payment_module();
    $gateway_requires_ssl = FALSE;
    if( is_object($gateway_module) )
      {
	$gateway_requires_ssl = $gateway_module->RequiresSSL();
      }
    return ($force_ssl || $gateway_requires_ssl);
  }


  static public function is_valid_user()
  {
    $module = self::instance();
    $uid = -1;
  
    $feu = cge_utils::get_module('FrontEndUsers');
    if( !$feu && !$module->GetPreference('allow_anon_checkout',0) ) return FALSE;

    $tuid = $feu->LoggedInId();
    if( $tuid <= 0 ) {
      if( ! $module->GetPreference('allow_anon_checkout',0) ) {
	return FALSE;
      }

      // returns -1 ... for anonymous checkout
      return $uid;
    }
    $uid = $tuid;

    // user is logged in.
    $grpid = $module->GetPreference('require_membership',-1);
    if( $grpid <= 0 ) return $uid;

    // we require membership in a specific group
    $data = $feu->GetMemberGroupsArray($uid);
    $gids = cge_array::extract_field($data,'groupid');
    if( !in_array( $grpid, $gids ) ) {
      return FALSE;
    }

    return $uid;
  }


  static public function get_security_key()
  {
    if( is_null(self::$_security_key) ) {
      $uid = self::is_valid_user();
      if( $uid !== FALSE ) {
	$config = cmsms()->GetConfig;
	$key = $config['root_url'].$uid.session_id().cge_utils::get_real_ip();
	self::$_security_key = 'c_'.md5($key);
      }
    }
    return self::$_security_key;
  }


  /**
   * estimate packages for shipping
   *
   * returns mixed ... error message or array of cg_ecomm_packaging_box items.
   */
  public static function estimate_packages(orders_order& $order)
  {
    $generator = new cg_ecomm_package_generator();
    
    // for each destination
    $dests = $order->get_destinations();
    foreach( $dests as $one_dest ) {
      $items = $one_dest->get_items();
      foreach( $items as $one_item ) {
	// only products are shippable.
	if( $one_item->get_item_type() != line_item::ITEMTYPE_PRODUCT ) continue;

	// todo: check for unit conversion to metric
	$box = new cg_ecomm_packaging_box($one_item->get_id(),$one_item->get_weight(),0);
	$info = cg_ecomm::get_product_info($one_item->get_source(),$one_item->get_item_id());
	if( !is_object($info) ) {
	  throw new Exception('Could not get product info for a product');
	}
	$dimensions = $info->get_dimensions();
	if( !$dimensions || count($dimensions) != 3 || $dimensions[0] <= 0 || $dimensions[1] <= 0 || $dimensions[2] <= 0 ){
	  audit($one_item->get_item_id(),$one_item->get_source(),'Invalid dimensions for packaging');
	  continue;
	}

	$box['length'] = $dimensions[0];
	$box['width'] = $dimensions[1];
	$box['height'] = $dimensions[2];
	$box['weight'] = $one_item->get_weight();

	// box dimensions need to be in metric (cm and kg)
	if( !cge_units::is_weight_metric(cg_ecomm::get_weight_units()) ) {
	  $box['weight'] *= cge_units::KG_TO_LBS;
	}
	if( !cge_units::is_length_metric(cg_ecomm::get_length_units()) ) {
	  $box['width'] *= cge_units::KG_TO_LBS;
	  $box['height'] *= cge_units::KG_TO_LBS;
	  $box['length'] *= cge_units::KG_TO_LBS;
	}

	$generator->add_item($box);
      }
    }

    $res = $generator->calculate();
    if( !$res ) {
      // error ooccurred
      return $generator->get_error();
    }

    return $generator->get_packages();
  }
}

#
# EOF
#
?>