<?php
#-------------------------------------------------------------------------
# Module: Orders - A simple order processing module.
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in every page of
# its admin section that the site was built with CMS Made simple, and
# provide a link to the CMS Made Simple website.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class order_maker
{
  const ADDR_POLICY_COOKIE = 'addr::cookie';
  const ADDR_POLICY_FEU = 'addr::from_feu';
  const ADDR_POLICY_LAST = 'addr::from_last';
  const ADDR_POLICY_NONE = 'addr::none';

  private $_this_module = NULL;
  private $_cart_module = NULL;
  private $_feu_module = NULL;
  private $_billing_address_policy = self::ADDR_POLICY_LAST;
  private $_uid = -1;
  private $_shipping_addresses;

  public function __construct(&$this_module)
  {
    $this->_this_module = $this_module;
    $this->_feu_module = $this_module->GetModuleInstance('FrontEndUsers');
    $this->_shipping_addresses = array();
  }

  public function set_cart_module(&$cart_module)
  {
    $this->_cart_module = $cart_module;
  }

  public function set_feu_module(&$feu_module)
  {
    $this->_feu_module = $feu_module;
  }

  public function set_user_id($uid)
  {
    $this->_uid = $uid;
  }

  public function set_address_policy($policy)
  {
    if( $policy == order_maker::ADDR_POLICY_LAST || 
	$policy == order_maker::ADDR_POLICY_FEU  ||
	$policy == order_maker::ADDR_POLICY_NONE ||
	$policy == order_maker::ADDR_POLICY_COOKIE ) {
      $this->_billing_address_policy = $policy;
    }
  }

  protected function &_get_feu_address()
  {
    $badresult = FALSE;
    $uid = orders_helper::is_valid_user();
    if( $uid <= 0 ) return $badresult;

    $serialized = $this->_this_module->GetPreference('address_map');
    if( !$serialized ) return $badresult;
    
    // get the map from the preference and unserialize.
    $addr_map = unserialize($serialized);

    // now, get the feu users properties.
    $feu = $this->_feu_module;
    $tmp = $feu->GetUserProperties($uid);
    if( !$tmp ) return $badresult;
    $userprops = cge_array::to_hash($tmp,'title');
    
    $new_addr_array = array();
    foreach( $addr_map as $key => $value ) {
      if( $key == '' || $key == -1 ) continue;
      if( $value == -1 ) $new_addr_array[$key] = '';
      if( $value == '__USERNAME__' ) {
	// the username is the email address.
	$new_addr_array[$key] = $feu->LoggedInName();
      }
      else if ($value == '__EMAIL__' ) {
	$new_addr_array[$key] = $feu->GetEmail($uid);
      }
      else {
	$new_addr_array[$key] = $userprops[$value]['data'];
      }
    }

    $address = new orders_address();
    $address->from_array($new_addr_array,'');
    return $address;
  }


  protected function &_get_last_billing_addr()
  {    
    $ret = null;
    if( $this->_uid <= 0 ) return $ret;

    $last_order_id = orders_ops::find_last_feu_order($this->_uid);
    if( $last_order_id ) {
      $tmp_order = orders_ops::load_by_id($last_order_id);
      $ret = $tmp_order->get_billing();
    }
    return $ret;
  }


  private function &_cart_item_to_line_item(cg_ecomm_cartitem &$basket_item)
  {
    $new_line_item = null;
    // pending/proposed/estimated items don't get added here.
    if( $basket_item->get_pending() || $basket_item->is_estimated() ) return $new_line_item;

    $new_line_item = new line_item();
    $cart_type= $basket_item->get_type();
    $new_type = line_item::ITEMTYPE_PRODUCT;
    switch($cart_type) {
    case cg_ecomm_cartitem::TYPE_SERVICE:
      $new_type = line_item::ITEMTYPE_SERVICE;
      break;
    case cg_ecomm_cartitem::TYPE_SHIPPING:
      $new_type = line_item::ITEMTYPE_SHIPPING;
      break;
    case cg_ecomm_cartitem::TYPE_TAXES:
      $new_type = line_item::ITEMTYPE_TAXES;
      break;
    case cg_ecomm_cartitem::TYPE_DISCOUNT:
      $new_type = line_item::ITEMTYPE_DISCOUNT;
      break;
    case cg_ecomm_cartitem::TYPE_OTHER:
      $new_type = line_item::ITEMTYPE_OTHER;
      break;
    case cg_ecomm_cartitem::TYPE_PRODUCT:
    default:
      $new_type = line_item::ITEMTYPE_PRODUCT;
      break;
    }
    
    $new_line_item->set_item_type($new_type);
    $new_line_item->set_item_id($basket_item->get_product_id());
    $new_line_item->set_quantity($basket_item->get_quantity());
    $new_line_item->set_unit_price($basket_item->get_unit_price());
    $new_line_item->set_weight($basket_item->get_unit_weight());
    $new_line_item->set_description($basket_item->get_summary());
    $new_line_item->set_discount($basket_item->get_unit_discount());
    $new_line_item->set_status(ITEMSTATUS_NOTSHIPPED);
    $new_line_item->set_sku($basket_item->get_sku());
    $new_line_item->set_source($basket_item->get_source());
    $new_line_item->set_master_price($basket_item->get_item_total());

    $tmp = $basket_item->get_subscription();
    if( $tmp ) {
      $new_line_item->set_subscr_payperiod($tmp->get_payperiod());
      $new_line_item->set_subscr_delperiod($tmp->get_deliveryperiod());
      $expires = $tmp->get_expiry();
      if( $expires > 0 ) {
	$t2 = strtotime(sprintf('+%d months',$expires));
	if( $t2 ) {
	  $t2 = cge_date_utils::ts_to_dbformat($t2);
	  $new_line_item->set_subscr_expires($t2);
	}
      }
    }
    return $new_line_item;
  }


  private function &_line_item_to_cart_item(line_item &$line_item)
  {
    $obj = new cg_ecomm_cartitem($line_item->get_sku(),$line_item->get_item_id(),$line_item->get_quantity());
    $obj->set_unit_price($line_item->get_unit_price());
    $obj->set_unit_weight($line_item->get_weight());
    $obj->set_summary($line_item->get_description());
    $obj->set_source($line_item->get_source());
    $obj->set_item_total($line_item->get_master_price());
    switch( $line_item->get_item_type() ) {
    case line_item::ITEMTYPE_PRODUCT:
      $obj->set_type($obj::TYPE_PRODUCT);
      break;

    case line_item::ITEMTYPE_SERVICE:
      $obj->set_type($obj::TYPE_SERVICE);
      break;

    case line_item::ITEMTYPE_DISCOUNT:
    case line_item::ITEMTYPE_SHIPPING:
    case line_item::ITEMTYPE_TAX:
      $obj->set_type($obj::TYPE_OTHER);
      break;
    }
    return $obj;
  }


  protected function _get_line_items(orders_shipping &$destination)
  {
    $cart_items = $this->_cart_module->GetBasketItems($destination->get_name(),$this->_uid);
    if( !is_array($cart_items) || count($cart_items) == 0 ) {
      // no items in this basket
      continue;
    }
    
    // get the supplier module name... right now we make an assumption that you can only check out from
    // one supplier at a time... in order to fix that we would need to have to have promotions with
    // supplier information.
    $supplier_mod = $cart_items[0]->get_source();

    // see if we're gonna discount anything here.
    $offer = null;
    $tester = cg_ecomm::get_promotions_tester();
    if( $tester ) {
      $tester->set_promo_type($tester::TYPE_CHECKOUT);
      $tester->set_cart($cart_items);
      $offers = $tester->find_all_cart_matches();
    }

    if( is_array($offers) && count($offers) ) {
      foreach( $offers as $offer ) {
	$free_cart_item = null;
	if( is_object($offer) ) {
	  switch( $offer->get_type() ) {
	  case $offer::OFFER_PRODUCTID:
	    // add a new product (by id) free, to the end of the cart
	    $free_product = cg_ecomm::get_product_info($supplier_mod,$offer->get_val());
	    $free_cart_item = new cg_ecomm_cartitem($free_product->get_sku(),
						    $free_product->get_product_id(),1,
						    $supplier_mod);
	    $free_cart_item->set_unit_weight($free_product->get_weight());
	    $free_cart_item->set_promo($offer->get_promo());
	    $free_cart_item->set_unit_price($free_product->get_price());
	    $free_cart_item->set_unit_discount($free_product->get_price() * -1);
	    $free_cart_item->set_allow_remove(FALSE);
	    $free_cart_item->set_summary($free_product->get_name());
	    $free_cart_item->set_allow_quantity_adjust(FALSE);
	    break;

	  case $offer::OFFER_PRODUCTSKU:
	    $free_product = cg_ecomm::get_product_by_sku($supplier_mod,$offer->get_val());
	    $base_price = $free_product->get_price();
	    $opt = $free_product->get_option_by_sku($offer->get_val());
	    $free_cart_item = new cg_ecomm_cartitem($free_product->get_sku(),$free_product->get_product_id(),1,$supplier_mod);
	    $free_cart_item->set_summary($free_product->get_name());
	    $free_cart_item->set_unit_weight($free_product->get_weight());
	    $free_cart_item->set_sku($offer->get_val());
	    if( is_object($opt) ) {
	      $free_cart_item->set_sku($opt->sku);
	      $base_price = $opt->parse_adjustment($free_product->get_price());
	      $free_cart_item->set_summary($free_product->get_name().': '.$opt->text);
	    }
	    $free_cart_item->set_unit_price($base_price);
	    $free_cart_item->set_unit_discount($base_price * -1);
	    $free_cart_item->set_allow_remove(FALSE);
	    $free_cart_item->set_allow_quantity_adjust(FALSE);
	    break;

	  case $offer::OFFER_DISCOUNT:
	    if( ($idx = $offer->get_cart_idx()) > 0 ) {
	      // we're discounting a certain cart index
	      if( $idx >= 0 && $idx < count($cart_items) ) {
		$item =& $cart_items[$idx];
		if( $item->get_unit_discount() == '' && $item->get_parent() == -1 ) {
		  $val = abs($offer->get_val());
		  $val = min($val,$item->get_unit_price());
		  $item->set_unit_discount($val * -1);
		}
	      }
	    }
	    else {
	      // add a new discount line item.
	      $free_cart_item = new cg_ecomm_cartitem('','',1,'Promotions');
	      $free_cart_item->set_promo($offer->get_promo());
	      $free_cart_item->set_unit_discount($offer->get_val() * -1);
	      $free_cart_item->set_allow_remove(FALSE);
	      $free_cart_item->set_type($free_cart_item::TYPE_DISCOUNT);
	      $free_cart_item->set_summary($offer->get_name());
	      $free_cart_item->set_allow_quantity_adjust(FALSE);
	    }
	    break;

	  case $offer::OFFER_PERCENT:
	    if( ($idx = $offer->get_cart_idx()) > -1 ) {
	      // a percentage off a certain cart index.
	      if( $idx >= 0 && $idx < count($cart_items) ) {
		$item =& $cart_items[$idx];
		if( ($item->get_unit_discount() == '' && $item->get_parent() == -1) || 
		    $offer->get_cumulative() ) {
		  $val = abs($offer->get_val());
		  $val = min($val,1.0);
		  $discount = $item->get_unit_dscount() + $item->get_unit_price()*$val*-1;
		  $discount = max($item->get_unit_price()*-1,$discount);
		  $item->set_unit_discount($discount);
		}
	      }
	    }
	    else {
	      // percentage off order total.
	      $val = abs($offer->get_val());
	      $val = min($val,1.0);

	      if( $offer->get_cumulative() ) {
		$total = 0;
		foreach( $cart_items as &$item ) {
		  if( $item->get_type() != cg_ecomm_cartitem::TYPE_DISCOUNT ) {
		    $total += $item->get_unit_price() * $item->get_quantity();
		  }
		}
		// add a new discount line item.
		$discount = $total * $val * -1;
		$discount = max($total*-1,$discount);
		if( $discount < 0 ) {
		  $free_cart_item = new cg_ecomm_cartitem('','',1,'Promotions');
		  $free_cart_item->set_promo($offer->get_promo());
		  $free_cart_item->set_unit_discount($discount);
		  $free_cart_item->set_allow_remove(FALSE);
		  $free_cart_item->set_type($free_cart_item::TYPE_DISCOUNT);
		  $free_cart_item->set_summary($offer->get_name());
		  $free_cart_item->set_allow_quantity_adjust(FALSE);
		}
	      }
	      else {
		foreach( $cart_items as &$item ) {
		  if( ($item->get_unit_discount() == '' && $item->get_parent() == -1) ) {
		    $discount = $item->get_unit_discount() + $item->get_unit_price()*$val*-1;
		    $discount = max($item->get_unit_price()*-1,$discount);
		    $item->set_unit_discount($discount);
		  }
		}
	      }
	    }
	    break;
	  }
	}

	// this adds the new cart item to the list.
	if( $free_cart_item ) $cart_items[] = $free_cart_item;
      }
    }

    // create line items for the cart items.
    $line_items = array();
    foreach( $cart_items as $one ) {
      $tmp = $this->_cart_item_to_line_item($one);
      if( is_object($tmp) ) $line_items[] = $tmp;
    }

    return $line_items;
  }


  protected function _adjust_line_items_for_discounts($uid,&$items)
  {
    if( !is_array($items) || count($items) == 0 ) {
      return FALSE;
    }

    $new_items = array();
    $params = array();
    $params['uid'] = $uid;
    $params['items'] = $items;
    $params['new_items'] =& $new_items;
    Events::SendEvent('Orders','CalculateDiscounts',$params);

    if( isset($params['new_items']) && is_array($params['new_items']) && count($params['new_items']) ) {
      $items = $params['new_items'];
    }

    // this stuff is deprecated... make promotions listen to the event.
    $promotionsmodule = cg_ecomm::get_promotions_module();
    if( !$promotionsmodule ) return FALSE;

    // calculate a subtotal, and a weight
    $subtotal = 0;
    $weight = 0;
    for( $i = 0; $i < count($items); $i++ ) {
      $item = $items[$i];
      $subtotal += $item->get_quantity() * $item->get_unit_price();
      $weight += $item->get_quantity() * $item->get_weight();
    }
    $res = $promotionsmodule->FindPromotions($uid,$items,$subtotal,$weight);
    if( $res ) {
      // replace items with adjusted ones.
      $items = $res;
      return TRUE;
    }
    return FALSE;
  }


  private function _calculate_item_taxes(line_item $oneitem,&$cumulative_taxes)
  {
    $taxmodule = cg_ecomm::get_tax_module();
    if( !$taxmodule ) return FALSE;

    $tax_array = '';
    if( method_exists($taxmodule,'get_taxes_for_item') ) {
      $tax_array = $taxmodule->get_taxes_for_item($oneitem);
    }
    else {
      $tax_array = $taxmodule->GetTaxesForProduct($oneitem->get_net_price(),$oneitem->get_quantity());
    }
    if( $tax_array ) {
      foreach( $tax_array as $key => $value ) {
	if( !isset($cumulative_taxes[$key]) ) $cumulative_taxes[$key] = 0;
	$cumulative_taxes[$key] += $value;
      }

      return TRUE;
    }

    return FALSE;
  }


  protected function _calculate_taxes(cge_address &$billing_address,&$items)
  {
    // Get the tax module
    $taxmodule = cg_ecomm::get_tax_module();
    if( !$taxmodule ) return FALSE;

    // Provide billing information to the taxes module
    if( method_exists($taxmodule,'SetAdditionalInfo') ) $taxmodule->SetAdditionalInfo($billing_address->to_array());

    // for each item, calculate the taxes
    $results = array();
    if( is_array($items) && count($items) ) {
      foreach( $items as $oneitem ) {
	switch( $oneitem->get_item_type() ) {
	case line_item::ITEMTYPE_DISCOUNT:
	case line_item::ITEMTYPE_SERVICE:
	  $this->_calculate_item_taxes($oneitem,$results);
	  break;

	case line_item::ITEMTYPE_SHIPPING:
	  if( cg_ecomm::can_tax_shipping() ) $this->_calculate_item_taxes($oneitem,$results);
	  break;

	case line_item::ITEMTYPE_PRODUCT:
	  $source = $oneitem->get_source();
	  $taxable = FALSE;
	  if( $source != '' && cg_ecomm::is_supplier_module($source) ) {
	    $mod = cge_utils::get_module($source);
	    if( method_exists($mod,'is_taxable')  ) $taxable = $mod->is_taxable($oneitem->get_item_id());
	  }

	  if( $taxable ) $this->_calculate_item_taxes($oneitem,$results);
	  break;

	default:
	  break;
	}
      }
    }

    $line_items = array();
    foreach( $results as $key => $value ) {
      $line_item = new line_item();
      $line_item->set_description($key);
      $line_item->set_quantity(1);
      $line_item->set_unit_price($value);
      $line_item->set_item_type(line_item::ITEMTYPE_TAX);
      $line_items[] = $line_item;
    }
    return $line_items;
  }


  public function set_shipping_address(cge_address &$address,$cartname)
  {
    if( !is_array($this->_shipping_addresses) ) $this->_shipping_addresses = array();
    $this->_shipping_addresses[$cartname] = $address;
  }


  protected function _calculate_shipping_costs(cge_address &$billing_addr,cge_address &$shipping_addr,&$items)
  {
    $module = cge_ecomm::get_shipping_module();
    if( !$module ) return FALSE;

    // Provide destination information to the shipping module
    if( method_exists($module,'SetAdditionalInfo') ) $module->SetAdditionalInfo($shipping_addr->to_array());

    // convert the items back into cart items for use in the
    // shipping module.
    $cart_items = array();
    for( $i = 0; $i < count($items); $i++ ) {
      if( $items[$i]->get_item_type() == line_item::ITEMTYPE_PRODUCT ) {
	$cart_item = new StdClass;
	$cart_item->quantity = $items[$i]->get_quantity();
	$cart_item->weight = $items[$i]->get_weight();
	$cart_item->product_id = $items[$i]->get_item_id();
	$cart_item->unit_price = $items[$i]->get_net_price();
	$cart_item->summary = $items[$i]->get_description();
	$cart_items[] = $cart_item;
      }
    }

    if( !$cart_items ) return FALSE;

    if( method_exists($module,'CalculateShipping') ) {
      // old (deprecated) method.
      $shipping_cost = $module->CalculateShipping($cart_items);
      if( $shipping_cost !== FALSE ) {
	$line_item = new line_item();
	$line_item->set_quantity(1);
	$line_item->set_item_type(line_item::ITEMTYPE_SHIPPING);
	if( is_array($shipping_cost) ) {
	  $line_item->set_decription($shipping_cost[0]);
	  $line_item->set_unit_price($shipping_cost[1]);
	}
	else {
	  $line_item->set_description($this->_this_module->Lang('shipping'));
	  $line_item->set_unit_price($shipping_cost);
	}
      }
    }
    return $line_item;
  }


  public function adjust_for_shipping(orders_order &$order)
  {
    $billing_addr = $order->get_billing();

    $numd = $order->count_destinations();
    for( $d = 0; $d < $numd; $d++ ) {
      $destination = $order->get_shipping($d);

      // find an address for this shipment
      $shipping_addr = $billing_addr;
      if( isset($this->_shipping_addresses[$destination->get_name()]) ) {
	$shipping_addr = $this->_shipping_addresses[$destination->get_name()];
      }
      $destination->set_shipping_address($shipping_addr);

      $line_items = $this->_get_line_items($destination);
      $numi = count($line_items);
      
      $shipping_module = cg_ecomm::get_shipping_module();
      if( $shipping_module ) {
	if( method_exists($shipping_module,'SetAdditionalInfo') ) {
	  // Provide destination information to the shipping module
	  $shipping_module->SetAdditionalInfo($shipping_addr->to_array());
	}

	$cart_items = array();
	for( $i = 0; $i < $numi; $i++ ) {
	  switch( $line_items[$i]->get_item_type() ) {
	  case line_item::ITEMTYPE_TAX:
	  case line_item::ITEMTYPE_DISCOUNT:
	  case line_item::ITEMTYPE_SHIPPING:
	    break;
	  default:
	    $cart_items[] = $this->_line_item_to_cart_item($line_items[$i]);
	  }
	}

	// get the shipping cost.
	if( count($cart_items) ) {
	  $shipping_cost = $shipping_module->CalculateShipping($cart_items);
	  if( $shipping_cost !== FALSE && $shipping_cost != '0' ) {
	    $line_item = new line_item();
	    $line_item->set_description($this->_this_module->Lang('shipping'));
	    $line_item->set_quantity(1);
	    $line_item->set_unit_price($shipping_cost);
	    $line_item->set_item_type(line_item::ITEMTYPE_SHIPPING);

	    $line_items[] = $line_item;
	  }
	}
      }

      // and calculate taxes
      $tmp = $this->_calculate_taxes($billing_addr,$line_items);
      if( is_array($tmp) ) {
	foreach( $tmp as &$one ) {
	  $line_items[] = $one;
	}
      }

      // now do a merge
      $num_items = $destination->count_all_items();
      for( $i = 0; $i < count($line_items); $i++ ) {
	if( $i < $num_items ) {
	  $destination->set_item($i,$line_items[$i]);
	}
	else {
	  $destination->add_item($line_items[$i]);
	}
      }

    }
  }


  public function &get_order($opt = false)
  {
    // todo, do checks...
    $order = null;
    if( !$this->_feu_module || !$this->_cart_module) return $order;

    // start building the order
    $order = new orders_order();
    $order->set_feu_user($this->_uid);
    $order->set_status(ORDERSTATUS_PROPOSED);
    $billing_addr = '';

    // start with the billing address...
    if( $this->_billing_address_policy == order_maker::ADDR_POLICY_FEU ) {
      $billing_addr = $this->_get_feu_address();
    }
    else if( $this->_billing_address_policy == order_maker::ADDR_POLICY_LAST && $this->_uid > 0 ) {
      $billing_addr = $this->_get_last_billing_addr();
    }
    else if( $this->_billing_address_policy == order_maker::ADDR_POLICY_COOKIE ) {
      if( isset($_COOKIE['my_address']) ) $billing_addr = unserialize(base64_decode($_COOKIE['my_address']));
    }

    if( !$billing_addr ) $billing_addr = new orders_address();
    $order->set_billing($billing_addr);

    // now get the stuff out of the cart into the order.
    $basket_names = $this->_cart_module->GetBasketNames($this->_uid);
    foreach( $basket_names as $one_basket_name ) {
      $shipping = new orders_shipping();
      $shipping->set_name($one_basket_name);
      $shipping_addr = new orders_address();

      $basket_details = $this->_cart_module->GetBasketDetails($one_basket_name,$this->_uid);
      if( is_array($basket_details) ) $shipping_addr->from_array($basket_details,'dest_');
      $shipping->set_shipping_address($shipping_addr);

      /*
       * don't do anything with the cart items (yet).
      // get the items for this shipment
      $cart_items = $this->_cart_module->GetBasketItems($one_basket_name,$this->_uid);
      if( !is_array($cart_items) || count($cart_items) == 0 ) {
	// no items in this basket
	continue;
      }
      $line_items = array();
      for( $i = 0; $i < count($cart_items); $i++ ) {
	$the_line_item = $this->_cart_item_to_line_item($cart_items[$i]);
	if( is_object($the_line_item) ) {
	  $line_items[] = $the_line_item;
	}
      }

      // put all of the items into the shipping object.
      for( $i = 0; $i < count($line_items); $i++ ) {
	$shipping->add_item($line_items[$i]);
      }
      */

      // and add this shipment to the order.
      $order->add_shipping($shipping);
    }

    return $order;
  }


  public function save_address(orders_address& $address)
  {
    if( $this->_billing_address_policy == order_maker::ADDR_POLICY_COOKIE ) {
      $data = base64_encode(serialize($address));
      @setcookie('my_address',$data,time()+(365*24*60*60));
    }
  }
} // end of class

// EOF
?>
