<?php
#-------------------------------------------------------------------------
# Module: Orders - A simple order processing module.
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in every page of
# its admin section that the site was built with CMS Made simple, and
# provide a link to the CMS Made Simple website.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
if( !isset($gCms) ) exit;

$feu = $this->GetModuleInstance('FrontEndUsers');
if( !$feu ) 
  { 
    echo $this->DisplayErrorMessage($this->Lang('error_nofeumodule'));
    return;
  }
if( !isset($params['order_id']) )
  {
    echo $this->DisplayErrorMessage($this->Lang('error_insufficientparams'));
    return;
  }
$cart_module = cg_ecomm::get_cart_module();
if( !is_object($cart_module) )
  {
    // can't find the cart module.
    echo $this->DisplayErrorMessage($this->Lang('error_nocartmodule'));
    return;
  }

//
// This method handles synchronous gateway transactions
// usually from gateways that perform synchronously, and then return back to 
// the destination URL (this action) after processing is complete.
//
//
$order_id = (int)$params['order_id'];
$uid = orders_helper::is_valid_user();
$keyname = orders_helper::get_security_key();
$cname = 'c'.$keyname;
if( encrypted_store::get($keyname) != $order_id )
  {
    echo $this->DisplayErrorMessage($this->Lang('error_encryption_problem'));
    return;
  }

// get gateway module
$gateway_module = cg_ecomm::get_payment_module();
$smarty->assign('gateway_module',$gateway_module->GetName());

// get gateway return details
$datakey = '';
if( isset($params['datakey']) )
  {
    $datakey = $params['datakey'];
  }

$gateway_module->RestoreState($datakey);
$smarty->assign('status',$gateway_module->GetTransactionStatus());
$transaction_id = '';
$message = '';
if( $gateway_module->CheckInfo() )
  {
    // build a transaction from the info in the gateway module.
    $status = $gateway_module->GetTransactionStatus();
    $transaction_id = $gateway_module->GetTransactionID();
    $amount = $gateway_module->GetTransactionAmount();
    $message = $gateway_module->GetMessage();
    $payment_id = $gateway_module->GetPaymentId();
    $gateway = $gateway_module->GetName();

    $trans = new cgpgb_async_transaction($order_id,$amount,$gateway);
    $trans->set_id($transaction_id);
    $trans->set_message($message);
    $trans->set_status($status);
    $trans->set_payment_id($payment_id);
    $keys = $gateway_module->GetTransactionKeys();
    if( is_array($keys) )
      {
	foreach( $keys as $one )
	  {
	    $trans->set_other_val($one,$gateway_module->GetTransactionData($one));
	  }
      }

    // we're done with the gateway now
    // so reset it (just in case)
    $gateway_module->Reset();

    $res = orders_gateway_helper::process_gateway_transaction($trans);
    if( $res )
      {
	$smarty->assign('error',$res);
      }
  }
else
  {
    $smarty->assign('status','SUCCESS');
  }

// get the order.
$order_obj = $this->GetOrder($order_id);
$status = $order_obj->get_status();
cms_utils::set_app_data('orders_gateway_complete',1);

// set a variable that indicates the current order status
// clear out cruft.
$cart_module->EraseCart('gateway-complete');

encrypted_store::erase($cname);
encrypted_store::erase($keyname);

// Display the post processing template
// variables have already been set to smarty by ProcessGateWayResult
// process the information into the order.
$smarty->assign('order_obj',$order_obj);
$smarty->assign('ordernumber',$order_obj->get_invoice()); // deprecated.
$smarty->assign('transaction_id',$transaction_id);
switch( $status )
  {
  case ORDERSTATUS_PROPOSED:
  case ORDERSTATUS_CANCELLED:
  case ORDERSTATUS_HOLD:
  case ORDERSTATUS_INCOMPLETE:
    // should never get here with these statuses.
    $status = '';
    break;

  case ORDERSTATUS_COMPLETED:
    $status = 'COMPLETED';
    break;

  case ORDERSTATUS_PENDING:
    $status = 'PENDING';
    break;

  case ORDERSTATUS_CONFIRMED:
  case ORDERSTATUS_INVOICED:
  case ORDERSTATUS_PAID:
  case ORDERSTATUS_BALANCEDUE:
  case ORDERSTATUS_SUBSCRIBED:
    $status = 'SUCCESS';
    break;    
  }
if( $status ) $smarty->assign('status',$status);
$billing_addr = $order_obj->get_billing();
$smarty->assign('email_address',$billing_addr->get_email());
if( $message ) $smarty->assign('message',$message);

$thetemplate = 'gateway_complete_'.$this->GetPreference('dflt_gateway_complete_template');
echo $this->ProcessTemplateFromDatabase($thetemplate);

// Send Event w/ Order information
Events::SendEvent('Orders', 'PostGatewayComplete', array('order_id' => $order_id, 'order' => $order_obj->to_array()));

// EOF
?>
