<?php
#-------------------------------------------------------------------------
# Module: Orders - A simple order processing module.
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in every page of
# its admin section that the site was built with CMS Made simple, and
# provide a link to the CMS Made Simple website.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
if( !isset($gCms) ) exit;


//
// initialization
//

// Connect with our cart module
$cart_module = cg_ecomm::get_cart_module();
if( !is_object($cart_module) ) {
  echo $this->DisplayErrorMessage($this->Lang('error_nocartmodule'));
  return;
}
if( $cart_module->GetNumItems() == 0 ) {
  // There's nothing in the cart
  // so nothing we can do
  echo $this->DisplayErrorMessage($this->Lang("no_items_in_cart"));
  return;
}

// double check that the user is logged in
$uid = orders_helper::is_valid_user();
if( $uid === FALSE ) {
  echo $this->DisplayErrorMessage($this->Lang('error_notloggedin'));
  return;
}
$keyname = orders_helper::get_security_key();

// get our order from the cart...
if( isset($params['invoice_prefix']) ) {
  orders_helper::set_invoice_prefix($params['invoice_prefix']);
}

$order_maker = new order_maker($this);
$order_maker->set_feu_module($this->GetModuleInstance('FrontEndUsers'));
$order_maker->set_cart_module($cart_module);
$order_maker->set_user_id($uid);
$order_maker->set_address_policy($this->GetPreference('address_retrieval',order_maker::ADDR_POLICY_FEU));
$order = $order_maker->get_order();
if( $order ) {
  $order->set_status(ORDERSTATUS_PROPOSED);

  //
  // Fill from parameters
  // Q: why would we want to do this when not on a submit?
  //
  $billing_addr = $order->get_billing();
  if( isset($params['billing_firstname']) ) {
    $billing_addr = new orders_address();
    $billing_addr->from_array($params,'billing_');
    $order->set_billing($billing_addr);
  }
  if( isset($params['order_notes']) ) {
    $notes = cms_html_entity_decode($params['order_notes']);
    $order->set_order_notes($notes);
  }
  for( $i = 0; $i < $order->count_destinations(); $i++ ) {
    if( !isset($params['shipping_'.$i.'_firstname']) ) continue;

    $destination = $order->get_shipping($i);
    $destname = strtolower($destination->get_name());
    $addr = '';
    if( ($params['shipping_'.$i.'_firstname'] == '' || $params['shipping_'.$i.'_address1'] == '') &&
	$order->count_destinations() == 1) {
      $addr = $billing_addr;
    }
    else {
      $addr = new orders_address();
      $addr->from_array($params,'shipping_'.$i.'_');
    }

    $destination->set_shipping_address($addr);
  }
}

$errors = array();
$status = '';
if ($uid !== FALSE) {
  if (isset($params['submit'])) {
    //
    // Do Data Validation
    //
    $errfield = '';
    $billing_addr = $order->get_billing();
    $status = '';
    if( !$billing_addr->is_valid() ) {
      // Display some kind of error message
      // because at least one of the fields were invalid
      $errors[] = $this->Lang('error_invalid_address',$this->Lang('billing'));
      $status = 'error';
    }

    //now validate the shipping addresses.
    if( empty($status) ) {
      for( $i = 0; $i < $order->count_destinations(); $i++ ) {
	$dest = $order->get_shipping($i);
	$shipping_addr = $dest->get_shipping_address();
	if( !$shipping_addr->is_valid() ) {
	  $errors[] = $this->Lang('error_invalid_address',$dest->get_name());
	  $status = 'error';
	}
	$order_maker->set_shipping_address($shipping_addr,$dest->get_name());
      }
    }

    // save the address info into a cookie
    $order_maker->save_address($billing_addr);

    // adjust the order and make sure shipping costs are calculated.
    if( empty($status) ) {
      $order_maker->adjust_for_shipping($order);
    }

    //
    // Do database work
    //
    if( empty($status) ) {
      // If that works, then we handle the database stuff.
      $res = '';
      $order_id = encrypted_store::get($keyname);
      if ($order_id) {
	//We've previously started an order.  Let's use that.
	//But delete anything in the database first, just incase
	//The items have changed.

	// reset all ids to null to force everything to be saved properly.
	$order->reset_ids();
	$order->set_id($order_id,true);

	// and save.
	$res = $order->save(true);
      }
      else {
	$res = $order->save();
	$order_id = $order->get_id();
      }

      // toss it in the session
      if( !$order->get_id() ) die('empty order id');
      encrypted_store::put($order->get_id(),$keyname);

      //
      // Order is submitted
      // Redirect to something that'll ask us to 
      // pay for the crap we just ordered.
      //
      session_write_close();
      $parms = array('order_id'=>$order->get_id());
      if( isset($params['lang']) ) {
	$parms['lang'] = $params['lang'];
      }

      if( orders_helper::requires_creditcard_number() ) {
	$destpage = $this->GetPreference('paymentpage',$returnid);
	if( $destpage < 1 ) $destpage = $returnid;
	$this->Redirect($id, 'payment', $destpage, array('order_id' => $order->get_id()));
      }
      else {
	$destpage = $this->GetPreference('confirmpage',$returnid);
	if( $destpage < 1 ) $destpage = $returnid;
	$this->Redirect($id, 'confirm', $destpage, array('order_id' => $order->get_id()));
      }

      // redirect to the confirm page.
      $destpage = $this->GetPreference('confirmpage',$returnid);
      if( $destpage < 1 ) $destpage = $returnid;
      $this->Redirect($id, 'confirm', $destpage, $parms);
    }
  }
  else {
    //So no submit.  Instead, let's see if there is an order id in the session..
    $order_id = encrypted_store::get($keyname);
    if ($order_id) {
      //If that's the case, let's pull out the field details from this order and prepopulate the fields
      $tmporder = orders_ops::load_by_id($order_id);
      if( $tmporder ) $order = $tmporder;
    }
  }
}


$smarty->assign_by_ref('mod',$this);
if( !empty($status) ) {
  $smarty->assign('status',$status);
  $smarty->assign('errors',$errors);
}
$smarty->assign('formstart',$this->CGCreateFormStart($id, 'default', $returnid, $params));
$smarty->assign('formend',$this->CreateFormEnd());

if( $order ) {
  $billing_addr = $order->get_billing();
  $smarty->assign('input_billing_company', 
		  $this->CreateInputText($id, 'billing_company', 
					 $billing_addr->get_company(), 50));
  $smarty->assign('input_billing_first_name', 
		  $this->CreateInputText($id, 'billing_firstname', 
					 $billing_addr->get_firstname(), 30));
  $smarty->assign('input_billing_last_name', 
		  $this->CreateInputText($id, 'billing_lastname', 
					 $billing_addr->get_lastname(), 30));
  $smarty->assign('input_billing_address1', 
		  $this->CreateInputText($id, 'billing_address1', 
					 $billing_addr->get_address1(), 50));
  $smarty->assign('input_billing_address2', 
		  $this->CreateInputText($id, 'billing_address2', 
					 $billing_addr->get_address2(), 50));
  $smarty->assign('input_billing_city', 
		  $this->CreateInputText($id, 'billing_city', 
					 $billing_addr->get_city(), 30));
  $smarty->assign('input_billing_state', 
		  $this->CreateInputStateDropdown($id, 'billing_state', 
						  $billing_addr->get_state() != '' ? $billing_addr->get_state() : $this->GetPreference('dflt_state'), '--'));
  $smarty->assign('input_billing_postal', 
		  $this->CreateInputText($id, 'billing_postal', $billing_addr->get_postal(), 20));
  $smarty->assign('input_billing_country', 
		  $this->CreateInputCountryDropdown($id, 'billing_country', 
						    $billing_addr->get_country() != '' ? $billing_addr->get_country() : $this->GetPreference('dflt_country'), false));
  $smarty->assign('input_billing_phone', 
		  $this->CreateInputText($id, 'billing_phone', $billing_addr->get_phone(), 30));
  $smarty->assign('input_billing_fax', 
		  $this->CreateInputText($id, 'billing_fax', $billing_addr->get_fax(), 30));
  $smarty->assign('input_billing_email', 
		  $this->CreateInputText($id, 'billing_email', $billing_addr->get_email(), 80));

  $shipping_inputs = array();
  for( $i = 0; $i < $order->count_destinations(); $i++ ) {
    $destination = $order->get_shipping($i);
    $shipping_addr = $destination->get_shipping_address();

    $shipping_row = array();
    $shipping_row['data'] = $destination;
    $shipping_row['input_company'] = 
      $this->CreateInputText($id,"shipping_{$i}_company",$shipping_addr->get_company(), 50);

    $shipping_row['input_first_name'] = 
      $this->CreateInputText($id,"shipping_{$i}_firstname",$shipping_addr->get_firstname(), 30);
    $shipping_row['input_last_name'] = 
      $this->CreateInputText($id,"shipping_{$i}_lastname",$shipping_addr->get_lastname(), 30);
    $shipping_row['input_address1'] = 
      $this->CreateInputText($id, "shipping_{$i}_address1",$shipping_addr->get_address1(), 50);
    $shipping_row['input_address2'] = 
      $this->CreateInputText($id, "shipping_{$i}_address2",$shipping_addr->get_address2(),50);
    $shipping_row['input_city'] = 
      $this->CreateInputText($id, "shipping_{$i}_city",$shipping_addr->get_city(), 30);
    $shipping_row['input_state'] = 
      $this->CreateInputStateDropdown($id, "shipping_{$i}_state", 
				      $shipping_addr->get_state() != '' ? $shipping_addr->get_state() : $this->GetPreference('dflt_state'), '--');
    $shipping_row['input_postal'] = $this->CreateInputText($id,"shipping_{$i}_postal",$shipping_addr->get_postal(),20);
    $shipping_row['input_country'] = 
      $this->CreateInputCountryDropdown($id, "shipping_{$i}_country", 
					$shipping_addr->get_country() != '' ? $shipping_addr->get_country() : $this->GetPreference('dflt_country'), true);
    $shipping_row['input_phone'] = 
      $this->CreateInputText($id, "shipping_{$i}_phone", $shipping_addr->get_phone(), 30);
    $shipping_row['input_fax'] = 
      $this->CreateInputText($id, "shipping_{$i}_fax", $shipping_addr->get_fax(), 30);
    $shipping_row['input_email'] = 
      $this->CreateInputText($id, "shipping_{$i}_email", $shipping_addr->get_email(), 80);
    $shipping_row['input_notes'] =

      $shipping_inputs[] = $shipping_row;
  }

  $smarty->assign('order',$order->to_array());
  $smarty->assign('order_obj',$order);
  $smarty->assign('order_notes',
		  $this->CreateTextArea(false, $id, $order->get_order_notes(), 'order_notes' ) );
  $smarty->assign('shipping_inputs',$shipping_inputs);
  $smarty->assign('shipping_count',count($shipping_inputs));
} // end if we have an order.

$promotions_module = cge_utils::get_module('Promotions');
if( isset($promotions_module) ) {
  $smarty->assign('promotions_avail',1);
}
   
// do backwards compatibility stuff here temporarily so people won't have to change all templates right off the bat
$smarty->assign('input_shipping_first_name',$shipping_inputs[0]['input_first_name']);
$smarty->assign('input_shipping_last_name',$shipping_inputs[0]['input_last_name']);
$smarty->assign('input_shipping_address1',$shipping_inputs[0]['input_address1']);
$smarty->assign('input_shipping_address2',$shipping_inputs[0]['input_address2']);
$smarty->assign('input_shipping_city',$shipping_inputs[0]['input_city']);
$smarty->assign('input_shipping_state',$shipping_inputs[0]['input_state']);
$smarty->assign('input_shipping_postal',$shipping_inputs[0]['input_postal']);
$smarty->assign('input_shipping_phone',$shipping_inputs[0]['input_phone']);
$smarty->assign('input_shipping_fax',$shipping_inputs[0]['input_fax']);
$smarty->assign('input_shipping_email',$shipping_inputs[0]['input_email']);
// end backwards compatibility stuff.

$smarty->assign('submit_me', 
		$this->CreateInputSubmit($id, 'submit', $this->Lang('next')));

$thetemplate = 'billingform_'.$this->GetPreference('dflt_billingform_template');
if( isset($params['template']) ) {
  $thetemplate = 'billingform_'.$params['template'];
}

echo $this->ProcessTemplateFromDatabase($thetemplate);

// EOF
?>
