{if $promo->get_id() == ''}
  <h3>{$mod->Lang('lbl_add_promo')}</h3>
{else}
  <h3>{$mod->Lang('lbl_edit_promo')}</h3>
{/if}
<h4>{$mod->Lang('type')}: {$mod->Lang($promotype)} ({$promotype})</h4>

<script type='text/javascript'>
// <![CDATA[ 
var cond_prompts = new Array();
var cond_names = new Array();
var cond_info = new Array();
{foreach from=$conditiontypes key='name' item='value'}
cond_names["{$name}"] = "{$value}";
{capture assign='tmp'}promptdata_{$name}{/capture}
cond_prompts["{$name}"] = "{$mod->Lang($tmp)}";
{capture assign='tmp'}infodata_{$name}{/capture}
cond_info["{$name}"] = "{$mod->Lang($tmp)}";
{/foreach}

var offer_prompts = new Array();
{foreach from=$offertypes key='name' item='value'}
{capture assign='tmp'}promptoffer_{$name}{/capture}
offer_prompts["{$name}"] = "{$mod->Lang($tmp)}";
{/foreach}
var errors = new Array();
errors['no_value'] = "{$mod->Lang('error_specify_value')}";
errors['already_prod'] = "{$mod->Lang('error_already_product_cond')}";
errors['duplicate_type'] = "{$mod->Lang('error_duplicate_condition')}";
errors['no_name'] = "{$mod->Lang('error_promotion_name')}";
errors['no_offer_data'] = "{$mod->Lang('error_no_offer_data')}";
errors['no_conditions'] = "{$mod->Lang('warning_no_conditions')}";

{literal}
function isNumeric(form_value) 
{ 
  if (form_value.match(/^\d+$/) == null) 
    return false; 
  else 
    return true; 
} 

function in_array(needle,haystack)
{
  for( i = 0; i < haystack.length; i++ ) {
    if( haystack[i] == needle ) return true;
  }
  return false;
}

function get_conditions()
{
  var conds = new Array();
  jQuery('#condlist > .condition_row').each(function(){
    var type = jQuery(this).find('.saved_condtype').val();
    var data = jQuery(this).find('.saved_conddata').val();
    conds[type] = data;
  });
  return conds;
}

function condition_invalid(type,data)
{
  var conds = get_conditions();
  // pass one, look for duplicate types
  for( var ctype in conds ) {
    if( ctype == type ) return 'duplicate_type';
  }

  // pass two, look for duplicate product types
  for( var ctype in conds ) {
    if( ctype.match(/PROD/) && type.match(/PROD/) ) {
        return 'already_prod';
      }
  }
  return false;
}

jQuery(document).ready(function(){
  // initialize the data prompt
  var type = jQuery('#condtype').val();
  jQuery('#dataprompt').html(cond_prompts[type]);
  jQuery('#datainfo').html(cond_info[type]);

  // handler for extra area
  jQuery('#extras').hide();
  jQuery('#linkextras').click(function(){
    jQuery('#extras').toggle();
    return false;
  });

  // setup initial condition list stuff.
  jQuery('#condlist > .condition_row').show();
  jQuery('a.delcond').click(function(){
     jQuery(this).closest('.condition_row').remove();
     return false;
  });

  // initialize the offer prompt
  type = jQuery('#offertype').val();
  $('#offerdata').html(offer_prompts[type]);
  $('#'+type).show();
  $('#offertype').change(function(){
    // offer type changed
    var type = jQuery('#offertype').val();
    $('#offerdata').html(offer_prompts[type]);
    $('.offer_extra').hide();
    $('#'+type).show();
  });
 
  // handle condition type changed
  jQuery('#condtype').change(function(){
    // condition type changed
    var type = jQuery('#condtype').val();
    $('#dataprompt').html(cond_prompts[type]);
    $('#datainfo').html(cond_info[type]);
  });

  // handle add condition clicked.
  jQuery('#addbtn').live('click',function(){
    var elem = jQuery('#condition_row_tmpl').clone();
    elem.attr('id','');
    var condtype = jQuery('#condtype').val();
    var conddata = jQuery('#conddata').val();
    if( conddata == '' ) {
      alert(errors['no_value']);
      return false;
    }
    else if( condtype == 'PROMOTIONS_COND_PRODID' ) {
      if( parseInt(conddata) <= 0 ) {
        alert(errors['invalid_value']);
        return false;
      }
    }
    else if( condtype == 'PROMOTIONS_COND_SUBTOTAL' ) {
      // todo, error check here
    }
    error = condition_invalid(condtype,conddata);
    if( error ) {
      alert(errors[error]);
      return false;
    }
    elem.find('.saved_condtype').val(condtype);
    elem.find('.saved_conddata').val(conddata);
    elem.find('.disp_condtype').html(cond_names[condtype]);
    elem.find('.disp_conddata').html(conddata);
    jQuery('#condlist').append(elem);

    // handle row delete
    jQuery('a.delcond').click(function(){
       jQuery(this).closest('.condition_row').remove();
       return false;
    });

    elem.fadeIn('slow');
    return false;
  });

  // handleform submit
  jQuery('#submit').live('click',function(){
    var name = jQuery('#name').val();
    var offerdata = jQuery('#offer_data').val();
    if( name == '' )
    {
	alert(errors['no_name']);
	return false;
    }
    if( offerdata == '' )
    {
	alert(errors['no_offer_data']);
	return false;
    }
    // warn about no conditions.
    if( jQuery('#condlist').children().size() == 0 )
    {
	return confirm(errors['no_conditions']);
    }
    return true;
    // success
  });

});
{/literal}
// ]]>
</script>

{include file='module_file_tpl:Promotions;inc_condition_row.tpl'}

{$formstart}
<div class="pageoverflow">
  <p class="pagetext">{$mod->Lang('prompt_name')}:</p>
  <p class="pageinput">
    <input type="text" id='name' name="{$actionid}name" value="{$promo->get_name()}" size="80" maxlength="255" />
  </p>
</div>

<div class="pageoverflow">
  <p class="pagetext">{$mod->Lang('prompt_start_date')}:</p>
  <p class="pageinput">
    {capture assign='tmp'}{$actionid}start_date_{/capture}
    {html_select_date prefix=$tmp time=$promo->get_start_date() end_year="+5"}
  </p>
</div>

<div class="pageoverflow">
  <p class="pagetext">{$mod->Lang('prompt_end_date')}:</p>
  <p class="pageinput">
    {capture assign='tmp'}{$actionid}end_date_{/capture}
    {html_select_date prefix=$tmp time=$promo->get_end_date() end_year="+5"}
  </p>
</div>

<fieldset class="pageoverflow">
  <legend>{$mod->Lang('prompt_conditions')}:&nbsp;</legend>
  <div id="condlist">
  {if isset($conditions)}
    {* do a foreach here for all of the current conditions *}
    {foreach from=$conditions item='cond'}
      {include file='module_file_tpl:Promotions;inc_condition_row.tpl'}
    {/foreach}
  {/if}
  </div>
</fieldset>

<fieldset class="pageoverflow">
 <legend>{$mod->Lang('prompt_add_condition')}:</legend>
 <p class="information">{$mod->Lang('info_conditions')}</p>
 <div class="pageoverflow">
   <p class="pagetext">{$mod->Lang('prompt_condition_type')}:</p>
   <p class="pageinput">
     <select name="{$actionid}add_condtype" id="condtype">
     {html_options options=$conditiontypes}
     </select>
   </p>
 </div>

 <div class="pageoverflow">
   <p class="pagetext" id="dataprompt">{$mod->Lang('prompt_condition_data')}:</p>
   <p class="pageinput">
     <input id="conddata" type="text" name="{$actionid}add_conddata" size="30"/>
   </p>
 </div>

 <div class="pageoverflow">
   <p class="pagetext"></p>
   <p class="pageinput">
     <input type="submit" id="addbtn" name="{$actionid}add" value="{$mod->Lang('add')}"/>
   </p>
 </div>
</fieldset>

<fieldset class="pagetext" style="padding-bottom: 0.5em;">
  <legend>{$mod->Lang('prompt_offer')}:</legend>
  <div class="pageoverflow nooffset">
  <p class="pagetext nooffset">
    {$mod->Lang('prompt_offer_type')}:
  </p>
  <p class="pageinput nooffset">
    <select name="{$actionid}offer_type" id="offertype">
    {html_options options=$offertypes selected=$promo->get_offer_type()}
    </select>
  </p>
  </div>

  <div class="pageoverflow">
  <p class="pagetext nooffset" id="offerdata">
    {$mod->Lang('prompt_offer_data')}:
  </p>
  <p class="pageinput nooffsffet">
    <input id="offer_data" type="text" name="{$actionid}offer_data" size="10" maxlength="255" value="{$promo->get_offer_data()}"/>
  </p>
  </div>

  {if $promotype == 'promo_type_instant'}
  <div class="pagoverflow">
    <p class="pagetext">{$mod->Lang('prompt_allow_once')}:</p>
    <p class="pageinput">
       {cge_yesno_options prefix=$actionid name='extra_allow_once' selected=$promo->get_extra('allow_once')}
    </p>
  </div>
  {/if}

  {if $promotype == 'promo_type_checkout'}
  <div class="pagoverflow">
    <p class="pagetext">{$mod->Lang('prompt_allow_cumulative')}:</p>
    <p class="pageinput">
       {cge_yesno_options prefix=$actionid name='extra_allow_cumulative' selected=$promo->get_extra('allow_cumulative')}
    </p>
  </div>
  {/if}

  <div id-"extra_info_area">
  {assign var='map' value=$promo->get_offer_extra_map()}
  {foreach from=$map key='offertype' item='flds'}
    <div id="{$offertype}" class="offer_extra" style="display: none;">
      {foreach from=$flds item='fld'}
      <div class="pageoverflow">
        <p class="pagetext">{assign var='a' value=$fld.label}{$mod->Lang($a)}:</p>
        <p class="pageinput">
          {if $fld.type=='checkbox'}
            {assign var='b' value=$fld.name}
            <input type="checkbox" name="{$actionid}extra_{$b}" value="1" {if $promo->get_extra($b)}checked="checked"{/if}/>
          {/if}
        </p>
      </div>
      {/foreach}
    </div>
  {/foreach}
  </div>
  
</fieldset>

{*
<p class="pagetext">{$mod->Lang('prompt_extras')}: <a id="linkextras">+</a></p>
<fieldset class="cgfieldset" id="extras">
  <p class="pageoverflow">{$mod->Lang('info_extras')}</p>
  <div class="pageoverflow nooffset">
    <p class="pagetext" style="margin-left: 0;">{$mod->Lang('prompt_image')}</p>
    <p class="pageinput" style="margin-left: 0;">
    <select name="{$actionid}image">
    {html_options options=$file_list selected=$promo->get_image()}
    </select>
    </p>
  </div>
  <div class="pageoverflow">
    <p class="pagetext" style="margin-left: 0;">{$mod->Lang('prompt_description')}</p>
  <textarea class="nooffset" rows="3" cols="50" name="{$actionid}description">{$promo->get_description()}</textarea>
  </div>
</fieldset>
*}

<div class="pageoverflow">
  <p class="pagetext">&nbsp;</p>
  <p class="pageinput">
    <input type="submit" id='submit' name="{$actionid}submit" value="{$mod->Lang('submit')}" />
    <input type="submit" name="{$actionid}cancel" value="{$mod->Lang('cancel')}" />
  </p>
</div>
{$formend}