<?php
#CMS - CMS Made Simple
#(c)2004 by Ted Kulp (wishy@users.sf.net)
#This project's homepage is: http://cmsmadesimple.sf.net
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

class tweetfeed {
	var $twitterAccount;
	var $consumerKey;
	var $consumerSecret;
	var $userToken;
	var $userSecret;
	var $tweetCount;
	var $tweetClass;
	var $showDate = 'false';
	var $tweetDateClass;
	var $showIcon = 'false';
	var $tweetIcon;
	var $tweetIconClass;
	
	var $rss;
	  
	function __constructor($twitterAccount = '', $consumerKey = '', $consumerSecret = '', $userToken = '', $userSecret = '',   $tweetCount = '10', $tweetClass = '', $showDate = 'false', $dateFormat = '\L\e d/m/Y - H:i', $tweetDateClass = '', $showIcon = 'false', $tweetIcon = '', $tweetIconClass = ''){	
		
		
		
		$this->tweetfeed($twitterAccount, $consumerKey, $consumerSecret, $userToken, $userSecret, $tweetCount, $tweetClass, $showDate, $dateFormat, $tweetDateClass, $showIcon, $tweetIcon, $tweetIconClass);
	}
	 
	function tweetfeed($twitterAccount, $consumerKey, $consumerSecret, $userToken, $userSecret, $tweetCount, $tweetClass, $showDate, $dateFormat, $tweetDateClass, $showIcon, $tweetIcon, $tweetIconClass) {
		$this->twitterAccount = $twitterAccount;
		$this->consumerKey = $consumerKey;
		$this->consumerSecret = $consumerSecret;
		$this->userToken = $userToken;
		$this->userSecret = $userSecret;
		$this->tweetCount = $tweetCount;
		$this->tweetClass = $tweetClass;
		$this->showDate = $showDate;
		$this->dateFormat = $dateFormat;
		$this->tweetDateClass = $tweetDateClass;
		$this->showIcon = $showIcon;
		$this->tweetIcon = $tweetIcon;
		$this->tweetIconClass = $tweetIconClass;
	
		if(strlen($twitterAccount) == '0') {
			// account not specified
			$this->showError(1);
			return false;
		}
		else {			

			require 'tmhOAuth-master/tmhOAuth.php';
		
			require 'tmhOAuth-master/tmhUtilities.php';
		
			$tmhOAuth = new tmhOAuth(array(
		
			  'consumer_key'    => $this->consumerKey,
		
			  'consumer_secret' => $this->consumerSecret,
		
			  'user_token'      => $this->userToken,
		
			  'user_secret'     => $this->userSecret,
		
			));
				
				//$method 
				$method = "https://api.twitter.com/1.1/statuses/user_timeline.json";
				$params = array(
				  // parameters go here
				  'screen_name' => $this->twitterAccount,
				  'count' => $this->tweetCount
				);
				$tmhOAuth->request('GET', $method, $params, 'my_streaming_callback', false);
				$response = $tmhOAuth->response['response'];
				$responseArr = json_decode($response);
				//var_dump($responseArr); //get the response array.

				$i = 0;
				foreach ($responseArr as $item) {  
					if($i < $this->tweetCount) {
						// Description: Remove the account name
						$tweetContent = str_replace($this->twitterAccount.": ", "", $item->text);
							// LINKS are now clickable
						$tweetContent = preg_replace('#(http|https)(://[A-Za-z0-9-_àäâéèëêïîôöùüûç]+)(\.[a-z]{2,5})([A-Za-z0-9_/\+\?\.-]*)#s', '<a href="$1$2$3$4" target="_blank">$1$2$3$4</a>', $tweetContent);
							// #LINKS are now clickable
						$tweetContent = preg_replace('/#([A-Za-z0-9_-àäâéèëêïîôöùüûç]+)/s', ' <a href="http://twitter.com/search?q=%23$1" target="_blank">#$1</a>', $tweetContent);	
							// @LINKS are now clickable
						$tweetContent = preg_replace('#@([A-Za-z0-9_-àäâéèëêïîôöùüûç]+)#s', ' <a href="http://twitter.com/$1" target="_blank">@$1</a>', $tweetContent);
						
						if(function_exists('date_parse_from_format')) { // php 5.3+
														//Tue Jun 11 14:03:47 +0000 2013
							$D = date_parse_from_format("D M j H:i:s +0000 Y", $item->created_at);
							$tweetDate = date($this->dateFormat, mktime($D['hour'], $D['minute'], 0, $D['month'], $D['day'], $D['year']));
						} else { // backports for php < 5.3
							$D = $this->date_parse($item->created_at);
							$tweetDate = date($this->dateFormat, mktime($D['hour'], $D['minute'], 0, $D['month'], $D['day'], $D['year']));
						}
						
						
						$this->displayTweet($tweetContent, $tweetDate, $i);
						
						$i++;
					}
					else {
						break;
					}
				}

		}
	}
	
	function my_streaming_callback($data, $length, $metrics) {
	  echo $data .PHP_EOL;
	  return file_exists(dirname(__FILE__) . '/STOP');
	}
	
	function date_parse($date) {
		// get rid of 'D,' and ':s +0000':
		$date = substr($date,5,-9);
		$retDate['day'] = substr($date,0,2);
		
		// convert 'M' in 'm'
		switch(strtolower(substr($date,3,3))) {
			case 'jan': $retDate['month'] = 1; break;
			case 'feb': $retDate['month'] = 2; break;
			case 'mar': $retDate['month'] = 3; break;
			case 'apr': $retDate['month'] = 4; break;
			case 'may': $retDate['month'] = 5; break;
			case 'jun': $retDate['month'] = 6; break;
			case 'jul': $retDate['month'] = 7; break;
			case 'aug': $retDate['month'] = 8; break;
			case 'sep': $retDate['month'] = 9; break;
			case 'oct': $retDate['month'] = 10; break;
			case 'nov': $retDate['month'] = 11; break;
			case 'dec': $retDate['month'] = 12; break;
		}
		// year
		$retDate['year'] = substr($date,7,4);
		// Hour min
		$retDate['hour'] = substr($date,12,2);
		$retDate['minute'] = substr($date,15,2);

		return $retDate;
	}

	function displayTweet($tweetContent, $tweetDate, $i) {
		
		echo "<ul class=\"$tweetClass\">\n<li>\n";
		if($this->showIcon == 'true') {
			echo "<span class=\"$this->tweetIconClass\"><img src=\"$this->tweetIcon\" alt=\"\" /></span>";
		}
		if($this->showDate == 'true') {
			echo "<span class=\"$this->tweetDateClass\">$tweetDate</span>";
		}
		echo "$tweetContent";

		echo "</li>\n</ul>";
	}
	
	function showError($errorId) {
		// @params: (int) $erroId
		//	- 1: Account error OR rss unavailable
		//	- 2: Params missing: twitterAccount
		
		$msg = '';
		
		switch($errorId) {
		case 1:
			$msg = "A Twitter account name has not been specified or cannot be found";
			break;
		case 2:
			$msg = "There was an error retrieving your Tweets.";
			break;
		default:
			break;
		}
		
		echo "<p style=\"color: red;\"><strong>" . $msg . "</strong></p>\n";
	}
	
	function showDebugInfo() {
		echo "<ul><li><strong>twitterAccount:</strong> $this->twitterAccount</li>\n";
		echo "<li><strong>tweetClass:</strong> $this->tweetClass</li>\n";
		echo "<li><strong>tweetCount:</strong> $this->tweetCount</li>\n";
		echo "<li><strong>RSS:</strong> $this->rss</li>\n";
		echo "<li><strong>showDate:</strong> $this->showDate</li>\n";
		echo "<li><strong>dateFormat:</strong> $this->dateFormat</li>\n";
		echo "<li><strong>tweetDateClass:</strong> $this->tweetDateClass</li>\n";
		echo "<li><strong>showIcon:</strong> $this->showIcon</li>\n";
		echo "<li><strong>tweetIcon:</strong> $this->tweetIcon</li>\n";
		echo "<li><strong>tweetIconClass:</strong> $this->tweetIconClass</li>\n";
		echo "<li><strong>consumerKey:</strong>	$this->consumerKey</li>\n";
		echo "<li><strong>consumerSecret:</strong> $this->consumerSecret</li>\n";
		echo "<li><strong>userToken:</strong> $this->userToken</li>\n";
		echo "<li><strong>userSecret:</strong> $this->userSecret</li>\n";

		echo "</ul>\n";
	}
}



function smarty_cms_function_tweetfeed($params, &$smarty) {
	$gCms = cmsms();
	$config =& $gCms->GetConfig();
	
	$debug = isset($params['debug']) ? $params['debug']:'false';
	$twitterAccount = isset($params['twitterAccount']) ? $params['twitterAccount']:'';
	$consumerKey = isset($params['consumerKey']) ? $params['consumerKey']:'';
	$consumerSecret = isset($params['consumerSecret']) ? $params['consumerSecret']:'';
	$userToken = isset($params['userToken']) ? $params['userToken']:'';
	$userSecret = isset($params['userSecret']) ? $params['userSecret']:'';
	$tweetCount = isset($params['tweetCount']) ? $params['tweetCount']:'10';
	$tweetClass = isset($params['tweetClass']) ? $params['tweetClass']:'';
	$showDate = isset($params['showDate']) ? $params['showDate']:'false';
	$dateFormat = isset($params['dateFormat']) ? $params['dateFormat']:'\L\e d/m/Y - H:i';
	$tweetDateClass = isset($params['tweetDateClass']) ? $params['tweetDateClass']:'';
	$showIcon = isset($params['showIcon']) ? $params['showIcon']:'false';
	$tweetIcon = isset($params['tweetIcon']) ? $params['tweetIcon']:'';
	$tweetIconClass = isset($params['tweetIconClass']) ? $params['tweetIconClass']:'';
	
	$tweetfeed = new tweetfeed($twitterAccount, $consumerKey, $consumerSecret, $userToken, $userSecret, $tweetCount, $tweetClass, $showDate, $dateFormat, $tweetDateClass, $showIcon, $tweetIcon, $tweetIconClass);
	
	if($debug != 'false') {
		$tweetfeed->showDebuginfo();
	}
}


function smarty_cms_help_function_tweetfeed() {
?>
<h3>What does this do?</h3>
<p>This plugin has been updated to use the Twitter v1.1 API and requires the additinal OAuth folder adding to the plugins folder too.</p>
<p>This is a reworking of the Tweets plugin. Display tweets from a specified Twitter account.</p>
<h3>How do I use it?</h3>
<p>Just insert the tag into your template/page like <code>{tweetfeed twitterAccount='cmsms' consumerKey='UYIYUIYIYIU' consumerSecret='FGFGFGFGFFG' userToken='YUYUYUYU' userSecret='HJHJHJHHJ'}</code>.</p>
<h3>What parameters does it take?</h3>
<ul>
<li><tt>twitterAccount='twitter_account_here'</tt> - Name of Twiter account to display feeds from.</li>
<li><tt>consumerKey:</tt>	- View this in your Application under dev.twitter.com/apps/new</li>\n";
<li><tt>consumerSecret:</tt> - View this in your Application under dev.twitter.com/apps/new</li>\n";
<li><tt>userToken:</tt> - View this in your Application under dev.twitter.com/apps/new</li>\n";
<li><tt>userSecret:</tt> - View this in your Application under dev.twitter.com/apps/new</li>\n";
<li><em>(optional)</em> <tt>tweetCount='10'</tt> - How many tweets to display. Default is 10.</li>
<li><em>(optional)</em> <tt>debug='false'</tt> - Enable debug mode. Default is false.</li>
<li><em>(optional)</em> <tt>tweetClass='twitter_class'</tt> - Specify a class to be added to the UL wrapping the tweets. Default is none.</li>
<li><em>(optional)</em> <tt>showDate='false'</tt> - Show date in feed. Default is false.</li>
<li><em>(optional)</em> <tt>dateFormat='\L\e d/m/Y - H:i'</tt> - What format the date should appear as if used. See php date function for possible options <a href="http://www.php.net/manual/function.date.php" target="_blank">date()</a>.</li>
<li><em>(optional)</em> <tt>tweetDateClass='twitter_date_class'</tt> - Specify a class to be added to the span wrapping the date. Default is none.</li>
<li><em>(optional)</em> <tt>showIcon='false'</tt> - Show an icon with your tweets. This needs to be used in conjunction with the tweetIcon parameter. Default is none.</li>
<li><em>(optional)</em> <tt>tweetIcon='PATH/TO/ICON'</tt> - If showIcon is set to false you need to specify the icons url with the tweetIcon parameter.</li>
<li><em>(optional)</em> <tt>tweetIconClass='twitter__icon_class'</tt> - Specify a class to be added to the span wrapping the icon. Default is none.</li>
</ul>
<p>&lt;ul class="twitter_class"&gt;<br />&lt;li&gt;<br />&nbsp;&nbsp;&nbsp;&lt;span class="twitter__icon_class"&gt;tweetIcon&lt;/span&gt;<br />&nbsp;&nbsp;&nbsp;&lt;span class="twitter_date_class"&gt;tweetDate&lt;/span&gt;<br />&nbsp;&nbsp;&nbsp;tweetContent<br />&lt;/li&gt;<br />&lt;/ul&gt;</p>

<?php
}

function smarty_cms_about_function_tweetfeed() {
?>
	<p><strong>Author:</strong> Oliver Seddon <a href=\"mailto:oliver@threefold.co.uk\">oliver@threefold.co.uk</a> Thanks to: Alexandre COURTOIS for the original tweets plugin and Dave Pratt for the v1.1 API update.<br /><br /></p>
    <p>Version 2.0<br /><br /></p>
    <p>Change History:<br />
    1.0 - Alpha version released.<br />
    1.1 - Bug fixes including #8683 where a class would not be attributed to the wrapping UL element.<br />
    2.0 - Updated to work with Twitter API v1.1.</p>
<?php
}
?>