{* Display photos from the Products Module in a RSS Feed *}
{* This template displays the most recently added products *}
{* Specific categories or hierarchy items can be specified *} 
{* See the comments below that start with !!! - They outline various settings you can change *}
{* template generously donated by Tyler Boespflug *}

<?xml version="1.0"?>
<rss version="2.0">
  <channel>
    <title>{$feed.title}</title>
    {if isset($feed.link) && !empty($feed.link)}<link>{$feed.link}</link>{/if}
    {if isset($feed.description) && !empty($feed.description)}<description>{$feed.description}</description>{/if}
    {if isset($feed.copyright) && !empty($feed.copyright)}<copyright>{$feed.copyright}</copyright>{/if}
    {if isset($generator)}<generator>{$generator}</generator>{/if}
    {if isset($feed.managing_editor) && !empty($feed.managing_editor)}<managingEditor>{$feed.managing_editor}</managingEditor>{/if}
    {if isset($admin_email)}<webMaster>{$admin_email}</webMaster>{/if}
    {if isset($feed.image) && !empty($feed.image)}
      <image>
	{if isset($feed.description) && !empty($feed.description)}<description>{$feed.description}</description>{/if}
        {if isset($feed.link) && !empty($feed.link)}<link>{$feed.link}</link>{/if}
        <title>{$feed.title}</title>
        <url>{$file_location}/{$feed.image}</url>
      </image>
  {/if}



{*!!! Change the action="" and add the hierarchy="" or category="" parameters below to limit your feed to a certain hierarchy or category *}
{*!!! See the Products module help for more information and parameters *}    
     {capture assign='product_list'}{Products sortby="modified" sortorder="desc"}{/capture}
       
       
     {counter name='item_counter' assign='item_count' print=false}     {* Start the counter that will limit the number of items displayed in the feed *}
     {foreach from=$items item='entry'} {* Start the FOREACH loop that will go through each item returned from the Products call above}

{*!!! Here you can specify the number of products you want to be displayed in your feed. Replace the example 10 with your desired number. *}    
     {if $item_count <= 10 }  {* Use an IF statement to check if we should continue *}
        <item>
             <title>{$entry->product_name}</title>
              <link>{$entry->detail_url}</link>
              <price>{$entry->price|string_format:"%.2f"}</price>
              <description>{$entry->details|strip_tags:true}
              
{*!!! Specify if you want images to be displayed in your feed descriptions *}
{*!!! value=1 - Turn Images Off *}
                {assign var='images_off' value=0}
                
                {if $images_off != 1}            
                
                  {* Start the counter that will limit the number of images displayed. Start with 0 so non-image fields aren't displayed *}
                  {counter name=$item_count start=0 assign='image_count' print=false}  
                  {foreach from=$entry->fields key='name' item='field'}   {*Start the FOREACH loop that will go through each of the Products fields *}
                
                   {* Check if the field type is an image and if it has a thumbnail. If both test TRUE, increase the counter. *}
                   {* We are limiting the images to thumbnails so the images in the feeds aren't too large *}
                   {if $field->type == 'image' && isset($field->thumbnail)} 
                     {counter name=$item_count print=false}   {* Add 1 to the image counter *}
                   {/if}

{*!!! Here you can specify the number of images you wish to have displayed in the Item Description *}
{*!!! Replace the $image_count number in the next line with the number of images you wish to have displayed in your description. Enter 0 (zero) for none *}
                   {if $image_count == 1}
                        <![CDATA[<br /><img src="{$entry->file_location}/{$field->thumbnail}" alt="{$entry->product_name}" />]]>
                     {counter name=$item_count print=false}   {* Add 1 to the image counter *}
                   {/if}
                
                  {/foreach}  {* End FOREACH for Products Fields *}

                {/if}   {* End Images_Off *}
              </description>
        </item>
     {/if}  {* End $item_count *}
     {counter name='item_counter' print=false}  {* Increase item_counter by 1 *}
     {/foreach}
  </channel>
</rss>