{* Display photos from the Products Module in a RSS Feed *}
{* This template displays the most recently added products *}
{* Specific categories or hierarchy items can be specified *} 
{* See the comments below that start with !!! - They outline various settings you can change *}
{* template generously supplied by Tyler Boespflug *}

<?xml version="1.0"?>
<rss version="2.0" xmlns:atom="http://www.w3.org/2005/Atom">
  <channel>
  {* note: if you have not configured pretty urls or mod rewrite, the next line may fail when trying to validate the feed *}
  <atom:link href="{$feed_url}" rel="self" type="application/rss+xml" />
    <title>{$feed.title}</title>
	{if isset($feed.link) && !empty($feed.link)}<link>{$feed.link}</link>{/if}
	{if isset($feed.description) && !empty($feed.description)}<description>{$feed.description}</description>{/if}
	{if isset($feed.copyright) && !empty($feed.copyright)}<copyright>{$feed.copyright}</copyright>{/if}
	{if isset($generator)}<generator>{$generator}</generator>{/if}
	{if isset($feed.managing_editor) && !empty($feed.managing_editor)}<managingEditor>{$feed.managing_editor}</managingEditor>{/if}
	{if isset($admin_email)}<webMaster>{$admin_email}{if isset($admin_user->firstname) && isset($admin_user->lastname) && !empty($admin_user->firstname) && !empty($admin_user->lastname)} ({$admin_user->firstname} {$admin_user->lastname}){/if}</webMaster>{/if}
	{if isset($feed.image) && !empty($feed.image)}
	  <image>
		{if isset($feed.description) && !empty($feed.description)}<description>{$feed.description}</description>{/if}
		{if isset($feed.link) && !empty($feed.link)}<link>{$feed.link}</link>{/if}
		<title>{$feed.title}</title>
		<url>{$file_location}/{$feed.image}</url>
	   </image>
	{/if}
{*!!! Change the action="" and add the hierarchy="" or category="" parameters below to limit your feed to a certain hierarchy or category *}
{*!!! See the Products module help for more information and parameters *}    
{*!!! Limit the number of Products displayed in the feed with the pagelimit="" parameter *}
	{capture assign='product_list'}{Products pagelimit="20" sortby="modified" sortorder="desc"}{/capture}      
	{foreach from=$items item='entry'} {* Start the FOREACH loop that will go through each item returned from the Products call above*}
		<item>
			<title><![CDATA[{$entry->product_name}]]></title>
			<link>{$entry->detail_url}</link>
			<description><![CDATA[{$entry->details|strip_tags:true}            
{*!!! Specify below if you want images to be displayed in your feed descriptions *}
{*!!! value=1 - Turn Images Off *}
				{assign var='images_off' value=0}             
				{if $images_off != 1}                         
              {* Start the counter that will limit the number of images displayed. Start with 0 so non-image fields aren't displayed *}
             {counter start=0 assign='image_count' print=false}  
             {foreach from=$entry->fields key='name' item='field'}   {*Start the FOREACH loop that will go through each of the Products fields *}      
               {* Check if the field type is an image and if it has a thumbnail. If both test TRUE, increase the counter. *}
               {* We are limiting the images to thumbnails so the images in the feeds aren't too large *}
                   {if $field->type == 'image' && isset($field->thumbnail)} 
                     {counter print=false}   {* Add 1 to the image counter *}       
{*!!! Here you can specify the number of images you wish to have displayed in the Item Description *}
{*!!! Replace the $image_count number in the next line with the number of images you wish to have displayed in your description.*}
                        {if $image_count <= 1}
                          <br /><img src="{$entry->file_location}/{$field->thumbnail}" alt="{$entry->product_name}" />
                        {/if}
                	{/if}
                   {/foreach}  {* End FOREACH for Products Fields *}
                {/if} {* End Images_Off *}
              ]]></description>
              <pubDate>{$entry->modified_date|rfc_date}</pubDate>
              <guid>{$entry->detail_url}</guid>
        </item>
     {counter name='item_counter' print=false}  {* Increase item_counter by 1 *}
     {/foreach}
  </channel>
</rss>