{* Display photos from the Album Module in a RSS Feed *}
{* This template displays the most recently added photos *}
{* Specific albums can be specified *} 
{* template generously donated by Tyler Boespflug *}

<?xml version="1.0"?>
<rss version="2.0">
  <channel>
    <title>{$feed.title}</title>
    {if isset($feed.link) && !empty($feed.link)}<link>{$feed.link}</link>{/if}
    {if isset($feed.description) && !empty($feed.description)}<description>{$feed.description}</description>{/if}
    {if isset($feed.copyright) && !empty($feed.copyright)}<copyright>{$feed.copyright}</copyright>{/if}
    {if isset($generator)}<generator>{$generator}</generator>{/if}
    {if isset($feed.managing_editor) && !empty($feed.managing_editor)}<managingEditor>{$feed.managing_editor}</managingEditor>{/if}
    {if isset($admin_email)}<webMaster>{$admin_email}</webMaster>{/if}
    {if isset($feed.image) && !empty($feed.image)}
      <image>
	{if isset($feed.description) && !empty($feed.description)}<description>{$feed.description}</description>{/if}
        {if isset($feed.link) && !empty($feed.link)}<link>{$feed.link}</link>{/if}
        <title>{$feed.title}</title>
        <url>{$file_location}/{$feed.image}</url>
      </image>
    {/if}
 
    {capture assign='photos'}
      {* You can limit which albums you want the feed to access. Ex: albums='1,3,4' - Remove the parameter if you want  all albums to be accessed *}
      {* Specify the number of photos you want to be displayed in your feed with number='' *}
      {* See the Album module help for more information and parameters *}
      {cms_module module='album' action='recently_updated' albums='4' number='15'}
    {/capture}    

    {foreach from=$pictures item='entry'}
    <item>
      <title>{$entry->name}</title>
      <link>{$entry->picture}</link>
      <description> 
	   <![CDATA[<a href="{$entry->picture}"<img src="{$entry->thumbnail}" alt="image" width="{$entry->thumbnailwidth}" height="{$entry->thumbnailheight}"/></a><br/>
	   {$entry->comment} {$entry->comment2} {$entry->comment3}<hr />]]>
      </description>
    </item>
    {/foreach}
  </channel>
</rss>
