<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFeedMaker - A flexible tool for the creation and management
#         of RSS Feeds
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
$this->SetCurrentTab('details');
if( !$this->CheckPermission('Manage RSS Feeds') )
{
  echo $this->ShowErrors($this->Lang('error_nopermission'));
  return;
}

if( $name != '' ) {
  $url = $this->CreateFeedURL('cntnt01',$name);
  $smarty->assign('feed_url',$url);
}

# Give some stuff to smarty
$smarty->assign('input_name',
		$this->CreateInputText($id,'input_name',$name,50,255));

$smarty->assign('input_extension',
		$this->CreateInputText($id,'input_extension',$extension,10,20));

$contentops =& $gCms->GetContentOperations();
$smarty->assign('input_pageid',
		$contentops->CreateHierarchyDropdown('',$pageid,$id.'input_pageid',1));
$smarty->assign('input_title',
		$this->CreateInputText($id,'input_title',$title,50,255));
$smarty->assign('input_link',
		$this->CreateInputText($id,'input_link',$link,50,255));
$smarty->assign('input_description',
		$this->CreateInputText($id,'input_description',$description,80,255));
$smarty->assign('input_copyright',
		$this->CreateInputText($id,'input_copyright',$copyright,50,255));
$smarty->assign('input_editor',
		$this->CreateInputText($id,'input_editor',$editor,50,255));
$smarty->assign('input_ttl',
		$this->CreateInputText($id,'input_ttl',sprintf("%d",$ttl),5,5));
$smarty->assign('value_image',$image);
$smarty->assign('input_image',
		$this->CreateFileUploadInput($id,'input_image','',50));

# Get Category info
$query = 'SELECT * FROM '.cms_db_prefix().'module_cgfeedmaker_categories';
$tmp = $db->GetArray($query);
$selcategories = array();
for( $i = 0; $i < count($tmp); $i++ )
{
  $selcategories[$tmp[$i]['name']] = $tmp[$i]['id'];
}
if( count($selcategories) )
{
  $smarty->assign('input_categories',
		  $this->CreateInputSelectList($id,'input_categories[]',
					       $selcategories,$categories));
}

# Process The Template
return $this->ProcessTemplate('admin_addfeed_details.tpl');

#
# EOF
#
?>