<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFeedMaker - A flexible tool for the creation and management
#         of RSS Feeds
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
$this->SetCurrentTab('feeds');
if( !$this->CheckPermission('Manage RSS Feeds') )
{
  echo $this->ShowErrors($this->Lang('error_nopermission'));
  return;
}


# Initialization
$feedid = '';
$config =& $gCms->GetConfig();
$name = '';
$pageid = '';
$title = '';
$extension = '';
$link = '';
$description = '';
$copyright = '';
$editor = '';
$ttl = 0;
$image = '';
$template = file_get_contents(__DIR__.'/templates/orig_feed_template.tpl');
$error = '';
$categories = array();

# Get Input Parameters
if( isset($params['feed']) )
{
  // we're editing a feed.
  $feedid = (int)$params['feed'];

  $query = 'SELECT * FROM '.cms_db_prefix().'module_cgfeedmaker WHERE id = ?';
  $row = $db->GetRow($query,array($feedid));
  $name = $row['name'];
  $extension = $row['extension'];
  $pageid = $row['pageid'];
  $title = $row['title'];
  $link = $row['link'];
  $description = $row['description'];
  $copyright = $row['copyright'];
  $editor = $row['managing_editor'];
  $ttl = (int)$row['ttl'];
  $image = $row['image'];
  $template = $row['template'];

  $query = 'SELECT * FROM '.cms_db_prefix().'module_cgfeedmaker_feed_categories WHERE feed_id = ?';
  $tmp = $db->GetArray($query,array($feedid));
  foreach($tmp as $one)
    {
      $categories[] = $one['category_id'];
    }
}
if( isset($params['input_name']) )
{
  $name = munge_string_to_url(trim($params['input_name']));
}
if( isset($params['input_extension']) )
{
  $extension = munge_string_to_url(trim($params['input_extension']));
}
if( isset($params['input_pageid']) )
{
  $pageid = munge_string_to_url(trim($params['input_pageid']));
}
if( isset($params['input_title']) )
{
  $title = trim($params['input_title']);
}
if( isset($params['input_link']) )
{
  $link = trim($params['input_link']);
}
if( isset($params['input_description']) )
{
  $description = trim($params['input_description']);
}
if( isset($params['input_copyright']) )
{
  $copyright = trim($params['input_copyright']);
}
if( isset($params['input_editor']) )
{
  $editor = trim($params['input_editor']);
}
if( isset($params['input_ttl']) )
{
  $ttl = (int)$params['input_ttl'];
}
if( isset($params['input_categories']) )
{
  $categories = $params['input_categories'];
}
if( isset($params['input_template']) )
{
  $template = trim($params['input_template']);
}


# Handle form submission
if( isset($params['cancel']) )
{
  $this->RedirectToTab($id);
}
else if( isset($params['resettemplate']) )
{
  $template = file_get_contents(__DIR__.'/templates/orig_feed_template.tpl');
}
else if( isset($params['submit']) )
{
  //
  // Check the data
  //

  if( empty($name) )
    {
      $error = $this->Lang('error_nonamegiven');
    }
  else if( empty($title) )
    {
      $title = $name;
    }
  if( empty($error) && empty($template) )
    {
      $error = $this->Lang('error_notemplate');
    }
  if( empty($error) )
    {
      // check for an existing name
      if( empty($feedid) )
	{
	  $query = 'SELECT id FROM '.cms_db_prefix().'module_cgfeedmaker WHERE name = ? LIMIT 1';
	  $tmp = $db->GetOne($query,array($name));
	  if( $tmp )
	    {
	      $error = $this->Lang('error_nameexists');
	    }
	}
      else
	{
	  $query = 'SELECT id FROM '.cms_db_prefix().'module_cgfeedmaker WHERE name = ? AND id != ? LIMIT 1';
	  $tmp = $db->GetOne($query,array($name,$feedid));
	  if( $tmp )
	    {
	      $error = $this->Lang('error_nameexists');
	    }
	}
    }
  
  // Process file upload
  // and set the image value
  if( empty($error) )
    {
      $destdir = cms_join_path($config['uploads_path'],$this->GetName());
      cge_dir::mkdirr($destdir);
      if( !is_dir($destdir) ) die('directory still does not exist');
      $handler = new cge_uploader($id,$destdir);
      $handler->set_allow_overwrite();
      $handler->set_accepted_filetypes('png,jpg,jpeg,gif'); // todo, preference
      $res = $handler->handle_upload('input_image');
      $err = $handler->get_error();
      if( !$res && $err != cg_fileupload::NOFILE )
	{
	  $err = $handler->get_error();
	  $error = sprintf("%s %s: %s",$this->Lang('field'),'input_file',
			   $this->GetUploadErrorMessage($err));
	}
      else
	{
	  if( $res )
	    {
	      $image = $res;
	    }
	}
    }

  //
  // That's it... the rest of the stuff is optional
  //
  
  if( empty($error) )
    {
      $now = $db->DbTimeStamp(time());
      if( empty($feedid) )
	{
	  // We're adding a feed.
	  $query = 'INSERT INTO '.cms_db_prefix()."module_cgfeedmaker
             (name,extension,pageid,title,link,description,copyright,managing_editor,
              ttl,image,template,create_date,modified_date)
            VALUES (?,?,?,?,?,?,?,?,?,?,?,$now,$now)";
	  $db->Execute($query,
		       array($name,$extension,$pageid,$title,$link,$description,$copyright,
			     $editor,$ttl,$image,$template));
	  $feed_id = $db->Insert_ID();
	  
	  // Add Categories
	  if(count($categories))
	    {
	      $query = 'INSERT INTO '.cms_db_prefix().'module_cgfeedmaker_feed_categories (feed_id,category_id) VALUES(?,?)';
	      foreach($categories as $one)
		{
		  $db->Execute($query,array($feed_id,$one));
		}
	    }
	}
      else
	{
	  // We're editing a feed
	  $query = 'UPDATE '.cms_db_prefix()."module_cgfeedmaker
             SET name = ?, extension = ?, pageid = ?, title = ?, link = ?, description = ?, copyright = ?,
                 managing_editor = ?, ttl = ?, image = ?, template = ?,
                 modified_date = $now
             WHERE id = ?";
	  $res = $db->Execute($query,
			      array($name,$extension,$pageid,$title,$link,$description,$copyright,
				    $editor,$ttl,$image,$template,$feedid));
	  if( !$res )
	    {
	      die($db->sql.'<br/>'.$db->ErrorMsg());
	    }

	  // Do Catgories
	  $query = 'DELETE FROM '.cms_db_prefix().'module_cgfeedmaker_feed_categories
                     WHERE feed_id = ?';
          $db->Execute($query,array($feedid));

	  // Add Categories
	  if(count($categories))
	    {
	      $query = 'INSERT INTO '.cms_db_prefix().'module_cgfeedmaker_feed_categories (feed_id,category_id) VALUES(?,?)';
	      foreach($categories as $one)
		{
		  $res = $db->Execute($query,array($feedid,$one));
		  if( !$res )
		    {
		      die($db->sql.'<br/>'.$db->ErrorMsg());
		    }
		}
	    }
	}

      // Redirect
      $this->RedirectToTab($id);
    }
}

//
// Display output
//
if( !empty($error) )
{
  echo $this->ShowErrors($error);
}

# Give some stuff to smarty
$parms = array();
if( !empty($feedid) )
{
  $parms['feed'] = $feedid;
}
$smarty->assign('formstart',$this->CGCreateFormStart($id,'addfeed',$returnid,$parms,false,'post','multipart/form-data'));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('submit',$this->CreateInputSubmit($id,'submit',$this->Lang('submit')));
$smarty->assign('cancel',$this->CreateInputSubmit($id,'cancel',$this->Lang('cancel')));

$smarty->assign('starttabheader',$this->StartTabHeaders());
$smarty->assign('tabheader_details',$this->SetTabHeader('details',$this->Lang('details')));
$smarty->assign('tabheader_template',$this->SetTabHeader('template',$this->Lang('template')));
$smarty->assign('endtabheader',$this->EndTabHeaders());

$smarty->assign('starttabcontent',$this->StartTabContent());
$smarty->assign('starttab_details',$this->StartTab('details',$params));
$smarty->assign('tab_details',include(__DIR__.'/function.admin_addfeed_details.php'));
$smarty->assign('endtab',$this->EndTab());
$smarty->assign('starttab_template',$this->StartTab('template',$params));
$smarty->assign('tab_template',include(__DIR__.'/function.admin_addfeed_template.php'));
$smarty->assign('endtabcontent',$this->EndTabContent());


# Process Template
echo $this->ProcessTemplate('addfeed.tpl');

#
# EOF
#
?>