<?php

define('CMSMS_ROOT', dirname(dirname(dirname($_SERVER['SCRIPT_FILENAME']))));
define('DS', DIRECTORY_SEPARATOR);

require_once CMSMS_ROOT.DS.'config.php';
require_once CMSMS_ROOT.DS.'version.php';
require_once CMSMS_ROOT.DS.'lib'.DS.'misc.functions.php';
require_once CMSMS_ROOT.DS. ((version_compare($CMS_VERSION, '1.0.4', '<')) ? 'include.php' : 'lib'.DS.'adodb.functions.php');
require_once cms_join_path(CMSMS_ROOT,'lib','page.functions.php');
require_once cms_join_path('lib','classes','class.PlaylistManager.php');

if (!isset($_GET['playlist']))
{
	die();
}

$playlist_id = (int) $_GET['playlist'];

$encoding = $config['admin_encoding'];
header("Content-Type: application/xspf+xml; charset=$encoding");
echo '<?xml version="1.0" encoding="'.$encoding.'"?>'. "\n";
?>
<playlist version="0" xmlns="http://xspf.org/ns/0/">
<trackList>
<?php
if (version_compare($CMS_VERSION, '1.0.4', '>='))
{
	load_adodb();
	$db =& adodb_connect();
}

$playlist_manager =& new PlaylistManager($db);

$playlist =& $playlist_manager->getPlaylistById($playlist_id);

$count_downloads = isset($_GET['count_downloads']) && (bool) $_GET['count_downloads'] == false ? false : true;
if(no_direct_downloads())
{
	$count_downloads = true;
}

foreach ($playlist->Songs as $song)
{
	echo '<track>' . "\n";
	switch ($count_downloads)
	{
		case true:
			echo '<location>' . $config['root_url'] . '/index.php?mact=Uploads,cntnt01,getfile,0&cntnt01showtemplate=false&cntnt01upload_id=' . $song->UploadId . '</location>' . "\n";
			break;
		case false:
			echo '<location>' . $config['root_url'] . '/uploads/' . $song->UploadCategoryPath . '/' . $song->Filename . '</location>' . "\n";
			break;
	}
	if (trim($song->Author) != '')
	{
		echo '<creator>' . $song->Author . '</creator>' . "\n";
	}
	if (trim($song->Description) != '')
	{
		echo '<info>' . $song->Description . '</info>' . "\n";
	}
	echo '<title>' . $song->Summary . '</title>' . "\n";
	$thumb = $playlist_manager->getThumb($config, $song);
	if ($thumb)
	{
		echo "<image>$thumb</image>\n";
	}
	echo '</track>' . "\n";
}
?>
</trackList>
</playlist>
		
<?php

function no_direct_downloads()
{
	global $db;
	$query = "
		SELECT sitepref_value FROM " . cms_db_prefix() . "siteprefs
		WHERE sitepref_name = 'EnhancedXSPF_mapi_pref_no_direct_downloads'
	";
	$result = $db->Execute($query);
	if ($result)
	{
		$row = $result->FetchRow();
		return $row['sitepref_value'] == '1' ? true : false;
	}
}

?>
