<?php

if (!isset($gCms)) 
{
	exit(); 
}

check_login();

if (! $this->CheckPermission('Use Enhanced XSPF'))
{
	echo $this->ShowErrors($this->Lang('err_access_denied'));
	return;
}

$messages = isset($params['messages']) ? $params['messages'] : array();

require_once cms_join_path('lib', 'classes', 'class.EnhancedXSPFAdmin.php');

// create an Admin object
$admin =& new EnhancedXSPFAdmin($this->cms->smarty, $this->cms->db, $params);


// create the tabheaders
$tabheaders = array();
foreach ($admin->getTabs() as $tabname)
{
	$tabheaders[] = $this->SetTabHeader($tabname, $this->Lang('title_admintab_' . $tabname), ($admin->getActiveTab() == $tabname));
}

// create the tabs content
$tabcontent = array();
foreach ($admin->getTabs() as $tabname)
{
	$tab = array();
	$tab['start'] = $this->StartTab($tabname);
	$this->doAction('admin_'.$tabname, $id, $params, $returnid);
	$tab['content'] = $this->ProcessTemplate('admin_'.$tabname.'.tpl');
	$tab['end'] = $this->EndTab();
	$tabcontent[] = $tab;
}

// format any messages
foreach($messages as $index => $message)
{
	$messages[$index] = $this->ShowMessage($message);
}

// assign Smarty variables
$this->smarty->assign('messages'        , $messages);
$this->smarty->assign('tabheaders_start', $this->StartTabHeaders());
$this->smarty->assign('tabheaders'      , $tabheaders);
$this->smarty->assign('tabheaders_end'  , $this->EndTabHeaders());
$this->smarty->assign('tabcontent_start', $this->StartTabContent());
$this->smarty->assign('tabcontent'      , $tabcontent);
$this->smarty->assign('tabcontent_end'  , $this->EndTabContent());

// process the template
echo $this->ProcessTemplate('defaultadmin.tpl');


?>