<?php

require_once cms_join_path('lib', 'classes', 'class.PlaylistManager.php');

if (!isset($gCms)) exit;

$this->curlang    = isset($params['lang']) && $params['lang'] != '' ? $params['lang'] : $this->cms->config['locale'];
$errors           = array();
$playlist_manager =& new PlaylistManager($this->cms->db);
$uploads          = NULL; // ref to Uploads module instance
$mode             = isset($params['song']) ? 'song' : 'playlist';

switch ($mode)
{
	case 'song':
		if (trim($params['song']) == '')
		{
			// no playlist set
			$errors[] = $this->Lang('err_no_song_specified');
		}
		break;
	case 'playlist':
		if (!isset($params['playlist']))
		{
			// no playlist set
			$errors[] = $this->Lang('err_no_playlist_or_song_specified');
		}
		elseif(trim($params['playlist']) == '')
		{
			$errors[] = $this->Lang('err_no_playlist_specified');
		}
		else
		{
			$playlist =& $playlist_manager->getPlaylistById($params['playlist']);
			if (empty($playlist))
			{
				$errors[] = $this->Lang('err_playlist_not_found');
			}
		}
		
		break;
}
if (empty($errors))
{
	foreach ($this->GetParameters() as $param)
	{
		if (! in_array($param['name'], $this->getExtraParameters()))
		{
			if (! isset($params[$param['name']]) || $params[$param['name']] === '')
			{
				$params[$param['name']] = $this->GetPreference($param['name']);
			}
		}
	}
	switch ($mode)
	{
		case 'song':
		{
			require_once cms_join_path('lib', 'classes', 'class.Song.php');
			$song =& new Song($params['song']);
			$playlist_manager->setSongDetails($song, $playlist_manager->getFileDetails($song->UploadId));
			$uploads =& $this->getModuleInstance('Uploads');
			$details =& $uploads->getUploadDetails((int) $params['song'], $returnid);
			if (isset($params['song_title']) && $params['song_title'] != '')
			{
				$song_title = $params['song_title'];
			}
			else
			{
				$song_title = 
					(
						$details['upload_author'] != '' 
						? $details['upload_author'] . ' - '
						: ''
					)
					. $details['upload_summary']
				;
			}
			$thumb = $playlist_manager->getThumb($this->config, $song);
			if ($thumb && !isset($params['main_image']))
			{
				$params['main_image'] = $thumb;
			}
			$this->smarty->assign('details'   , $details);
			$this->smarty->assign('song_title', urlencode($song_title));
			break;
		}
		case 'playlist':
		{
			$this->smarty->assign('playlist'    , $playlist);
			$this->smarty->assign('playlist_url', $this->cms->config['root_url'] . '/modules/EnhancedXSPF/playlist.xml.php');
			$this->smarty->assign('playlist_id' , $params['playlist']);
			break;
		}
	}
	
	$player_url = 
		$params['player'] == 'extended' ? 
		$params['extended_player_url'] : 
		$params['slim_player_url']
	;
	$player_height =
		$params['player'] == 'extended' ? 
		$params['extended_player_height'] :
		$params['slim_player_height']
	;
	
	$extra_parms = $this->getExtraParameters();
	$xspf_extra_parms = array();
	foreach ($extra_parms as $parm)
	{
		if (isset($params[$parm]))
		{
			$xspf_extra_parms[$parm] = $params[$parm];
		}
	}
	
	$xspf_parms = array(
		'autoresume'    => $params['autoresume'],
		'autoplay'      => $params['autoplay'],
		'autoload'      => $params['autoload'],
		'shuffle'       => $params['shuffle'],
		'repeat'        => $params['repeat']
	);
	$this->smarty->assign('count_downloads' , $this->GetPreference('no_direct_downloads') == '1' ? '1' : $params['count_downloads']);
	$this->smarty->assign('player_height'   , $player_height);
	$this->smarty->assign('player_width'    , $params['player_width']);
	$this->smarty->assign('player_url'      , $player_url);
	$this->smarty->assign('xspf_parms'      , $xspf_parms);
	$this->smarty->assign('xspf_extra_parms', $xspf_extra_parms);
}

$this->smarty->assign('mode'  , $mode);
$this->smarty->assign('errors', $errors);

echo $this->ProcessTemplate('default.tpl');

?>