<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Promotions (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow creating, interfacing with
#  and managing promotions or sales in the E-comemrce suite.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

// dummy object
$dummy = new promotion();

$db =& $this->GetDb();
$config =& $gCms->GetConfig();

$dict = NewDataDictionary($db);
$taboptarray = array('mysql' => 'TYPE=MyISAM');

// Promotions table
$flds = "
         id I KEY AUTO,
         name C(255) KEY NOT NULL,
         description X,
         image C(255),
         item_order I NOT NULL,
         type C(20) NOT NULL,
         created " . CMS_ADODB_DT . ",
         start_date " . CMS_ADODB_DT . ",
         end_date " . CMS_ADODB_DT . ",
         offer_type  C(50) NOT NULL,
         offer_data  C(255) NOT NULL,
         extra X
        ";
$sqlarray = $dict->CreateTableSQL(PROMOTIONS_TABLE,$flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

// Conditions table
$flds = "
         id I KEY AUTO,
         promotion_id I KEY NOT NULL,
         cond_type C(50) NOT NULL,
         data X NOT NULL
        ";
$sqlarray = $dict->CreateTableSQL(PROMOTIONS_COND_TABLE,$flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

// permissions
$this->CreatePermission(Promotions::MAIN_PERM,Promotions::MAIN_PERM);

// preferences
$this->SetPreference('dflt_promotion_period',1);
$this->SetPreference('dflt_offer_type',PROMOTIONS_OFFER_PERCENT);
$this->SetPreference('dflt_offer_data','.1');
$this->SetPreference('image_dir','images');
$this->SetPreference('error_invalid_code',$this->Lang('error_invalid_code'));
$this->SetPreference('error_empty_code',$this->Lang('error_empty_code'));
$this->SetPreference('msg_valid_code',$this->Lang('msg_valid_code'));
$this->SetPreference('skurequired',1);

// templates
# Setup default hierarchy report template
$fn = cms_join_path(dirname(__FILE__),'templates','orig_couponform_template.tpl');
if( file_exists( $fn ) )
  {
    $template = file_get_contents( $fn );
    $this->SetPreference(Promotions::NEWCOUPONFORM_TEMPLATE,$template);
    $this->SetTemplate('couponform_Sample',$template);
    $this->SetPreference(Promotions::DFLTCOUPONFORM_TEMPLATE,'Sample');
  }

#
# EOF
#
?>