<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGMyOrders (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module to allow for customers to see and intereact with past
#  invoices.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

//
// initialize
//
$the_template = $this->GetPreference('dflt_orderlist_template');
$order_list = '';
$max_views = 0;

//
// get the data
//
if( isset($params['email']) ) {
  $email = trim($params['email']);
  if( $email ) {
    $order_list = orders_ops::find_by_billing_email($email);
  }
}
else {
  $feu = cms_utils::get_module('FrontEndUsers');
  if( $feu ) {
    $feu_uid = $feu->LoggedInId();
    if( $feu_uid > 0 ) {
      // user is logged in.
      $order_list = orders_ops::find_by_feu_id($feu_uid);
    }
  }
}

// 
// give it to smarty
//
$summaries = '';
if( is_array($order_list) ) {
  $summaries = orders_ops::get_summary($order_list);
}
if( is_array($summaries) && count($summaries) ) {
  $max_views = $this->GetPreference('max_invoice_views',$max_views);
  $viewlist = '';
  if( $max_views > 0 ) {
    // get the number of views for each order
    $assocdata = new AssocData($db,$this->GetName());
    $viewlist = $assocdata->Get('viewdata');
    if( $viewlist ) $viewlist = unserialize($viewlist);

    // unset the orders that haven't been viewed.
    if( cge_array::is_hash($viewlist) ) {
      foreach( $viewlist as $key => $views ) {
	if( isset($summaries[$key]) ) {
	  $summaries[$key]['views'] = $views;
	}
      }
    }
  }
}
if( is_array($summaries) && count($summaries) ) {
  $invoice_page = $this->GetPreference('invoice_rpt_page',-1);
  if( $invoice_page <= 0 ) $invoice_page = $returnid;

  foreach( $summaries as $key => &$rec ) {
    if( $max_views <= 0 || !isset($rec['views']) || $rec['views'] < $max_views ) {
      $rec['view_url'] = $this->create_url($id,'view_invoice',$invoice_page,
					   array('order'=>$rec['id']));
    }
  }
  // do view url
  $smarty->assign('summaries',$summaries);
}
else {
  $smarty->assign('error',$this->Lang('error_noordersfound'));
}

echo $this->ProcessTemplateFromDatabase('orderlist_'.$the_template);

#
# EOF
#
?>