<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Products (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow users to create, manage
#  and display products in a variety of ways.
# 
# Version: 1.1.5
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if (!isset($gCms)) exit;

$thetemplate = 'detail_'.$this->GetPreference(PRODUCTS_PREF_DFLTDETAIL_TEMPLATE);
if( isset($params['detailtemplate'] ) ) {
  $thetemplate = 'detail_'.$params['detailtemplate'];
}

$cache_id = '|pd'.md5(serialize($params));
$compile_id = '';
if( !$smarty->isCached($this->GetDatabaseResource($thetemplate),$cache_id,$compile_id) ) {
  $query = new products_query;
  if( isset($params['productid']) ) {
    $query['productid'] = $params['productid'];
  }
  else if( isset($params['alias']) ) {
    $query['alias'] = $params['alias'];
  }
  $rs = $query->execute();
  if( $rs->totalrows == 1 ) {
    $onerow = $rs->get_product_for_display();
    debug_display($onerow,'after display');

    $smarty->assign('weight_units',product_ops::get_weight_units());  
    $smarty->assign('currency_symbol',product_ops::get_currency_symbol());
    $smarty->assign('entry',$onerow);
  }
  else {
    // product not found for some reason.
    $action = $this->GetPreference('prodnotfound','domsg');
    switch($action) {
    case 'do404':
      throw new CmsError404Exception('product not found');
      break;
      
    case 'do301':
      $page = $this->GetPreference('prodnotfoundpage',-1);
      if( $page != '' && $page != -1 ) {
	cge_redirect::redirect301($page);
      }
      // fall through to domsg

    case 'domsg':
    default:
      $msg = $this->GetPreference('prodnotfoundmsg',
				  $this->Lang('error_product_notfound'));
      echo $this->ProcessTemplateFromData($msg);
      return;
    }
  }
}

echo $smarty->fetch($this->GetDatabaseResource($thetemplate),$cache_id,$compile_id);

?>
