<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGJobMgr (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to manage jobs that take considerable
#  amounts of time to process.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

abstract class cgjobmgr_jobhandler
{
  protected $_job;
  private   $_values;

  static private $_instance;

  /**
   * Initialize the job manager with a job
   *
   * @param cgjobmgr_job The job object.
   */
  public function __construct(cgjobmgr_job& $job)
  {
    if( is_object(self::$_instance) )
      throw new CGJobMgrException('Attempt to create multiple job managers');

    self::$_instance = $this;
    $this->_job = $job;
  }

  /**
   * Process the job to the next step
   */
  abstract public function process();

  /**
   * Get the job instance
   */
  public static function &get_instance()
  {
    return self::$_instance;
  }

  /**
   * Attach data to the job handler.
   * This data is only valid for one request.  It is not serialized or stored.
   *
   * @param string The data key
   * @param mixed  The value.
   */
  public function set_value($key,$value)
  {
    if( !is_array($this->_values) ) $this->_values = array();
    $this->_values[$key] = $value;
  }


  /**
   * Retrieve data attached to the job handler
   *
   * @param string The data key
   * @param mixed  The default data if the data has not been set
   * @returns mixed
   */
  public function get_value($key,$dflt = '')
  {
    if( !is_array($this->_values) ) return $dflt;
    if( !isset($this->_values[$key]) ) return $dflt;
    
    return $this->_values[$key];
  }

} // end of class

#
# EOF
#
?>