<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: DocumentSearch (c) 2013 by Oliver Seddon 
#         (oliver@threefold.co.uk)
#  An addon module for CMS Made Simple to provide PDF and Word document
#  content searchability.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if (!isset($gCms)) exit;

// get our records from the database
$db = $gCms->GetDb();

$query = 'SELECT documentsearch_id, name, content, location, status, author, document_date from '.cms_db_prefix().
   'module_documentsearch';

if (isset($params['documentsearch_id']))
   {
   // *ALWAYS* use parameterized queries with user-provided input
   // to prevent SQL-Injection attacks!
   $query .= ' where documentsearch_id = ?';
   $result = $db->Execute($query,array($params['documentsearch_id']));
   $mode = 'detail'; // we're viewing a single record
   }
else
   {
   // we're not getting a specific record, so show 'em all. Probably should paginate.
   $result = $db->Execute($query);
   $mode = 'summary'; // we're viewing a list of records
   }
   
$records = array();
while ($result !== false && $row=$result->FetchRow())
   {
   // create a new object for every record that we retrieve
   $rec = new stdClass();
   $rec->id = $row['documentsearch_id'];
   $rec->name = $row['name'];
   $rec->content = $row['content'];
   $rec->location = $row['location'];
   $rec->status = $row['status'];
   $rec->author = $row['author'];
   $rec->documentdate = $row['document_date'];

   // create attributes for rendering "view" links for the object.
   // $id and $returnid are predefined for us by the module API
   // that last parameter is the Pretty URL link
   $rec->view = $this->CreateFrontendLink($id, $returnid, 'default', $this->Lang('link_view'),
      array('documentsearch_id'=>$rec->id),'',false,true,'',false,'documentsearch/view/'.$rec->id.'/'.$returnid);
   $rec->edit = $this->CreateFrontendLink($id, $returnid, 'add_edit', $this->Lang('edit'),
      array('documentsearch_id'=>$rec->id),'',false,true,'',false,'documentsearch/edit/'.$rec->id.'/'.$returnid);
   array_push($records,$rec);

   $filename = $rec->location;
   $ext = substr(strrchr($filename, '.'), 1);
   $ext = strtoupper($ext);
   $modulePath = $this->GetModuleURLPath();
   $iconpath = $modulePath . '/images/appicons/' . $ext . 'icon.gif';
   $iconfile = '<img src="' . $iconpath . '" width="16" height="16" alt="' . $filename . '" />';
   $smarty->assign('iconfile', $iconfile);
   }



  $entryarray = array();
  $query1 = "
            SELECT 
                md.*, 
                mdc.documentsearch_category_name, 
                mdc.long_name
            FROM " . 
    cms_db_prefix() . "module_documentsearch md
            LEFT OUTER JOIN " . cms_db_prefix() . "module_documentsearch_categories mdc 
            ON mdc.documentsearch_category_id = md.documentsearch_category_id 
        ";

  $query2 = "
            SELECT count(md.documentsearch_id) as count
            FROM " . 
    cms_db_prefix() . "module_documentsearch md
            LEFT OUTER JOIN " . cms_db_prefix() . "module_documentsearch_categories mdc 
            ON mdc.documentsearch_category_id = md.documentsearch_category_id 
        ";

            
  if( isset($params['category_id']) ) {
    $query1 .= "AND ( mdc.documentsearch_category_id = '".(int)$params['category_id']."' ) AND ";
    $query2 .= "AND ( mdc.documentsearch_category_id = '".(int)$params['category_id']."' ) AND ";
  }
  else if (isset($params["category"]) && $params["category"] != '' && $params["category"] != 'none') {
    $category = cms_html_entity_decode(trim($params['category']));
    $categories = explode(',', $category);
    $query1 .= "AND (";
    $query2 .= "AND (";
    $count = 0;
    foreach ($categories as $onecat) {
      if ($count > 0) {
	$query1 .= ' OR ';
	$query2 .= ' OR ';
      }
      if (strpos($onecat, '|') !== FALSE || strpos($onecat, '*') !== FALSE) {
	$tmp = $db->qstr(trim(str_replace('*', '%', str_replace("'",'_',$onecat))));
	$query1 .= "upper(mdc.long_name) like upper({$tmp})";
	$query2 .= "upper(mdc.long_name) like upper({$tmp})";
      }
      else {
	$tmp = $db->qstr(trim(str_replace("'",'_',$onecat)));
	$query1 .= "mdc.documentsearch_category_name = {$tmp}";
	$query2 .= "mdc.documentsearch_category_name = {$tmp}";
      }
      $count++;
    }
    $query1 .= ") ";
    $query2 .= ") ";
  }

  $sortrandom = false;        
  if (isset($params['sortby'])) {
    if ($params['sortby'] == 'date') {
      $query1 .= "ORDER BY document_date ";
    } 
    else if ($params['sortby'] == 'random') {
      $query1 .= "ORDER BY RAND() ";
      $sortrandom = true;
    }
    else {
      $query1 .= "ORDER BY md." . str_replace("'", '', str_replace(';', '', $db->qstr($params['sortby']))) . " ";
    }
  } 
  else {
    $query1 .= "ORDER BY documentsearch_category_id "; 
  }
  if( $sortrandom == false ) {
    if (isset($params['sortdesc']) && 
	(strtolower($params['sortdesc']) == 'true')) {
      $query1 .= "desc"; 
    } 
    else {
      $query1 .= "asc"; 
    }
  }

  $dbresult = '';
  $dbresult = $db->Execute($query1);

  while( $dbresult && !$dbresult->EOF ) {
    $row = $dbresult->fields;
    $onerow = new stdClass();
    
    $onerow->id = $row['documentsearch_id'];
    $onerow->title = $row['name'];
    $onerow->summary = (trim($row['content'])!='<br/>'?$row['content']:'');
    $onerow->location = $row['location'];
    $onerow->category = $row['documentsearch_category_name'];
    $onerow->status = $row['status'];
    $onerow->author = $row['author'];
    $onerow->documentdate = $row['document_date'];

    
    $sendtodetail = array('documentsearchid'=>$row['documentsearch_id']);
    if (isset($params['showall'])) {
      $sendtodetail['showall'] = $params['showall'];
    }
    if (isset($params['detailpage'])) {
      $sendtodetail['origid'] = $returnid;
    }
    if (isset($params['detailtemplate'])) {
      $sendtodetail['detailtemplate'] = $params['detailtemplate'];
    }
    
    $prettyurl = $row['location'];
    if( $prettyurl == '' ) {
      $aliased_title = munge_string_to_url($row['name']);
      $prettyurl = 'documentsearch/'.$row['documentsearch_id'].'/'.($detailpage!=''?$detailpage:$returnid)."/$aliased_title";
      if (isset($sendtodetail['detailtemplate'])) {
	$prettyurl .= '/d,' . $sendtodetail['detailtemplate'];
      }
    }

    if (isset($params['lang'])) {
      $sendtodetail['lang'] = $params['lang'];
    }

    if (isset($params['category_id'])) {
      $sendtodetail['category_id'] = $params['category_id'];
    }

    if (isset($params['pagelimit'])) {
      $sendtodetail['pagelimit'] = $params['pagelimit'];
    }

    $onerow->link = $this->CreateLink($id, 'detail', $detailpage!=''?$detailpage:$returnid, '', $sendtodetail,'', true, false, '', true, $prettyurl);
    $onerow->titlelink = $this->CreateLink($id, 'detail', $detailpage!=''?$detailpage:$returnid, $row['name'], $sendtodetail, '', false, false, '', true, $prettyurl);
    $onerow->morelink = $this->CreateLink($id, 'detail', $detailpage!=''?$detailpage:$returnid, $moretext, $sendtodetail, '', false, false, '', true, $prettyurl);
    $onerow->moreurl = $this->CreateLink($id, 'detail', $detailpage!=''?$detailpage:$returnid, $moretext, $sendtodetail, '', true, false, '', true, $prettyurl);
    $onerow->postdate = $row['document_date'];

    $entryarray[]= $onerow;
    $dbresult->MoveNext();
  }

  $smarty->assign('itemcount', count($entryarray));
  $smarty->assign('items', $entryarray);
  $smarty->assign('category_label', $this->Lang('category_label'));
  $smarty->assign('status_label', $this->Lang('status_label'));
  $smarty->assign('author_label', $this->Lang('author_label'));

  $catName = '';
  if (isset($params['category'])) {
    $catName = $params['category'];
  }
  else if (isset($params['category_id'])) {
    $catName = $db->GetOne('SELECT documentsearch_category_name FROM '.cms_db_prefix() . 'module_documentsearch_categories where documentsearch_category_id=?',array($params['category_id']));		
  }
  $smarty->assign('category_name',$catName);
 
  unset($params['pagenumber']);
  $items = documentsearch_ops::get_categories($id,$params,$returnid);
  $smarty->assign('count', count($items));
  $smarty->assign('cats', $items);


// Expose the list to smarty.
$this->smarty->assign('records',$records);

// Tell Smarty which mode we're in
$this->smarty->assign('mode',$mode);

// and a count of records
$this->smarty->assign('title_num_records',$this->Lang('title_num_records',array(count($records))));


$catName = '';
if (isset($params['category'])) {
	$catName = $params['category'];
} else if (isset($params['category_id'])) {
	$catName = $db->GetOne('SELECT documentsearch_category_name FROM '.cms_db_prefix() . 'module_documentsearch_categories where documentsearch_category_id=?',array($params['category_id']));		
}
$smarty->assign('category_name',$catName);


if (isset($params['module_message']))
   {
   $this->smarty->assign('module_message',$params['module_message']);
   }
else
   {
   $this->smarty->assign('module_message','');
   }


// Display the populated template
echo $this->ProcessTemplate('documentsearch_list.tpl');

?>