<?php
#CMS - CMS Made Simple
#(c)2011 by Peter Orije (pedrosken@gmail.com)
#This project's homepage is: http://www.web2do.be
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

function smarty_cms_function_toggle_start($params, &$smarty)
{
	static $firstToggle = true;//only gets set one time per page
	
	if (!empty($params['title'])) {
		$title = $params['title'];
	}
	else {
		$title = '';
	}


	if ($params['status'] == "active" || $params['status'] == "Active" ) {
		$status = "active";
	}
	else {
		$status = '';
	}


	if ($firstToggle) {
                
		echo '
<script type="text/javascript">
    $(document).ready(function() {
        $(".toggle_container").hide();
        $(".active").slideToggle("slow,");
        $(".active").prev("h2.trigger").addClass("active"); 

        /*$("h2.trigger").toggle(function(){
            $(this).addClass("active"); 
            }, function () {
            $(this).removeClass("active");
        });*/

        $("h2.trigger").click(function(){		
            $(this).next(".toggle_container").slideToggle("slow,");

            if ($(this).hasClass("active")){
                $(this).removeClass("active");
            }else{
                //toggle all other open containers first
                $(".active").next(".toggle_container").slideToggle("slow,");
                $(".active").removeClass("active");
                $(this).addClass("active"); 
            }
        });
    });
</script>
';

		
		
		
		$firstToggle = false;
	}
	
	echo '<h2 class="trigger">'.$title.'</h2>
	<div class="toggle_container '.$status.'">
		<div class="block">
			';
	
	
}

function smarty_cms_help_function_toggle_start() {
	?>
	<h3>What does this do?</h3>
	<p>It creates a div (&quot;block&quot;) witch can collapse and expand by pressing the bar, it uses JQuery.<br />
	You can view a demo here : <a href="http://www.web2do.be/content_toggle" target="_blank">DEMO</a><br />
        Write your comments and donations are always welcome! <a href="http://www.web2do.be/content_toggle" target="_blank">Content Toggle Plugin 1.3</a><br />
</p>

<h3>How to install?</h3>
<p>Make sure you have Jquery loaded in your header tag. I mostly use this line of code in my haeader:<br />
    <pre id="line1">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;script src=&quot;<a href="view-source:http://ajax.googleapis.com/ajax/libs/jquery/1/jquery.js">http://ajax.googleapis.com/ajax/libs/jquery/1/jquery.js</a>&quot;&gt; &lt;/script&gt;
&lt;/head&gt;
    </pre>
<br /><br />
Also add this css code to your Stylesheet : <br />
<pre>

/* Content togle css
----------------------------------------*/
h2.trigger {
    background: url("/lib/toggle/trigger.gif") no-repeat scroll 0 0 transparent;
    background-size: 100% 60px;
    color: #333333 !important;
    cursor: pointer;
    font-size: 1.2em !important;
    font-weight: normal !important;
    height: 30px !important;
    line-height: 30px !important;
    margin: 0 0 5px !important;
    padding: 0 0 0 50px !important;
    /*change width if you want fixed e.g.: 575px; or auto;
         also change this in your .toggle_container! */
    width: auto;
    border: none !important;
}
h2.trigger:hover {
    color: #666666;
}
h2.active {
    background-position: left bottom;
}
.toggle_container {
    background: url("/lib/toggle/toggle_block_stretch.gif") repeat-y scroll left top #F0F0F0;
    background-size: 100% auto;
    border-top: 1px solid #D6D6D6;
    margin: 0 0 5px;
    overflow: hidden;
    padding: 0;
    /*change width if you want fixed e.g.: 625px; or auto; */
    width: auto;
}
.toggle_container .block {
    background: url("/lib/toggle/toggle_block_btm.gif") no-repeat scroll left bottom transparent;
    background-size:100% auto;
    padding: 20px;
}
.toggle_container .block p {
    margin: 5px 0;
    padding: 5px 0;
}
.toggle_container h3 {
    border-bottom: 1px dashed #CCCCCC;
    margin: 0 0 10px;
    padding: 0 0 5px;
}
.toggle_container img {
    background: none repeat scroll 0 0 #DDDDDD;
    border: 1px solid #CCCCCC;
    /*float: left;*/
    margin: 10px 15px 15px 0;
    padding: 5px;
}
/* END Content togle css */
</pre>

</p>


       <h3>How do I use it?</h3>
<p>Just insert the tag into your content or template like: <code>{toggle_start title="text line for the top bar"}</code><br />
  and close it with <code>{toggle_end}</code><br />
  <br />
  <strong>Example:</strong><br />
  <pre>
  {toggle_start title=&quot;Web Design &amp; Development&quot;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;HTML code like pictures, text or content place them here ...
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;...
  {toggle_end}
</pre>
<br />
<br />


</p>
<h3>The result: </h3>
<img src="../lib/toggle/sample2.gif" /><br />
<br />
For personal changes you can edit the top bar (trigger.gif)
like this example:<br />
<img src="../lib/toggle/sample.gif" /><br />

  
<p>&nbsp;</p>
<h3>TinyMCE option:</h3>
<p><u>For easy use, you can edit TinyMCE (optional)</u><br />
  goto admin / Extentsions /TinyMce WYSIWYG<br />
open tab Advanced, scroll down and edit &quot;Custom dropdown:&quot;</p>
<p>add this code or change original:<br />
    <textarea class="pagesmalltextarea" style="height: 80px;">
  ---|---
  Start expand/collapse-area|{toggle_start title=\'This is my expandable area\'}
  End expand/collapse-area|{toggle_end}
  ---|---
    </textarea>
</p>
<p>and save<br />
  now you can use the icon &quot;Specifik Dropdown-menu&quot; in TinyMCE menubar.</p>
<p>&nbsp; </p>
<h3>Parameters</h3>
<ul>
  <li><em>(optional)</em> title=&quot;some text here&quot; - Display title in the bar.</li>
  <li><em>(optional)</em> status=&quot;active&quot; - This 'll show the content, if omitted the content 'll be collapsed by default.</li>

</ul>
<p>&nbsp;</p>

done... 
	  <?php
}



function smarty_cms_about_function_toggle_start() {
	?>
      
<p>Author: Peter Orije <a href="http://www.web2do.be">www.web2do.be/content_toggle</a></p>
	<p>Version: 1.3	</p>
   <p>&nbsp;</p>

 <?php
}

?>
