<?php
// Switch the order status to new one

// No direct access
$gCms = cmsms(); if( !is_object($gCms) ) exit;

// Check permission
if (! $this->CheckPermission('Modify CartMadeSimple'))
{
    // Show an error message
    echo $this->ShowError($this->Lang('access_denied'));
}
// User has sufficient privileges
else
{
	$params['id'] = $id;
	switch ($params['oldstatus'])
	{
		case 'CNF':
			$this->orders->SwitchStatus( $params );
			$params = array('active_tab' => 'order');
			break;
		case 'PAY':
			$this->orders->SwitchStatus( $params );
			$params = array('active_tab' => 'order', 'orderstatus' => 'PAY');
			break;
		case 'SHP':
			// Generate an invoice number
			$invoiceno = $this->PrepareInvoiceNo();
			$query = 'UPDATE '.cms_db_prefix().'module_cartms_orders SET status = ?, 
				invoiceno = ?, modified_date = '.$db->DBTimeStamp(time()).' 
				WHERE order_id = ?';
			$db->Execute($query, array( 'INV', $invoiceno, $params['order_id']));
			// Prepare the invoice
			$params['type'] = 'invoice_prep';
			$documenttype = $this->GetPreference('extdoc_invoice','invoice_sample');
			include(cms_join_path(dirname(__FILE__),'library','extdoc.'.$documenttype.'.php'));
			// Check if inventory to be decreased
			$this->InventoryDecrease($params['order_id'], 'INV');

			$params = array('active_tab' => 'order', 'orderstatus' => 'SHP');
			// TODO: Send the invoice
			break;
		default:
			break;
	}

    // Redirect the user to the default admin screen
    $this->Redirect($id, 'defaultadmin', $returnid, $params);
}

?>