<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if (!isset($gCms)) exit;

$db = $this->GetDb();
$dict = NewDataDictionary($db);
$taboptarray = array('mysql' => 'TYPE=MyISAM');

if( version_compare($oldversion,'1.0.1') < 0 )
  {
    $sqlarray = $dict->AddColumnSQL(CGSOCIAL_TABLE_CHECKINS,'approved I1');
    $dict->ExecuteSQLArray($sqlarray);
  }
if( version_compare($oldversion,'1.0.2') < 0 )
  {
    $txt = @file_get_contents(dirname(__FILE__).'/templates/orig_newlocation_notification_template');
    if( $txt )
      {
	$this->SetTemplate('newlocation_notification_template',$txt);
      }
  }
if( version_compare($oldversion,'1.0.3') < 0 )
  {
    $flds = "id I KEY AUTO,
         name C(255) NOT NULL,
         description X,
         image C(255),
         type C(25),
         created I,
         modified I";
    $sqlarray = $dict->CreateTableSQL(CGSOCIAL_TABLE_LEADERBOARD,$flds,$taboptarray);
    $dict->ExecuteSQLArray($sqlarray);

    $flds = "board_id I KEY,
         uid   I KEY,
         score I,
         notes X";
    $sqlarray = $dict->CreateTableSQL(CGSOCIAL_TABLE_LEADERBOARD_MEMBERS,$flds,$taboptarray);
    $dict->ExecuteSQLArray($sqlarray);
  }
if( version_compare($oldversion,'1.0.4') < 0 )
  {
    $sqlarray = $dict->AddColumnSQL(CGSOCIAL_TABLE_LEADERBOARD,'data X');
    $dict->ExecuteSQLArray($sqlarray);
  }
if( version_compare($oldversion,'1.0.6') < 0 ) {
  $this->SetupJobs();
}
if( version_compare($oldversion,'1.0.7') < 0 ) {
  $sqlarray = $dict->AddColumnSQL(CGSOCIAL_TABLE_CHECKINS,'processed I1');
  $dict->ExecuteSQLArray($sqlarray);

  $flds = "id I KEY AUTO,
           leaderboard_id I NOT NULL,
           name C(255) NOT NULL,
           description X,
           image C(255),
           notes X,
           data  X,
           min_score I,
           max_score I,
           is_unique I1,
           created   I";
  $sqlarray = $dict->CreateTableSQL(CGSOCIAL_TABLE_BADGES,$flds,$taboptarray);
  $dict->ExecuteSQLArray($sqlarray);

  $flds = "badge_id I NOT NULL,
           leaderboard_id I NOT NULL,
           uid I NOT NULL,
           created I";
  $sqlarray = $dict->CreateTableSQL(CGSOCIAL_TABLE_BADGES_USERS,$flds,$taboptarray);
  $dict->ExecuteSQLArray($sqlarray);

  $this->CreateEvent('OnBadgeAwarded');
  $this->CreateEvent('OnBadgeRevoked');
}
if( version_compare($oldversion,'1.1.1') < 0 ) {
  $flds = "uid I NOT NULL,
           fuid I NOT NULL,
           reln I NOT NULL";  /* 1 for friendship, -1 for not a friend (rejected request) */
  $sqlarray = $dict->CreateTableSQL(CGSOCIAL_TABLE_FRIENDSHIPS,$flds,$taboptarray);
  $dict->ExecuteSQLArray($sqlarray);

  $fn = dirname(__FILE__).'/templates/orig_tagged_notification.tpl';
  $tpl = @file_get_contents($fn);
  $this->SetTemplate('feu_tagged_tpl',$tpl);

  $this->AddEventHandler('FrontEndUsers','OnDeleteUser');
}

#
# EOF
#
?>