<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: FrontEndUsers (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if (!isset($gCms)) exit;

//
// create tables
//
$db = cmsms()->GetDb();
$dict = NewDataDictionary($db);
$taboptarray = array('mysql' => 'TYPE=MyISAM');

$flds = 'id I KEY AUTO NOT NULL,
         apikey C(10) KEY NOT NULL,
         appname C(255) KEY NOT NULL,
         email   C(255) NOT NULL,
         active  I1,
         perms   X,
         created I,
         modified I,
         expires I';
$sqlarray = $dict->CreateTableSQL(CGSOCIAL_TABLE_APIKEYS,$flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "id I KEY AUTO,
         name C(255) NOT NULL,
         parent_id I,
         item_order I,
         hierarchy C(255),
         data X";
$sqlarray = $dict->CreateTableSQL(CGSOCIAL_TABLE_ACTIVITIES,$flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "id I KEY AUTO,
         obid C(255),
         parent_id I,
         owner I,
         location I,
         activity I,
         lat F,
         lng F,
         msg C(255) NOT NULL,
         created I,
         approved I1,
         processed I1,
         data X";
$sqlarray = $dict->CreateTableSQL(CGSOCIAL_TABLE_CHECKINS,$flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "id I KEY AUTO,
         uid  I NOT NULL,
         when I NOT NULL,
         item C(50),
         item_id I,
         description C(255),
         notes X";     
$sqlarray = $dict->CreateTableSQL(CGSOCIAL_TABLE_LOG,$flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "id I KEY AUTO,
         name C(255) NOT NULL,
         description X,
         image C(255),
         type C(25),
         data X,
         created I,
         modified I";
$sqlarray = $dict->CreateTableSQL(CGSOCIAL_TABLE_LEADERBOARD,$flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "board_id I KEY,
         uid   I KEY,
         score I,
         notes X";
$sqlarray = $dict->CreateTableSQL(CGSOCIAL_TABLE_LEADERBOARD_MEMBERS,$flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "id I KEY AUTO,
         leaderboard_id I NOT NULL,
         name C(255) NOT NULL,
         description X,
         image C(255),
         notes X,
         data  X,
         min_score I,
         max_score I,
         is_unique I1,
         created   I";
$sqlarray = $dict->CreateTableSQL(CGSOCIAL_TABLE_BADGES,$flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "badge_id I NOT NULL,
         leaderboard_id I NOT NULL,
         uid I NOT NULL,
         created I";
$sqlarray = $dict->CreateTableSQL(CGSOCIAL_TABLE_BADGES_USERS,$flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "uid I NOT NULL,
         fuid I NOT NULL,
         reln I NOT NULL";  /* 1 for friendship, -1 for not a friend (rejected request), -2 for friend request */
$sqlarray = $dict->CreateTableSQL(CGSOCIAL_TABLE_FRIENDSHIPS,$flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

//
// create events
//
$this->CreateEvent('OnCheckin');
$this->CreateEvent('OnUpdateCheckin');
$this->CreateEvent('PreDeleteCheckin');
$this->CreateEvent('PostDeleteCheckin');
$this->CreateEvent('OnBadgeAwarded');
$this->CreateEvent('OnBadgeRevoked');
// todo: add event for LeaderboardScoreMatch or something like that
// todo: add event for BadgesChanged or something like that

//
// create permissions
//
$this->CreatePermission(CGSocialApp::PERMISSION,CGSocialApp::PERMISSION);

//
// create templates
//
$txt = @file_get_contents(dirname(__FILE__).'/templates/orig_newlocation_notification_template');
if( $txt ) {
  $this->SetTemplate('newlocation_notification_template',$txt);
 }
$fn = dirname(__FILE__).'/templates/orig_list_checkins.tpl';
if( file_exists($fn) ) {
  $src = @file_get_contents($fn);
  $this->SetTemplate('default_list_checkin_template_contents',$src);
  $this->SetTemplate('list_checkinsSample',$src);
  $this->SetPreference('current_list_checkins_template','Sample');
 }

$fn = dirname(__FILE__).'/templates/orig_list_activities.tpl';
if( file_exists($fn) ) {
  $src = @file_get_contents($fn);
  $this->SetTemplate('default_list_activities_template_contents',$src);
  $this->SetTemplate('list_activitiesSample',$src);
  $this->SetPreference('current_list_activities_template','Sample');
 }

$fn = dirname(__FILE__).'/templates/orig_view_activity.tpl';
if( file_exists($fn) ) {
  $src = @file_get_contents($fn);
  $this->SetTemplate('default_view_activity_template_contents',$src);
  $this->SetTemplate('view_activitySample',$src);
  $this->SetPreference('current_view_activity_template','Sample');
 }

//
// create preferences
//
$this->SetPreference('friendlyname',$this->GetName());
$fn = dirname(__FILE__).'/templates/orig_tagged_notification.tpl';
$tpl = @file_get_contents($fn);
$this->SetTemplate('feu_tagged_tpl',$tpl);

$this->AddEventHandler('FrontEndUsers','OnDeleteUser');

$this->SetupJobs();

#
# EOF
#
?>