<?php

class cgsa_simple_friend_manipulator extends cgsa_friend_manipulator
{
  /**
   * Retrieve the object containing the friends list
   *
   * @param string The user identifier
   * @return a cgfav object or null
   */
  private function &get_friends_obj($uid)
  {
    return cgfav_ops::load_one($uid,'CGSocialApp','friends');
  }


  /**
   * Retrieve a list of the users friends
   *
   * @param string The user identifier
   * @param integer The limit to the number of friends (not implemented)
   * @param integer The offset (not implemented)
   * @return array of uids or null
   */
  public function get_friends($uid,$limit = 100000,$offset = 0)
  {
    $obj = $this->get_friends_obj($uid);
    if( is_object($obj) ) {
      // todo: handle limit and offset.
      if( $obj->data ) return unserialize($obj->data);
    }
  }

  /**
   * Add fuid as a friend to uid
   * This is a database function only.  No events are sent.
   * This function only effects one side of the friend relationship
   *
   * @param string The user id to add to
   * @param string The friends user id.
   * @return null
   */
  public function add_friend($uid,$fuid)
  {
    if( !$fuid ) return;
    $obj = $this->get_friends_obj($uid);
    if( !is_object($obj) ) {
      $obj = new cgfav;
      $obj->uid = $uid;
      $obj->key1 = 'CGSocialApp';
      $obj->key2 = 'friends';
    }
    $friends = array();
    if( $obj->data ) {
      $friends = unserialize($obj->data);
    }
    if( !in_array($fuid,$friends) ) {
      $friends[] = $fuid;
      $obj->data = serialize($friends);
      $obj->save();
    }
  }

  /**
   * Delete a friend relationship
   * This is a database function only, no events are triggered
   * This method only deletes one side of the friend relationship, not both
   *
   * @param string The userid
   * @param string The friends user id
   * @return null
   */
  public function del_friend($uid,$fuid)
  {
    if( !$fuid ) return;
    $obj = $this->get_friends_obj($uid);
    if( is_object($obj) && $obj->data )
      {
	$friends = unserialize($obj->data);
	$func = create_function('$item,$fuid','return $item != $fuid');
	$friends = array_filter($friends,$func);
	if( count($friends) == 0 )
	  {
	    $obj->data = '';
	  }
	else
	  {
	    $obj->data = serialize($friends);
	  }
	$obj->save();
      }
  }

  /**
   * Get the object containing the list of denied friends
   *
   * @param string The userid
   * @return cgfav object or null
   */
  private function &get_notfriends_obj($uid)
  {
    return cgfav_ops::load_one($uid,'CGSocialApp','notfriends');
  }

  /**
   * Get a list of the uids that we have denied from being friends
   *
   * @param string The userid
   * @return array of user ids
   */
  public function get_notfriends($uid)
  {
    $obj = $this->get_notfriends_obj($uid);
    if( is_object($obj) )
      {
	if( $obj->data ) return unserialize($obj->data);
      }
  }

  /**
   * Add a user to our list of notfriends
   * This method only effects one side of the friendship relation, and does not explicitly remove a friend from the friendslist
   * It is possible using this method to have a uid in the friends list and not friends list.  Developers must use caution.
   * This method does the database work only, no events are sent.
   *
   * @param string The user id
   * @param string The friends user id
   * @return null
   */
  public function add_notfriend($uid,$fuid)
  {
    if( !$uid || !$fuid ) return;
    $obj = $this->get_notfriends_obj($uid);
    if( !is_object($obj) )
      {
	$obj = new cgfav;
	$obj->uid = $uid;
	$obj->key1 = 'CGSocialApp';
	$obj->key2 = 'notfriends';
      }
    $notfriends = array();
    if( $obj->data )
      {
	$notfriends = unserialize($obj->data);
      }
    if( !in_array($fuid,$friends) )
      {
	// todo: trigger an event or something... maybe a message.
	$notfriends[] = $fuid;
	$obj->data = serialize($notfriends);
	$obj->save();
      }
  }


  /**
   * Remove a user from our list of notfriends
   * This method only effects one side of the friendship relation. 
   * This method does the database work only, no events are sent.
   *
   * @param string The user id
   * @param string The friends user id
   * @return null
   */
  public function del_notfriend($uid,$fuid)
  {
    if( !$fuid ) return;
    $obj = $this->get_friends_obj($uid);
    if( is_object($obj) && $obj->data )
      {
	$notfriends = unserialize($obj->data);
	$func = create_function('$item,$fuid','return $item != $fuid');
	$notfriends = array_filter($notfriends,$func);
	if( count($notfriends) == 0 )
	  {
	    $obj->data = '';
	  }
	else
	  {
	    $obj->data = serialize($notfriends);
	  }
	$obj->save();
      }
  }


  /**
   * Get the object containing the list of current friend requests
   *
   * @param string The userid
   * @return cgfav object or null
   */
  private function &get_friendrequests_obj($uid)
  {
    return cgfav_ops::load_one($uid,'CGSocialApp','friendrequests');
  }


  public function get_friendrequests($uid,$limit = 1000,$offset = 0)
  {
    $obj = $this->get_friendrequests_obj($uid);
    if( is_object($obj) && $obj->data )
      {
	$tmp = unserialize($obj->data);
	return $tmp;
      }
  }

  /**
   * Create a friend request to the user identified by fuid from the user identified by uid
   * This function does the database work only, notifications are not sent.
   * 
   * @param string The potential friends user id
   * @param string The current users uid
   * @return null
   */
  public function add_friendrequest($fuid,$uid)
  {
    // add it to the friends requests thing

    if( !$uid || !$fuid ) return;
    $obj = $this->get_friendrequests_obj($fuid);
    if( !is_object($obj) )
      {
	$obj = new cgfav;
	$obj->uid = $fuid;
	$obj->key1 = 'CGSocialApp';
	$obj->key2 = 'friendrequests';
      }
    $requests = array();
    if( $obj->data )
      {
	$requests = unserialize($obj->data);
      }
    if( !in_array($uid,$requests) )
      {
	$requests[] = $uid;
	$obj->data = serialize($requests);
	$obj->save();
      }
  }


  /**
   * Delete a friend request to the user identified by fuid from the user identified by uid
   * This function does the database work only, notifications are not sent.
   * 
   * @param string the potential friends user id
   * @param string The current users id
   * @return null
   */
  public function del_friendrequest($fuid,$uid)
  {
    if( !$uid || !$fuid ) return;
    $obj = $this->get_friendrequests_obj($uid);
    if( is_object($obj) && $obj->data )
      {
	$requests = unserialize($obj->data);
	$func = create_function('$item,$fuid','return $item != $fuid');
	$requests = array_filter($requests,$func);
	if( count($requests) == 0 ) {
	  $obj->data = '';
	}
	else {
	  $obj->data = serialize($requests);
	}
	$obj->save();
      }
  }

  /**
   * Delete all friend information (friends list, notfriends list, request list) for a user.
   * This function does the database work only, notifications are not sent.
   * 
   * @param string The users id
   * @return null
   */
  public function delete_all($uid)
  {
    $ob = $this->get_friends_obj();
    if( is_object($ob) ) $ob->delete();
    $ob = $this->get_notfriends_obj();
    if( is_object($ob) ) $ob->delete();
    $ob = $this->get_friendrequests_obj();
    if( is_object($ob) ) $ob->delete();
  }
} // end of class

?>
