<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: FrontEndUsers (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class cgsa_leaderboard 
{
  private static $_fields = array('id','name','type','image','description','created','modified','multiplebadges','match_location','criteria_locationcategory','criteria_locationhier','criteria_locationhierchildren','criteria_activityid','criteria_activitychildren');
  private static $_rokeys = array('id','created','modified');
  private static $_types = array('location','checkins','friends','activity');
  private static $_cached;
  private $_data = array();
  private $_dirty;

  public function __construct()
  {
    $this->_data['match_location'] = 'locationid';
  }

  public function get_types() 
  {
    return self::$_types;
  }

  private static function _valid_key($key)
  {
    if( in_array($key,self::$_fields) ) return TRUE;
    if( startswith($key,'criteria_') ) return TRUE;
    if( startswith($key,'match_') ) return TRUE;
    return FALSE;
  }

  public function __get($k)
  {
    if( !self::_valid_key($k) )
      throw new Exception($k.' is not a valid field for a leaderboard');

    if( isset($this->_data[$k]) )
      return $this->_data[$k];
  }

  public function __set($k,$v)
  {
    if( !self::_valid_key($k) )
      throw new Exception($k.' is not a valid field for this object');

    if( $k == 'type' && !in_array($v,self::$_types) )
      throw new Exception($v.' is an invalid leaderboard type');

    $this->_data[$k] = $v;
    $this->_dirty = TRUE;
  }

  public function set_dirty()
  {
    $this->_dirty = TRUE;
  }

  public function save()
  {
    $this->validate();

    if( !$this->_dirty ) return;
    if( isset($this->_data['id']) && $this->_data['id'] > 0 ) {
      return $this->update();
    }
    return $this->insert();
  }

  protected function validate()
  {
    if( !isset($this->_data['name']) || trim($this->_data['name']) == '' )
      throw new Exception('Invalid object data: name is not specified');

    if( !isset($this->_data['type']) )
      throw new Exception('Invalid object data: type is not specified');
    
    if( !in_array($this->_data['type'],self::$_types) )
      throw new Exception('Invalid object data: type of '.$this->_data['type'].' is invalid');

    $db = cmsms()->GetDb();
    if( isset($this->_data['id']) ) {
      $query = 'SELECT id FROM '.CGSOCIAL_TABLE_LEADERBOARD.' WHERE name = ? AND id != ?';
      $tmp = $db->GetOne($query,array($this->_data['name'],$this->_data['id']));
      if( $tmp )
	throw new Exception('Invalid object data: name is already in use');
    }
    else {
      $query = 'SELECT id FROM '.CGSOCIAL_TABLE_LEADERBOARD.' WHERE name = ?';
      $tmp = $db->GetOne($query,array($this->_data['name']));
      if( $tmp )
	throw new Exception('Invalid object data: name is already in use');
    }
  }

  protected function insert()
  {
    if( !$this->_dirty ) return;
    $db = cmsms()->GetDb();
    $now = time();
    $query = 'INSERT INTO '.CGSOCIAL_TABLE_LEADERBOARD."
              (name,type,description,image,data,created,modified) VALUES (?,?,?,?,?,?,?)";

    $data = $this->_data;
    unset($data['id']);
    $dbr = $db->Execute($query,
			array($this->name,$this->type,$this->description,$this->image,
			      serialize($data),$now,$now));
    if( !$dbr ) {
      throw new Exception('Database Error: '.$db->sql.' -- '.$db->ErrorMsg());
    }
    $this->_data['id'] = $db->Insert_ID();
    $this->_dirty = false;
  }

  protected function update()
  {
    if( !$this->_dirty ) return;
    $db = cmsms()->GetDb();
    $now = time();
    $query = 'UPDATE '.CGSOCIAL_TABLE_LEADERBOARD.'
              SET name = ?, type = ?, description = ?, image = ?, data = ?, modified = ?
              WHERE id = ?';

    $data = $this->_data;
    unset($data['id']);

    $dbr = $db->Execute($query,
			array($this->name,$this->type,$this->description,$this->image,
			      serialize($data),$now,$this->id));
    if( !$dbr ) {
      throw new Exception('Database Error: '.$db->sql.' -- '.$db->ErrorMsg());
    }
    $this->_dirty = false;
  }

  public static function &load_from_data($data)
  {
    if( !isset($data['id']) || !isset($data['name']) ) {
      throw new Exception('Invalid data in array ... missing data');
    }

    foreach( $data as $key => $value ) {
      if( !self::_valid_key($key) && $key != 'data' ) {
	throw new Exception('Invalid data key '.$key.' in array ... cannot load');
      }
    }

    $obj = new cgsa_leaderboard;
    if( isset($data['data']) ) {
      $obj->_data = unserialize($data['data']);
      $obj->_data['id'] = $data['id'];
    }
    else {
      $obj->_data = $data;
    }
    
    return $obj;
  }

  public static function delete_by_id($id)
  {
    if( (int)$id <= 0 )
      throw new Exception('Invalid id specified');

    $dir = cgsa_utils::get_leaderboard_filepath();
    $leaderboard = self::load_by_id($id);
    cgsa_utils::delete_image($dir,$leaderboard->image);

    $db = cmsms()->GetDb();
    $query = 'SELECT id FROM '.CGSOCIAL_TABLE_BADGES.' WHERE leaderboard_id = ?';
    $badges = $db->GetCol($query,array($id));
    if( is_array($badges) && count($badges) ) {
      foreach( $badges as $one ) {
	$dir = cgsa_utils::get_badge_filepath_by_badge_id($one);
	if( $dir && is_dir($dir) ) {
	  recursive_delete($dir);
	}
      }
    }

    $query = 'DELETE FROM '.CGSOCIAL_TABLE_BADGES_USERS.' WHERE leaderboard_id = ?';
    $dbr = $db->Execute($query,array($id));
    $query = 'DELETE FROM '.CGSOCIAL_TABLE_BADGES.' WHERE leaderboard_id = ?';
    $dbr = $db->Execute($query,array($id));
    $query = 'DELETE FROM '.CGSOCIAL_TABLE_LEADERBOARD_MEMBERS.' WHERE board_id = ?';
    $dbr = $db->Execute($query,array($id));
    $query = 'DELETE FROM '.CGSOCIAL_TABLE_LEADERBOARD.' WHERE id = ?';
    $dbr = $db->Execute($query,array($id));
  }

  public static function &load_by_id($id,$as_obj = TRUE)
  {
    if( (int)$id <= 0 )
      throw new Exception('Invalid id specified');

    $db = cmsms()->GetDb();
    $query = 'SELECT * FROM '.CGSOCIAL_TABLE_LEADERBOARD.' WHERE id = ?';
    $one = $db->GetRow($query,array($id));

    if( isset($one['data']) || is_null($one['data']) ) {
      if( $one['data'] != '' ) $one['data'] = unserialize($one['data']);
      if( is_array($one['data']) ) {
	foreach( $one['data'] as $k => $v ) {
	  if( in_array($k,self::$_fields) ) {
	    $one[$k] = $v;
	  }
	}
      }
      unset($one['data']);
    }

    if( $as_obj ) {
      return self::load_from_data($one);
    }
    return $one;
  }

  public static function get_all($as_obj = TRUE)
  {
    if( !is_array(self::$_cached) ) {
      self::$_cached = array();
      $db = cmsms()->GetDb();
      $query = 'SELECT * FROM '.CGSOCIAL_TABLE_LEADERBOARD.' ORDER BY id DESC';
      $tmp = $db->GetArray($query);
      
      if( is_array($tmp) && count($tmp) ) {
	foreach( $tmp as $one ) {
	  if( isset($one['data']) || is_null($one['data']) ) {
	    if( $one['data'] != '' ) $one['data'] = unserialize($one['data']);
	    if( is_array($one['data']) ) {
	      foreach( $one['data'] as $k => $v ) {
		if( in_array($k,self::$_fields) ) {
		  $one[$k] = $v;
		}
	      }
	    }
	    unset($one['data']);
	    self::$_cached[] = $one;
	  }
	}
      }
    }

    $res = array();
    foreach( self::$_cached as $one ) {
      if( $as_obj ) {
	$res[] = self::load_from_data($one);
      }
      else {
	$res[] = $one;
      }
    }
    return $res;
  }

  public function matches(cgsa_checkin $checkin)
  {
    switch( $this->type ) {
    case 'friends':
      return FALSE;

    case 'checkins':
      return TRUE;
      
    case 'location':
      switch( $this->match_location ) {
      case 'locationid':
	if( $checkin->location == $this->criteria_locationid ) {
	  return TRUE;
	}
	break;

      case 'category':
	$categories = $this->criteria_locationcategory;
	// test if the checkin location is in one of these categories.
	$cdmod = cms_utils::get_module('CompanyDirectory'); // make sure it's loaded.
	$company = cd_utils::get_company($checkin->location,'',TRUE,FALSE);
	if( is_object($company) ) {
	  $comp_categories = $company->list_categories(FALSE);
	  if( is_array($comp_categories) && count($comp_categories) ) {
	    $intersect = array_intersect($categories,$comp_categories);
	    if( is_array($intersect) && count($intersect) ) {
	      return TRUE;
	    }
	  }
	}
	return FALSE;

      case 'hier':
	$hier = $this->criteria_locationhier;
	$hierchildren = $this->criteria_locationhierchildren;
	$cdmod = cms_utils::get_module('CompanyDirectory'); // make sure it's loaded.
	$company = cd_utils::get_company($checkin->location,'',TRUE,FALSE);
	if( is_object($company) ) {
	  if( $hier == $company->hier_id ) return TRUE;
	  if( $hierchildren ) {
	    if( cd_utils::hierarchy_match_parent($company->hier_id,$hier) ) {
	      return TRUE;
	    }
	  }
	}
      }
      return FALSE;

    case 'activity':
      return FALSE;
    }
    
    return FALSE;
  }

  public static function find_matching(cgsa_checkin $checkin)
  {
    $all = self::get_all();
    if( !is_array($all) || count($all) == 0 ) {
      return;
    }

    $res = array();
    foreach( $all as $one ) {
      if( $one->matches($checkin) ) {
	$res[] = $one;
      }
    }
    return $res;
  }

  //
  // members stuff
  //
  public function add_member($uid,$score,$notes = '')
  {
    if( !isset($this->_data['id']) || $this->_data['id'] <= 0 )
      throw new Exception('Cannot add a member to an unsaved leaderboard');

    $uid = (int)$uid;
    $score = (int)$score;
    if( $uid < 0 || $score < 0 )
      throw new Exception('Cannot add membership.  Invalid uid and/or score');

    // members can only be in the table once.
    $db = cmsms()->GetDb();
    $query = 'INSERT INTO '.CGSOCIAL_TABLE_LEADERBOARD_MEMBERS.'
              (board_id,uid,score,notes) VALUES (?,?,?,?)
              ON DUPLICATE KEY UPDATE score = ?';
    $db->Execute($query,array($this->_data['id'],$uid,$score,$notes,$score));
  }

  public function adjust_score($uid,$delta = 1)
  {
    if( !isset($this->_data['id']) || $this->_data['id'] <= 0 )
      throw new Exception('Cannot add a member to an unsaved leaderboard');

    $uid = (int)$uid;
    $delta = (int)$delta;
    if( $uid < 0 )
      throw new Exception('Cannot add membership.  Invalid uid and/or score');

    if( $delta == 0 ) return;

    $db = cmsms()->GetDb();
    $query = 'SELECT * FROM '.CGSOCIAL_TABLE_LEADERBOARD_MEMBERS.' WHERE board_id = ? AND uid = ?';
    $row = $db->GetRow($query,array($this->_data['id'],$uid));
    if( !is_array($row) || count($row) == 0 ) {
      return $this->add_member($uid,$delta);
    }

    $query = 'UPDATE '.CGSOCIAL_TABLE_LEADERBOARD_MEMBERS.' SET score = score + ? 
              WHERE board_id = ? AND uid = ?';
    $db->Execute($query,array($delta,$this->_data['id'],$uid));
  }

  public function remove_member($uid)
  {
    if( !isset($this->_data['id']) || $this->_data['id'] <= 0 )
      throw new Exception('Cannot remove a member to an unsaved leaderboard');

    $uid = (int)$uid;
    if( $uid < 0 )
      throw new Exception('Cannot remove membership.  Invalid uid');

    $db = cmsms()->GetDb();
    $query = 'DELETE FROM '.CGSOCIAL_TABLE_LEADERBOARD_MEMBERS.'
              WHERE board_id = ?, AND uid = ?';
    $db->Execute($query,array($this->_data['id'],$uid));
  }

  public function get_member_rank($uid)
  {
    if( !isset($this->_data['id']) || $this->_data['id'] <= 0 )
      throw new Exception('Cannot get member rank from an unsaved leaderboard');

    $uid = (int)$uid;
    if( $uid < 0 )
      throw new Exception('Cannot remove membership.  Invalid uid');

    $query = 'SET @rank = 0; 
              SELECT @rank:=@rank+1 AS rank
              FROM '.CGSOCIAL_TABLE_LEADERBOARD_MEMBERS.'
              ORDER BY score DESC 
              WHERE board_id = ? AND uid = ?';
    $tmp = $db->GetOne($query,array($this->_data['id'],$uid));
    return $tmp;
  }

  public function get_member_info($uid)
  {
    if( !isset($this->_data['id']) || $this->_data['id'] <= 0 )
      throw new Exception('Cannot remove a member to an unsaved leaderboard');

    $uid = (int)$uid;
    if( $uid < 0 )
      throw new Exception('Cannot retrieve membership.  Invalid uid');

    $db = cmsms()->GetDb();
    $query = 'SELECT * FROM '.CGSOCIAL_TABLE_LEADERBOARD_MEMBERS.'
              WHERE board_id = ? AND uid = ?';
    $row = $db->GetRow($query,array($this->_data['id'],$uid));
    return $row;
  }

  public function count_members()
  {
    if( !isset($this->_data['id']) || $this->_data['id'] <= 0 )
      throw new Exception('Cannot remove a member to an unsaved leaderboard');

    $db = cmsms()->GetDb();
    $query = 'SELECT COUNT(uid) FROM '.CGSOCIAL_TABLE_LEADERBOARD_MEMBERS.'
              WHERE board_id = ?';
    $tmp = $db->GetOne($query,array($this->_data['id']));
    return $tmp;
  }

  public function count_members_by_score($min_score,$max_score = null)
  {
    if( !isset($this->_data['id']) || $this->_data['id'] <= 0 )
      throw new Exception('Cannot remove a member to an unsaved leaderboard');

    $db = cmsms()->GetDb();
    $min_score = (int)$min_score;
    if( $min_score < 0 )
      throw new Exception('Invalid value for min score');
    
    $query = 'SELECT COUNT(uid) 
              FROM '.CGSOCIAL_TABLE_LEADERBOARD_MEMBERS.' 
              WHERE board_id = ? AND score >= ?';
    $parms = array($this->_data['id']);
    $parms[] = $min_score;
    
    if( $max_score ) {
      $max_score = (int)$max_score;
      if( $max_score < 0 ) 
	throw new Exception('Invalid value for max score');

      if( $max_score > $min_score ) {
	$query .= ' AND score <= ?';
	$parms[] = $max_score;
      }
    }

    $result = $db->GetOne($query,$parms);
    return $result;
  }

  public function remove_members_by_score()
  {
    // @todo
  }

  public function get_member_scores($uidlist)
  {
    // @todo
  }

  public function get_member_rankings($uidlist)
  {
    // @todo
  }

  public function get_leaders($limit,$offset = 0)
  {
    if( !isset($this->_data['id']) || $this->_data['id'] <= 0 )
      throw new Exception('Cannot get member rank from an unsaved leaderboard');

    $limit = (int)$limit;
    $offset = (int)$offset;
    if( $limit < 0 || $offset < 0 )
      throw new Exception('Invalid limit and/or offset');

    $db = cmsms()->GetDb();
    $query = 'SELECT uid
              FROM '.CGSOCIAL_TABLE_LEADERBOARD_MEMBERS.'
              WHERE board_id = ?
              ORDER BY score DESC';
    $tmp = $db->SelectLimit($query,$limit,$offset,array($this->_data['id']));
    $res = array();
    while( $tmp && !$tmp->EOF ) {
      $res[] = $tmp->fields['uid'];
      $tmp->MoveNext();
    }
    return $res;
  }

  public function get_badges($as_obj = TRUE)
  {
    if( !$this->id ) return;
    $db = cmsms()->GetDb();

    $query = 'SELECT * FROM '.CGSOCIAL_TABLE_BADGES.'
              WHERE leaderboard_id = ?';
    $data = $db->GetArray($query,array($this->id));
    if( is_array($data) && count($data) ) {
      $out = array();
      foreach( $data as $one ) {
	if( $as_obj ) {
	  $obj = cgsa_badge::load_from_data($one);
	  if( is_object($obj) ) {
	    $out[] = $obj;
	  }
	}
	else {
	  $out[] = $one;
	}
      }
      return $out;
    }
  }

  public function &get_badge_by_id($badge_id)
  {
    if( !$this->id ) return;
    $db = cmsms()->GetDb();

    $query = 'SELECT * FROM '.CGSOCIAL_TABLE_BADGES.'
              WHERE leaderboard_id = ? AND id = ?';
    $data = $db->GetRow($query,array($this->id,$badge_id));
    if( is_array($data) && count($data) ) {
      $obj = cgsa_badge::load_from_data($data);
      if( is_object($obj) ) return $obj;
    }
  }
} // end of class

#
# EOF
#
?>
