<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: FrontEndUsers (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

final class cgsa_friends
{
  private function __construct() {}
  private static $_manipulator;

  private static function get_manipulator()
  {
    if( is_null(self::$_manipulator) ) {
      $mod = cms_utils::get_module('CGSocialApp');
      $manipname = $mod->GetPreference('friends_manipulator','cgsa_simple_friend_manipulator');
      self::$_manipulator = new $manipname;
    }
    return self::$_manipulator;
  }


  /**
   * Retrieve a list of the users friends
   *
   * @param string The user identifier
   * @param integer The limit to the number of friends (not implemented)
   * @param integer The offset (not implemented)
   * @return array of uids or null
   */
  public static function get_friends($uid,$limit = 100000,$offset = 0)
  {
    return self::get_manipulator()->get_friends($uid,$limit,$offset);
  }


  /**
   * Add fuid as a friend to uid
   * This is a database function only.  No events are sent.
   * This function only effects one side of the friend relationship
   *
   * @param string The user id to add to
   * @param string The friends user id.
   * @return null
   */
  private static function add_friend($uid,$fuid)
  {
    return self::get_manipulator()->add_friend($uid,$fuid);
  }


  /**
   * Delete a friend relationship
   * This is a database function only, no events are triggered
   * This method only deletes one side of the friend relationship, not both
   *
   * @param string The userid
   * @param string The friends user id
   * @return null
   */
  private static function del_friend($uid,$fuid)
  {
    return self::get_manipulator()->del_friend($uid,$fuid);
  }


  /**
   * Remove a friendship relationship
   * This is a high level functin that may send events or notifications
   * This method will ensure that the friendship relationship
   * is removed between both pthe fuid and uid.
   *
   * @param string The current uid
   * @param string The friends uid
   * @return null
   */
  public static function remove_friendship($uid,$fuid)
  {
    self::del_friend($uid,$fuid);
    self::del_friend($fuid,$uid);
  }


  /**
   * Get a list of the uids that we have denied from being friends
   *
   * @param string The userid
   * @return array of user ids
   */
  public static function get_notfriends($uid)
  {
    return self::get_manipulator()->get_notfriends($uid);
  }

  
  /**
   * Add a user to our list of notfriends
   * This method only effects one side of the friendship relation, and does not explicitly remove a friend from the friendslist
   * It is possible using this method to have a uid in the friends list and not friends list.  Developers must use caution.
   * This method does the database work only, no events are sent.
   *
   * @param string The user id
   * @param string The friends user id
   * @return null
   */
  private static function add_notfriend($uid,$fuid)
  {
    return self::get_manipulator()->add_notfriend($uid,$fuid);
  }

  
  /**
   * Remove a user from our list of notfriends
   * This method only effects one side of the friendship relation. 
   * This method does the database work only, no events are sent.
   *
   * @param string The user id
   * @param string The friends user id
   * @return null
   */
  private static function del_notfriend($uid,$fuid)
  {
    return self::get_manipulator()->del_notfriend($uid,$fuid);
  }


  /**
   * Suggest possible friends to a user.  This method uses the 
   * manipulators to gather a list of friends of friends that
   * we have not already added to our friends list and that have
   * not explicitly denied us, or we have not explicitily already denied
   *
   * @param string The user id
   * @param integer A limit to the number of friends
   * @return array of user ids
   */
  public static function suggest($uid,$limit = 50)
  {
    $friends = self::get_friends($uid);
    $notfriends = self::get_notfriends($uid);
    
    // todo: it would be neat here if we gathered something from interests...

    $results = array();
    for( $i = 0; $i < count($friends); $i++ ) {
      if( count($results) >= $limit ) break;

      $hisfriends = self::get_friends($friends[$i]);
      if( is_array($hisfriends) && count($hisfriends) ) {
	for( $j = 0; $j < count($hisfriends); $j++ ) {
	  if( is_array($notfriends) && count($notfriends) && !in_array($hisfriends[$i],$notfriends) ) {
	    // we have already declined a request from this guy
	    break;
	  }

	  $hisrequests = self::get_friendrequests($hisfriends[$i]);
	  if( is_array($hisrequests) && count($hisrequests) && in_array($uid,$hisrequests) ) {
	    // we've already sent this user a request... no need to suggest it again.
	    break;
	  }

	  $hisnotfriends = self::get_notfriends($hisfrinds[$i]);
	  if( is_array($hisnotfriends) && count($hisnotfriends) && in_array($uid,$hisnotfriends) ) {
	    // this user has already rejected us... no need to suggest it again.
	    break;
	  }

	  $results[] = $hisfriends[$i];
	  if( count($results) >= $limit ) break;
	}
      }
    }

    if( count($results) ) return $results;
  }


  public static function get_friendrequests($uid,$limit = 1000,$offset = 0)
  {
    return self::get_manipulator()->get_friendrequests($uid,$limit,$offset);
  }


  /**
   * Create a friend request to the user identified by fuid from the user identified by uid
   * This function does the database work only, notifications are not sent.
   * 
   * @param string The potential friends user id
   * @param string The current users uid
   * @return null
   */
  private static function add_friendrequest($fuid,$uid)
  {
    return self::get_manipulator()->add_friendrequest($fuid,$uid);
  }


  /**
   * Delete a friend request to the user identified by fuid from the user identified by uid
   * This function does the database work only, notifications are not sent.
   * 
   * @param string the potential friends user id
   * @param string The current users id
   * @return null
   */
  private static function del_friendrequest($fuid,$uid)
  {
    return self::get_manipulator()->del_friendrequest($fuid,$uid);
  }


  /**
   * Create a new friend request.
   * This method will create a new friend request from uid to fuid
   * This is a high level method that may send events or notifications.
   * This method may also check permissions etc.
   *
   * @param string The friends uid
   * @param string The current uid
   * @return null
   */
  public static function create_friendrequest($fuid,$uid)
  {
    return self::get_manipulator()->add_friendrequest($fuid,$uid);
    // todo: send notifications here... (maybe).
  }


  /**
   * Approve an existing friend request from fuid to uid
   * This method is normally called by the fuid to approve a request made by uid
   * Developers must use caution when using this method as it may allow them to arbitrarily
   * approve friend requests.  Once approved the users are asserted as mutual friends
   * This is a high level method that may send events or notifications.
   *
   * @param string The current users uid 
   * @param string The friend users uid.
   * @return null
   */
  public static function approve_friendrequest($uid,$fuid)
  {
    if( !$uid || !$fuid ) return;
    $requests = self::get_friendrequests($uid);
    if( !is_array($requests) || count($requests) == 0 ) return;

    if( in_array($fuid,$requests) ) {
      self::del_friendrequest($fuid,$uid);

      // add them to each others 'friends' list.
      self::add_friend($uid,$fuid);
      self::add_friend($fuid,$uid);

      // todo: send some sort of notification to uid
    }
  }


  /** 
   * Deny an existing friend request from fuid to uid
   * This method is a high level method that may send notifications or events
   * Once confirmed the denied user (fuid) is added to the current users notfriends list.
   *
   * @param string The current users uid
   * @param string The friends uid
   * @return null
   */
  public static function deny_friendrequest($uid,$fuid)
  {
    if( !$uid || !$fuid ) return;
    $requests = self::get_friendrequests($uid); // get my friend requests.
    if( !is_array($requests) || count($requests) == 0 ) return;

    if( in_array($fuid,$requests) ) {
      self::del_friendrequest($fuid,$uid);

      // and add fuid to the notfriends list.
      self::add_notfriend($uid,$fuid);

      // todo: maybe add notifications here.
    }
  }


  public static function delete_all($uid)
  {
    if( !$uid ) return;
    return self::get_manipulator()->delete_all($uid);
  }
} // end of class

#
# EOF
#
?>
