<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: FrontEndUsers (c) 2012 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

final class cgsa_checkin_resultset
{
  private $_query;
  private $_executed;
  private $_rs;
  private $_found_rows;


  public function __construct(cgsa_checkin_query $query)
  {
    $this->_query = $query;
    $this->_execute();
  }


  private function _execute()
  {
    $query = $this->_query;
    $db = cmsms()->GetDb();

    $sql = 'SELECT SQL_CALC_FOUND_ROWS ci.* FROM '.CGSOCIAL_TABLE_CHECKINS.' ci';
    $where = array();
    $qparms = array();

    // build the query
    if( $query['location'] > 0 ) {
      $where[] = 'ci.location = ?';
      $qparms[] = $query['location'];
    }

    if( $query['activity'] > 0 ) {
      $where[] = 'ci.activity = ?';
      $qparms[] = $query['activity'];
    }

    if( $query['timelimit'] > 0 ) {
      $where[] = 'ci.created > ?';
      $qparms[] = $query['timelimit'];
    }

    if( $query['approved'] ) {
      $where[] = 'ci.approved = ?';
      $qparms[] = $query['approved'];
    }

    if( $query['owner'] != '' ) {
      $where[] = 'ci.owner = ?';
      $qparms[] = $query['owner'];
    }
    elseif( is_array($query['owners']) && count($query['owners']) ) {
      $tmp = array();
      for( $i = 0; $i < count($query['owners']); $i++ ) {
	$tmp[] = $db->qstr($query['owners'][$i]);
      }
      $where[] = 'ci.owner IN ('.implode(',',$tmp).')';
    }

    if( count($where) ) {
      $sql .= ' WHERE '.implode(' AND ',$where);
    }

    $sql .= ' ORDER BY '.$query['sortby'].' '.$query['sortorder'];
    $this->_rs = $db->SelectLimit($sql,$query['limit'],$query['offset'],$qparms);
    if( !$this->_rs ) {
      throw new Exception('INTERNAL ERROR: Query failed - '.$db->sql.' -- '.$db->ErrorMsg());
    }

    $this->_found_rows = $db->GetOne('SELECT FOUND_ROWS()');
    $this->_executed = TRUE;
  }

  public function RecordCount()
  {
    if( $this->_rs ) return $this->_rs->RecordCount();
    return 0;
  }

  public function MoveFirst()
  {
    if( $this->_rs ) return $this->_rs->MoveFirst();
    return FALSE;
  }

  public function MoveNext()
  {
    if( $this->_rs ) return $this->_rs->MoveNext();
    return FALSE;
  }

  public function EOF()
  {
    if( $this->_rs ) return $this->_rs->EOF();
    return TRUE;
  }

  public function Close()
  {
    if( $this->_rs ) return $this->_rs->Close();
    return TRUE;
  }

  public function __get($key)
  {
    if( $key == 'EOF' && $this->_rs ) {
      return $this->_rs->EOF;
    }
    if( $key == 'fields' && $this->_rs ) {
      $obj = new cgsa_checkin($this->_rs->fields);
      return $obj;
    }
  }

  public function &get_checkin()
  {
    if( !$this->_rs ) return;

    $obj = new cgsa_checkin($this->_rs->fields);
    return $obj;
  }

  public function &get_pagination()
  {
    $res = null;
    if( !$this->_rs ) return $res;
    $ob = new cgsa_checkin_pagination($this->_query,$this);
    return $ob;
  }

  public function get_found_rows()
  {
    if( !$this->_rs ) return;
    return $this->_found_rows;
  }
} // end of class

#
# EOF
#
?>