<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: FrontEndUsers (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

function serialize_notempty($data)
{
  $res = null;
  if( (is_array($data) && count($data)) || (is_string($data) && $data != '') ) {
    $res = serialize($data);
  }
  return $res;
}

class cgsa_checkin
{
  private static $_keys = array('id','obid','owner','parent_id','location','activity','msg','lat','lng','created','approved','data','processed');
  private $_data = array();

  public function __construct($params = '')
  {
    if( !is_array($params) ) return;
    $this->_build_from_array($params);
  }

  public function __get($key)
  {
    if( $key == 'obid' ) {
      if( !isset($this->_data['obid']) || $this->_data['obid'] == '' ) {
	$this->_data['obid'] = str_replace('.','_',uniqid('c',true));
      }
    }

    switch( $key ) {
    case 'id':
    case 'obid':
    case 'owner':
    case 'parent_id':
    case 'location':
    case 'activity':
    case 'msg':
    case 'lat':
    case 'lng':
    case 'created':
    case 'approved':
    case 'processed':
      if( isset($this->_data[$key]) ) {
	return $this->_data[$key];
      }
      break;

    default:
      if( startswith($key,'extra_') ) {
	if( is_array($this->_data['data']) && is_array($this->_data['data'][$key]) ) {
	  return $this->_data['data'][$key];
	}
      }
      else {
	throw new CmsException('Attempt to retrieve invalid field '.$key.' from cgsa_checkin object');
      }
      break;
    }
  }

  public function __set($key,$value)
  {
    if( $key == 'id' ) {
      throw new Exception('Attempt to set id into cgsa_activity object');
    }
    if( $key == 'obid' ) {
      throw new Exception('Attempt to set obid into cgsa_activity object');
    }

    switch( $key ) {
    case 'id':
    case 'obid':
    case 'owner':
    case 'parent_id':
    case 'location':
    case 'activity':
    case 'msg':
    case 'lat':
    case 'lng':
    case 'created':
    case 'approved':
    case 'processed':
      if( isset($this->_data[$key]) ) {
	return $this->_data[$key];
      }
      break;

    default:
      if( startswith($key,'extra_') ) {
	if( !is_array($this->_data['data']) ) $this->_data['data'] = array();
	$this->_data['data'][$key] = $value;
	return;
      }
      throw new CmsException('Attempt to set invalid field '.$key.' into cgsa_checkin object');
    }
    $this->_data[$key] = $value;
  }

  public function __isset($key)
  {
    if( !in_array($key,self::$_keys) ) {
      throw new Exception('Attempt to retrieve invalid key '.$key.' from cgsa_checkin object');
    }

    switch( $key ) {
    case 'id':
    case 'obid':
    case 'owner':
    case 'parent_id':
    case 'location':
    case 'activity':
    case 'msg':
    case 'lat':
    case 'lng':
    case 'created':
    case 'approved':
    case 'processed':
      if( isset($this->_data[$key]) ) return TRUE;
      break;

    default:
      if( is_array($this->_data['data']) && is_array($this->_data['data'][$key]) ) {
	return TRuE;
      }
    }
    return FALSE;
  }

  public function validate($deep = false)
  {
    if( $this->owner == '' || $this->msg == '' || $this->location == '' )
      throw new Exception('cgsa_checkin object does not validate');

    if( $deep ) {
      throw new Exception('cgsa_checkin object does not validate (deep validation failed');
    }
  }

  public function tag_user($mixed_in)
  {
    if( !isset($this->_data['usertags']) ) {
      $this->_data['usertags'] = array();
    }

    $mixed = array();
    if( !is_array($mixed_in) ) {
      $tmp = explode(',',$mixed_in);
      if( is_array($tmp) && count($tmp) ) {
	foreach( $tmp as $t ) {
	  $t = (int)trim($t);
	  if( $t >= 0 ) {
	    $mixed[] = $t;
	  }
	}
      }
    }
    else {
      $mixed = $mixed_in;
    }
    
    $n = 0;
    foreach( $mixed as $oneuser ) {
      // valid user?
      $oneuser = (int)$oneuser;
      if( $oneuser <= 0 ) continue;
      if( !in_array($oneuser,$this->_data['usertags']) ) {
	$this->_data['usertags'][] = $oneuser;
	$n++;
      }
    }
    return $n;
  }

  public function get_tagged_users()
  {
    if( isset($this->_data['usertags']) ) {
      return $this->_data['usertags'];
    }
  }

  public function save()
  {
    $this->validate();

    if( !isset($this->_data['id']) || $this->_data['id'] < 1 ) {
      return $this->_insert();
    }
    return $this->_update();
  }

  public function delete()
  {
    if( !$this->id ) return;

    // can only delete if item does not have children.
    $db = cmsms()->GetDb();
    $query = 'SELECT id FROM '.CGSOCIAL_TABLE_CHECKINS.' WHERE parent_id = ?';
    $tmp = $db->GetOne($query,array($this->id));
    if( $tmp ) return FALSE;

    // send an event
    $mod = cms_utils::get_module('CGSocialApp');
    $mod->SendEvent('PreDeleteCheckin',array('checkin'=>$this));

    // delete any files
    if( is_array($this->data) && is_array($this->data['files']) && count($this->data['files']) ) {
      $config = cmsms()->GetConfig();
      $mod = cms_utils::get_module('CGSocialApp');
      foreach( $this->data['files'] as $file ) {
	$files = glob(cms_join_path($config['uploads_path'],'_'.$mod->GetName(),'*'.$file));
	if( is_array($files) && count($files) ) {
	  foreach($files as $one) {
	    @unlink($one);
	  }
	}
      }
    }

    // delete the item.
    $query = 'DELETE FROM '.CGSOCIAL_TABLE_CHECKINS.' WHERE id = ?';
    $db->Execute($query,array($this->id));

    // log it
    cgsa_log::add('checkins','Checkin deleted ',null,$this->id);

    // send an event
    $mod = cms_utils::get_module('CGSocialApp');
    $mod->SendEvent('PostDeleteCheckin',array('checkin_id'=>$this->id));

    // and done.
    unset($this->_data['id']);
    return TRUE;
  }

  private function _insert()
  {
    $db = cmsms()->GetDb();

    $now = time();
    $query = 'INSERT INTO '.CGSOCIAL_TABLE_CHECKINS." (parent_id, obid, owner, location, activity, msg, created, approved, processed, data)
      VALUES (?,?,?,?,?,?,$now,?,?,?)";
    $dbr = $db->Execute($query,array($this->parent_id,$this->obid,$this->owner,$this->location,$this->activity,$this->msg,$this->approved,
				     $this->processed,serialize_notempty($this->_data['data'])));
    if( !$dbr ) {
      throw new Exception('Insert of checkin failed '.$db->sql.' -- '.$db->ErrorMsg());
    }
    debug_to_log($db->sql);
    $this->_data['id'] = $db->Insert_ID();

    //  log it
    cgsa_log::add('checkins','Checkin added',$this->owner,$this->_data['id']);

    // send an event
    $mod = cms_utils::get_module('CGSocialApp');
    $mod->SendEvent('OnCheckin',array('checkin',$this));

    return TRUE;
  }

  private function _update()
  {
    $db = cmsms()->GetDb();
    
    $query = 'UPDATE '.CGSOCIAL_TABLE_CHECKINS.'
              SET parent_id = ?, owner = ?, location = ?, activity = ?, msg = ?, data = ?, approved = ?, processed = ?
              WHERE id = ?';
    $dbr = $db->Execute($query,
			array($this->parent_id,$this->owner,$this->location,$this->activity,
			      $this->msg,serialize_notempty($this->_data['data']),
			      $this->approved,$this->processed,$this->id));
    if( !$dbr ) {
      throw new Exception('Update of checkin failed ');
    }

    // todo: log it
    cgsa_log::add('checkins','Checkin modified',$this->owner,$this->id);

    // todo: send event
    $mod = cms_utils::get_module('CGSocialApp');
    $mod->SendEvent('OnUpdateCheckin',array('checkin',$this));

    return TRUE;
  }


  // load a single message
  public static function &load_by_id($id,$as_array = FALSE)
  {
    $db = cmsms()->GetDb();

    $query = 'SELECT * FROM '.CGSOCIAL_TABLE_CHECKINS.' WHERE id = ?';
    $row = $db->GetRow($query,array((int)$id));
    if( !is_array($row) ) {
      return;
    }

    debug_to_log($row,'row');
    if( isset($row['data']) && $row['data'] != '' ) {
      debug_to_log($row,'rowdata');
      $row['data'] = unserialize($row['data']);
    }
    if( $as_array ) return $row;
    $obj = self::load_from_array($row);
    return $obj;
  }


  private function _build_from_array($data)
  {
    foreach( $data as $key => $value ) {
      if( $key == 'data' && !is_array($value) && $value != '' ) $value = unserialize($value);
      $this->_data[$key] = $value;
    }
  }

  public static function &load_from_array($data)
  {
    $obj = new cgsa_checkin;
    $obj->_build_from_array($data);
    return $obj;
  }

  public static function to_array($obj)
  {
    if( is_array($obj) ) return $obj;

    $data = array();
    foreach( self::$_keys as $key ) {
      if( $key == 'data' ) {
	$data[$key] = $obj->_data['data'];
      }
      else {
	$data[$key] = $obj->$key;
      }
    }
    return $data;
  }

  // load a thread
  public static function load_by_user($uid,$limit = 50,$offset = 0)
  {
    // uid can be a single user... or an array of uids
    if( !is_array($uid) && is_numeric($uid) ) {
      $uid = array((int)$uid);
    }

    for( $i = 0; $i < count($uid); $i++ ) {
      $uid[$i] = (int)$uid[$i];
    }
    $uid = array_unique($uid);

    $db = cmsms()->GetDb();
    $query = 'SELECT * FROM '.CGSOCIAL_TABLE_CHECKINS.'
              WHERE owner IN ('.implode(',',$uid).')
              ORDER BY created DESC';
    $dbr = $db->SelectLimit($query,$limit,$offset);
    if( !$dbr ) {
      // todo: throw an exception
      return;
    }
    
    $res = array();
    while( !$dbr->EOF ) {
      $res[] = self::load_from_array($dbr->fields);
      $dbr->MoveNext();
    }
    $dbr->Close();

    if( count($res) == 1 ) return $res[0];
    return $res;
  }

} // end of class

#
# EOF
#
?>
