<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: FrontEndUsers (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

final class cgsa_badge 
{
  private static $_fields = array('id','leaderboard_id','name','description','image','notes','min_score','max_score','is_unique','created','notify_to','notify_priority','notify_subject','notify_tpl');
  private static $_rokeys = array('id','leaderboard_id','created');
  private static $_cache;

  private $_data = array();
  private $_dirty;

  public function __construct()
  {
  }

  public function __get($k)
  {
    if( !in_array($k,self::$_fields) ) {
      throw new Exception($k.' get: is not a valid field for a cgsa_badge');
    }

    switch( $k ) {
    case 'notify_priority':
    case 'notify_subject':
    case 'notify_tpl':
      if( isset($this->_data['extra'][$k]) )
	return $this->_data['extra'][$k];
      break;

    default:
      if( isset($this->_data[$k]) )
	return $this->_data[$k];
    }
  }

  public function __set($k,$v)
  {
    if( !in_array($k,self::$_fields) )
      throw new Exception($k.' set: is not a valid field for a cgsa_badge');

    switch( $k ) {
    case 'notify_priority':
      if( !isset($this->_data['extra']) || !is_array($this->_data['extra']) ) 
	$this->_data['extra'] = array();
      $this->_data['extra'][$k] = (int)$v;
      break;

    case 'notify_subject':
    case 'notify_tpl':
      if( !isset($this->_data['extra']) || !is_array($this->_data['extra']) ) 
	$this->_data['extra'] = array();
      $this->_data['extra'][$k] = trim($v);
      break;

    default:
      $this->_data[$k] = $v;
      $this->_dirty = true;
      break;
    }
  }

  public function validate()
  {
    if( trim($this->name) == '' )
      throw new Exception('Invalid name in badge');
    
    if( $this->min_score <= 0 )
      throw new Exception('Invalid min score');

    if( $this->max_score > 0 && $this->max_score <= $this->min_score )
      throw new Exception('Invalid max score');

    $db = cmsms()->GetDb();
    $tmp = null;
    if( $this->id > 0 ) {
      $query = 'SELECT id FROM '.CGSOCIAL_TABLE_BADGES.' WHERE name = ? AND id != ?';
      $tmp = $db->GetOne($query,array($this->name,$this->id));
    }
    else {
      $query = 'SELECT id FROM '.CGSOCIAL_TABLE_BADGES.' WHERE name = ?';
      $tmp = $db->GetOne($query,array($this->name));
    }
    if( $tmp ) {
      throw new Exception('A badge with this name already exists');
    }
  }

  public function save()
  {
    if( !$this->_dirty ) return;
    $this->validate();
    if( isset($this->_data['id']) && $this->_data['id'] > 0 ) {
      return $this->_update();
    }
    return $this->_insert();
  }

  protected function _insert()
  {
    if( !$this->_dirty ) return;

    $db = cmsms()->GetDb();
    $now = time();
    $query = 'INSERT INTO '.CGSOCIAL_TABLE_BADGES.'
              (leaderboard_id,name,description,image,notes,data,min_score,max_score,is_unique,created)
              VALUES (?,?,?,?,?,?,?,?,?,?)';
    $extra = '';
    if( isset($this->_data['extra']) ) $extra = serialize($this->_data['extra']);
    $dbr = $db->Execute($query,array($this->leaderboard_id,$this->name,$this->description,$this->image,
				     $this->notes,$extra,$this->min_score,$this->max_score,$this->is_unique,$now));
    $this->_data['id'] = $db->Insert_ID();
    $this->_dirty = FALSE;
  }

  public function _update()
  {
    if( !$this->_dirty ) return;
    $db = cmsms()->GetDb();
    $extra = '';
    if( isset($this->_data['extra']) ) $extra = serialize($this->_data['extra']);

    $query = 'UPDATE '.CGSOCIAL_TABLE_BADGES.'
              SET name = ?, description = ?, image = ?, notes = ?, data = ?,
                  min_score = ?, max_score = ?, is_unique = ?
              WHERE id = ?';
    $dbr = $db->Execute($query,
			array($this->name,$this->description,$this->image,$this->notes,
			      $extra, $this->min_score, $this->max_score, $this->is_unique,
			      $this->id));
    $this->_dirty = FALSE;
  }

  public function delete()
  {
    if( !$this->id ) return; // can't delete it.
    $db = cmsms()->GetDb();

    $dir = cgsa_utils::get_badge_filepath_by_badge_id($this->id);
    if( is_dir($dir) && $this->image ) {
      cgsa_utils::delete_image($dir,$this->image);
    }

    $query = 'DELETE FROM '.CGSOCIAL_TABLE_BADGES.' WHERE id = ?';
    $dbr = $db->Execute($query,array($this->id));

    $query = 'DELETE FROM '.CGSOCIAL_TABLE_BADGES_USERS.' WHERE badge_id = ?';
    $dbr = $db->Execute($query,array($this->id));

    unset(self::$_cache[$this->id]);
    unset($this->_data['id']);
  }

  public function count_members()
  {
    $db = cmsms()->GetDb();
    $query = 'SELECT count(uid) FROM '.CGSOCIAL_TABLE_BADGES_USERS.' WHERE badge_id = ?';
    $count = $db->GetOne($query,array($this->id));
    return $count;
  }

  public function is_member($uid)
  {
    $uid = (int)$uid;
    $db = cmsms()->GetDb();
    $query = 'SELECT uid FROM '.CGSOCIAL_TABLE_BADGES_USERS.' WHERE badge_id = ? AND uid = ?';
    $count = $db->GetOne($query,array($this->id,$uid));
    return $count != 0;
  }

  public function add_member($uid)
  {
    $uid = (int)$uid;
    if( $this->is_member($uid) ) return FALSE;

    $db = cmsms()->GetDb();
    $query = 'INSERT INTO '.CGSOCIAL_TABLE_BADGES_USERS.' (badge_id,leaderboard_id,uid,created)
              VALUES (?,?,?,?)';
    $dbr = $db->Execute($query,array($this->id,$this->leaderboard_id,$uid,time()));
    if( $dbr ) return TRUE;
    return FALSE;
  }

  public function list_members($limit = 25,$offset = 0)
  {
    $db = cmsms()->GetDb();
    $query = 'SELECT uid FROM '.CGSOCIAL_TABLE_BADGES_USERS.' 
              WHERE leaderboard_id = ? 
              AND badge_id = ?
              ORDER BY created DESC';
    $rs = $db->SelectLimit($query,$limit,$offset,
			   array($this->leaderboard_id,$this->id));
    $res = array();
    while( $rs && !$rs->EOF ) {
      $res[] = $rs->fields['uid'];
    }
    return $res;
  }

  public function remove_member($uid)
  {
    $uid = (int)$uid;
    if( !$this->is_member($uid) ) return FALSE;

    $db = cmsms()->GetDb();
    $query = 'DELETE FROM '.CGSOCIAL_TABLE_BADGES_USERS.' 
              WHERE badge_id = ? AND leaderboard_id = ? AND uid = ?';
    $dbr = $db->Execute($query,array($this->id,$this->leaderboard_id,$uid));
    if( $dbr ) return TRUE;
    return FALSE;
  }

  public static function &load_from_data($data,$dirty = FALSE)
  {
    if( !isset($data['id']) || !isset($data['leaderboard_id']) || !isset($data['name']) ) {
      throw new Exception('Invalid data in array ... missing data');
    }

    foreach( $data as $key => $value ) {
      if( !in_array($key,self::$_fields) && $key != 'data' ) {
	throw new Exception('invalid data key: '.$key.' in array .... cannot load');
      }
    }

    $obj = new cgsa_badge;
    if( isset($data['data']) ) {
      $data['extra'] = unserialize($data['data']);
      unset($data['data']);
    }
    $obj->_data = $data;
    $obj->_dirty = $dirty;
    return $obj;
  }

  private static function _get_all()
  {
    if( !is_array(self::$_cache) ) {
      self::$_cache = array();

      $db = cmsms()->GetDb();
      $query = 'SELECT * FROM '.CGSOCIAL_TABLE_BADGES;
      $tmp = $db->GetArray($query);
      if( is_array($tmp) && count($tmp) ) {
	self::$_cache = cge_array::to_hash($tmp,'id');
      }
    }

    return self::$_cache;
  }

  public static function &load_by_id($id,$as_obj = TrUE)
  {
    $id = (int)$id;
    if( (int)$id <= 0 )
      throw new Exception('Invalid id specified');

    self::_get_all();
    if( isset(self::$_cache[$id]) ) {
      if( $as_obj ) {
	return self::load_from_data(self::$_cache[$id]);
      }
      return self::$_cache[$id];
    }
  }

  public static function get_all($as_obj = TRUE)
  {
    self::_get_all();

    if( !$as_obj ) {
      return self::$_cache;
    }
    
    $res = array();
    foreach( self::$_cache as $one ) {
      $res[] = self::load_from_data($one);
    }
    return $res;
  }


} // end of class

#
# EOF
#
?>