<h3>What Does This Do?</h3>
<p>This module is a social application framework built on top of CMSMS.  It is designed to allow mobile developers to build small to medium scale specialized social applications and websites.  it can be used for allowing mobile users to add or edit location information, manage friendships, and create time related information related to a location.</p>
<p>This module provides a RESTFUL API to allow sending and receiving social data, and for displaying some of that data on the CMSMS powered website.</p>
<p>This module does not have much functionality of its own, it is designed to primarly work in conjunction with a custom developed mobile application (which you are free to create).</p>
<h3>Features:</h3>
<ul>
 <li>One Install - Many APPS
   <ul>
     <li>Unique API Keys, with expiry</li>
     <li>Advanced Security.</li>
     <li>Atomic permissions model.</li>
   </ul>
 </li>
 <li>Users API
   <p>The Users API allows querying, registering, logging in, logging out, and modifying of a user account.  It uses the FrontEndUsers module for authentication.  This is the primary mechanism for authenticating to the system (other than the API key).  Only authenticated users can create locations, add checkings, edit friend relationships etc.</p>
   <ul>
     <li>Register a new user <em>(REGISTER)</em></li>
     <li>Login an existing user <em>(LOGIN)</em></li>
     <li>PING the server (keep login session alive) <em>(PING)</em></li>
     <li>Logout from the system <em>(LOGOUT)</em></li>
     <li>Retrieve user information (current user) <em>(GETINFO)</em></li>
     <li>Retrieve user additional properties (current user) <em>(PROPERTIES)</em></li>
     <li>Set user information or properties (current user) <em>(SETPROPS)</em></li>
     <li>Retrieve user history (current user) <em>(HISTORY)</em></li>
     <li>List Users (with basic filtering) <em>(LIST)</em></li>
     <li><span style="color: red;">TODO:</span> Delete current user <em>(DELETE)</em></li>
   </ul>
 </li>
 <li>Locations API
     <p>The locations mechanism uses the CompanyDirectory module to manage and store data.  Locations added via the RESTFUL api can be listed using the normal mechanisms in CompanyDirectory. Some of the basic features are:</p>
  <ul>
     <li>Feature: Rate Limiting</li>
     <li>Feature: Photo Uploads</li>
     <li>Feature: Optional Approval</li>
     <li>Retrieve hierarchy list <em>(HIERARCHY API Function)</em></li>
     <li>Retrieve category list <em>(CATEGORIES API Function)</em></li>
     <li>List locations (with filtering) <em>(LIST API Function)</em></li>
     <li>Get information about a specific location <em>(GET API Function)</em></li>
     <li>Add a location <em>(ADD API Function)</em></li>
     <li>Edit information about a location <em>(EDIT API Function)</em></li>
     <li>Attach a photo to a location <em>(PHOTOUPLOAD API Function)</em></li>
     <li>Remove a photo from a location <em>(PHOTODELETE API Function)</em></li>     
     <li><span style="color: red;">TODO:</span> Delete a location <em>(DELETE)</em></li>
  </ul>
 </li>
 <li>Checkins API
  <p>The Checkins mechanism allows a logged in user to say that they were AT a specific location at a specific time.</p>
  <ul>
     <li>Feature: Activity capabilities.</li>
     <li>Feature: Optional Approval</li>
     <li>Feature: Enhanced security</li>
     <li>Feature: Rate Limiting and Spam protection</li>
     <li>Add a checkin <em>(ADD API Function)</em></li>
     <li>Retrieve a single checkin <em>(GET API Function)</em></li>
     <li>Delete a single checkin <em>(DEL API Function)</em></li>
     <li>Approve a draft checkin <em>(APPROVE API Function)</em></li>
     <li>Edit a single checkin <em>(EDIT API Function)</em></li>
     <li>Find checkins for a certain location (with pagination and time limiting) <em>(BYLOCATION API Function)</em></li>
     <li>Find checkins from friends (with pagination and time limiting) <em>(FRIENDS API Function)</em></li>
     <li><span style="color: red;">TODO:</span> Find checkins by activity.</li>
  </ul>
 </li>
 <li>Friends API
  <p>The friends mechanism adds the social part to the API.  Users can manage a friends list, approve and deny friend requests, and see what their friends are doing with the application.</p>
  <ul>
     <li>List Friends (for the current user) <em>(LIST API Function)</em></li>
     <li>Remove a current friend from the list (for the current user) <em>(DEL API Function)</em></li>
     <li>Suggest Friends (for the current user) <em>(SUGGEST API Function)</em></li>
     <li>View a list of friendship requests (for the current user) <em>(REQUESTLIST API Function)</em></li>
     <li>Send a friend request to another user <em>(REQUEST API Function)</em></li>
     <li>Approve a friend request from another user <em>(APPROVE API Function)</em></li>
     <li>Deny a friend request from another user <em>(DENY API Function)</em></li>
  </ul>
 </li>
 <li>Leaderboard / Badges
   <p>The Leaderboard / Badges functionality allows rewarding users for using your application.</p>
   <ul>
   <li>Create numerous leaderboards based on numerous criterium, including location and activity.</li>
   <li>Scores for each leaderboard are calculated regularly from unprocessed checkins, using the CGJobmgr</li>
   <li>Create numerous badges on any leaderboard.</li>
   <li>Badges can be unique (only one member can posess the badge at any one time), or non unique allowing numerous members.</li>
   <li>Badges are based on score from a leaderboard, and can have a minimum, and optionally a maximum score.</li>
   </ul>
 </li>
 <li>Notifications and Events:
   <p>This module is capabile of sending notifications (using the CGNotifier and other supporting modules) to publish when badges are awarded.</p>
   <p>The module sends events logical places in the code allowing other modules or user defined tags to perform more functionality.</p>
 </li>
 <li>Frontend data display: </em>(todo)</em>
 </li>
</ul>
<h3>How do I use it:</h3>
<p><strong>Note:</strong> This module is for advanced users only.  In order to properly use this module you will probably have to create (or have created) A mobile client that interacts with this modules RESTFUL API. A Sample PHP command line client application is included for testing purposes.</p>
<p>After installation and configuration of this module, the FrontEndUsers module, The CompanyDirectory module, and any other dependants there are a few steps to follow:</p>
<ul>
  <li>Create an API key</li>
  <li>Modify the client.php and insert the API key created above into the appropriate section of the code.</li>
  <li>Create at least one user in FEU</li>
  <li>Create at least one public location in CompanyDirectory, for testing</li>
  <li>Launch the php client application.</li>
</ul>
<h3>Smarty Functions</h3>
<p>TODO</p>
<h3>Requirements</h3>
<ul>
  <li>FEU - Login more than once must be enabled.</li>
  <li>Pretty URLS (mod_rewrite or internal) must be configured.</li>
  <li>The mobile client must have cookies capabilities.</li>
  <li>The CGJobMgr module is required for the badge functionalities. We recommend that leaderboards be updated more frequently than badges.  But no more than 3 or 4 times per hour.  Ideal intervals are approximately 20 minutes to update leaderboards, and 30 minutes for updating badges.</li>
  <li>The CGFavs module is required for maintaining friend relationships.</li>
  <li>The default (sample) templates take advantage of the {module_action_link} plugin from the CGSimpleSmarty library.</li>
  <li>Numerous fields may be required in the CompanyDirectory and/or FEU modules to allow certain functionality.  i.e: An Album field is required in the CompanyDirectory module to allow the PHOTOUPLOAD action to work.</p>
  <li>The sample PHP client relies on the curl php extensions.</li>
  <li>For Notifications to work the CGNotifier module, and other supporting modules like (CGTweet, and CGSMS) are needed, and must be properly configured.</li>
</ul>
<h3>Copyright and License</h3>
<p>Copyright &copy; 2008, Robert Campbel <a href="mailto:calguy1000@cmsmadesimple.org">&lt;calguy1000@cmsmadesimple.org&gt;</a>. All Rights Are Reserved.</p>
<p>This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.</p>
<p>However, as a special exception to the GPL, this software is distributed
as an addon module to CMS Made Simple.  You may not use this software
in any Non GPL version of CMS Made simple, or in any version of CMS
Made simple that does not indicate clearly and obviously in its admin 
section that the site was built with CMS Made simple.</p>
<p>This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
Or read it <a href="http://www.gnu.org/licenses/licenses.html#GPL">online</a></p>
<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>For the latest version of this module, FAQs, or to file a Bug Report or buy commercial support, please visit calguy\'s
module homepage at <a href="http://calguy1000.com">calguy1000.com</a>.</li>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
<li>The author, calguy1000, can often be found in the <a href="irc://irc.freenode.net/#cms">CMS IRC Channel</a>.</li>
<li>Lastly, you may have some success emailing the author directly.</li>  
</ul>