<?php

function social_process_commands($cmd,$opts)
{
  switch( $cmd )
    {
    case 'LIST':
      return social_list($opts);

    case 'GETKEY':
      return social_getkey($opts);

    case 'SETKEY':
      return social_setkey($opts);
    }
}

function social_list($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
    echo <<<EOT
usage: list
list available social networks
EOT;
  }

  $req = new cms_http_request();
  $req->setTarget(BASE_URL.'/social');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','LIST');

  $res = $req->execute();
  $tmp = json_decode($res,TRUE);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); // woot done.
  return TRUE;
}

function social_getkey($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
    echo <<<EOT
usage: list
getkey network=networkname
EOT;
  }

  $parms = array();
  foreach( $opts as $one ) {
    list($key,$value) = explode('=',$one,2);
    
    switch($key) {
    case 'network':
      $value = trim($value);
      $parms[$key] = $value;
      break;
    }
  }

  if( !isset($parms['network']) ) {
    set_errormsg('social GETKEY: insufficient arguments');
    return FALSE;
  }
  $uid = get_appdata('uid',-1);
  if( $uid <= 0 ) {
    set_errormsg('Not logged in... nothing to do');
    return FALSE;
  }

  $req = new cms_http_request();
  $req->setTarget(BASE_URL.'/social');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','GETKEY');
  $req->addParam('uid',$uid);
  $req->addParam('network',$parms['network']);
  $req->addParam('v',md5(_apikey().$uid.$parms['network']));

  $res = $req->execute();
  $tmp = json_decode($res,TRUE);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); // woot done.
  return TRUE;
}

function social_setkey($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
    echo <<<EOT
usage: list
setkey network=networkname token=token secret=secret
EOT;
  }

  $parms = array();
  foreach( $opts as $one ) {
    list($key,$value) = explode('=',$one,2);
    
    switch($key) {
    case 'network':
    case 'token':
    case 'secret':
      $value = trim($value);
      $parms[$key] = $value;
      break;
    }
  }

  if( !isset($parms['network']) || !isset($parms['secret']) || !isset($parms['token']) ) {
    set_errormsg('social SETKEY: insufficient arguments');
    return FALSE;
  }
  $uid = get_appdata('uid',-1);
  if( $uid <= 0 ) {
    set_errormsg('Not logged in... nothing to do');
    return FALSE;
  }

  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/social');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','SETKEY');
  $req->addParam('uid',$uid);
  $req->addParam('network',$parms['network']);
  $req->addParam('token',$parms['token']);
  $req->addParam('secret',$parms['secret']);
  $x = md5(_apikey().$uid.$parms['network'].$parms['token'].$parms['secret']);
  $req->addParam('v',$x);

  $res = $req->execute();
  $tmp = json_decode($res,TRUE);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); // woot done.
  return TRUE;
}

?>