<?php

function locations_process_commands($cmd,$opts)
{
  switch( $cmd ) {
  case 'HIERARCHY':
    return locations_hierarchy($opts);

  case 'CATEGORIES':
    return locations_categories($opts);

  case 'LIST':
    return locations_list($opts);

  case 'GET':
    return locations_get($opts);

  case 'ADD':
    return locations_add($opts);

  case 'EDIT':
    return locations_edit($opts);

  case 'PHOTOUPLOAD':
    return locations_photoupload($opts);

  case 'PHOTODELETE':
    return locations_photodelete($opts);
  }
}

function locations_list($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: list [opt=value]
options:
  todo\n
EOT;
  return TRUE;
  }

  // parse arguments
  $parms = array();
  foreach( $opts as $arg ) {
    list($key,$val) = explode('=',$arg,2);
    $key = trim($key);
    $val = trim($val);
    
    // parse arguments.
    
    // it parsed okay.
    $parms[$key] = $val;
  }

  // build the request
  $req = new cms_http_request();
  $req->setTarget(BASE_URL.'/locations');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','LIST');
  if( count($parms) ) {
    foreach( $parms as $key => $value ) {
      $req->addParam($key,$value);
    }
  }
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); echo "\n"; // woot done.
  return TRUE;
}


function locations_categories($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
    echo <<<EOT
usage: categories
list all of the possible categories.\n
EOT;
    return TRUE;
  }

  // build the request
  $req = new cms_http_request();
  $req->setTarget(BASE_URL.'/locations');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','CATEGORIES');
  $res = $req->execute();
  
  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); echo "\n";// woot done.
  return TRUE;
}


function locations_hierarchy($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: hierarchy
list all of the possible hierarchies.\n
EOT;
  return TRUE;
  }

  // build the request
  $req = new cms_http_request();
  $req->setTarget(BASE_URL.'/locations');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','HIERARCHY');
  $res = $req->execute();
  
  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); echo "\n"; // woot done.
  return TRUE;
}

function locations_get($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: get location=<location id>
get information for a single location\n
EOT;
  return TRUE;
  }

  // parse arguments
  $parms = array();
  foreach( $opts as $arg ) {
    $key = $val = '';
    if( strpos($arg,'=') !== FALSE ) {
      list($key,$val) = explode('=',$arg,2);
      $key = trim($key);
      $val = trim($val);
    }

    // parse arguments.
    
    // it parsed okay.
    if( $key == '' || $val == '' ) continue;
    $parms[$key] = $val;
  }

  if( !isset($parms['location']) ) {
    set_errormsg('locations_get: Missing location param');
    return FALSE;
  }

  // build the request
  $req = new cms_http_request();
  $req->setTarget(BASE_URL.'/locations');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','GET');
  if( count($parms) ) {
    foreach( $parms as $key => $value ) {
      $req->addParam($key,$value);
    }
  }
  $res = $req->execute();
  
  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); echo "\n"; // woot done.
  return TRUE;
}

function locations_add($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: add
add a new location. [company_name=string] [address=string|latitude=float longitude=float]
the location must be set.
options: 
  company_name=string (required)
  address=string (optional) 
  telephone=string (optional)
  fax=string (optional)
  contact_email=string (optional) email address.
  website=string (optional) website url
  details=string (optional) text
  hier_id=integer (optional)
  F:field_name=mixed (optional) field value.  Field name must be specified,and valid.  More than one can be specified.
  C:category_id=int (optional) category id.  more than one category id can be spefiied.\n
EOT;
  return TRUE;
  }

  // parse arguments
  if( count($opts) < 1 ) {
    set_errormsg('locations_add: insufficient arguments');
    return FALSE;
  }
  $uid = get_appdata('uid',-1);
  if( $uid <= 0 ) {
    set_errormsg('locations_add: Not logged in... nothing to do');
    return FALSE;
  }
  $loc = get_appdata('loc','');
  if( !$loc ) {
    set_errormsg('locations_add: your location is not set');
    return FALSE;
  }

  $parms = array();
  foreach( $opts as $arg ) {
    $key = $arg;
    $val = '';
    if( strstr($arg,'=') !== FALSE ) {
      list($key,$val) = explode('=',$arg,2);
      $key = trim($key);
      $val = trim($val);
    }

    // it parsed okay.
    $parms[$key] = $val;
  }
  
  // build the request
  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/locations');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','ADD');
  $req->addParam('owner',$uid);
  if( count($parms) ) {
    foreach( $parms as $key => $value ) {
      $req->addParam($key,$value);
    }
  }
  $req->addParam('latitude',$loc[0]);
  $req->addParam('longitude',$loc[1]);
  $res = $req->execute();
  
  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); echo "\n"; // woot done.
  return TRUE;
}

function locations_edit($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: edit
Edit an existing location. location=integer [company_name=string] [address=string|latitude=float longitude=float]
the location must be set.
options: 
  location =integer (required)
  company_name=string (optional)
  address=string (optional) 
  telephone=string (optional)
  fax=string (optional)
  contact_email=string (optional) email address.
  website=string (optional) website url
  details=string (optional) text
  hier_id=integer (optional)
  latitude:float (optional)
  longitude:float (optional)
  F:field_name=mixed (optional) field value.  Field name must be specified,and valid.  More than one can be specified.
  C:category_id=int (optional) category id.  more than one category id can be spefiied.\n
EOT;
  return TRUE;
  }

  // parse arguments
  if( count($opts) < 1 ) {
    set_errormsg('locations_edit: insufficient arguments');
    return FALSE;
  }
  $uid = get_appdata('uid',-1);
  if( $uid <= 0 ) {
    set_errormsg('locations_edit: Not logged in... nothing to do');
    return FALSE;
  }
//   $loc = get_appdata('loc','');
//   if( !$loc ) {
//     set_errormsg('locations_add: your location is not set');
//     return FALSE;
//   }

  $parms = array();
  foreach( $opts as $arg ) {
    $key = $arg;
    $val = '';
    if( strstr($arg,'=') !== FALSE ) {
      list($key,$val) = explode('=',$arg,2);
      $key = trim($key);
      $val = trim($val);
    }

    // it parsed okay.
    $parms[$key] = $val;
  }

  if( !isset($parms['location']) || !is_numeric($parms['location']) ) {
    set_errormsg('locations_edit: id specified is invalid: '.$parms['location']);
    return FALSE;
  }

  // build the request
  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/locations');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','EDIT');
  $req->addParam('owner',$uid);
  if( count($parms) ) {
    foreach( $parms as $key => $value ) {
      $req->addParam($key,$value);
    }
  }

//   $req->addParam('latitude',$loc[0]);
//   $req->addParam('longitude',$loc[1]);
  $res = $req->execute();
  
  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); echo "\n"; // woot done.
  return TRUE;
}

function locations_photoupload($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: photoupload loc=location_id file=filename ...
Upload one or more photos to the album associated with a location.
options: 
  location =integer (required)
  file=string (at least one required)
EOT;
  return TRUE;
  }

  if( count($opts) < 2 ) {
    set_errormsg('photoupload: insufficient arguments');
    return FALSE;
  }
  $uid = get_appdata('uid',-1);
  if( $uid <= 0 ) {
    set_errormsg('photoupload: Not logged in... nothing to do');
    return FALSE;
  }

  $loc = '';
  $files = array();
  foreach( $opts as $opt ) {
    list($k,$v) = explode('=',$opt,2);
    switch( strtolower($k) ) {
    case 'loc':
      $loc = trim($v);
      break;
    case 'file':
      if( !file_exists($v) ) {
	set_errormsg('photoupload: file '.$v.' does not exist');
	return FALSE;
      }
      $files[] = $v;
      break;
    }
  }

  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/locations');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','PHOTOUPLOAD');
  $req->addParam('owner',$uid);
  $req->addParam('location',$loc);
  if( count($files) > 0 ) {
    $idx = 1;
    foreach( $files as $one ) {
      $req->addParam('file[]','@'.$one);
    }
  }
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }
  print_r($tmp); echo "\n";
  return TRUE;
}

function locations_photodelete($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: photodelete loc=location_id file=filename ...
Delete one or more photos to the album associated with a location.
options: 
  location =integer (required)
  file=string (at least one required)
EOT;
  return TRUE;
  }

  if( count($opts) < 2 ) {
    set_errormsg('photodelete: insufficient arguments');
    return FALSE;
  }
  $uid = get_appdata('uid',-1);
  if( $uid <= 0 ) {
    set_errormsg('photodelete: Not logged in... nothing to do');
    return FALSE;
  }

  $loc = '';
  $files = array();
  foreach( $opts as $opt ) {
    list($k,$v) = explode('=',$opt,2);
    switch( strtolower($k) ) {
    case 'loc':
      $loc = trim($v);
      break;
    case 'file':
      $files[] = $v;
      break;
    }
  }

  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/locations');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','PHOTODELETE');
  $req->addParam('owner',$uid);
  $req->addParam('location',$loc);
  if( count($files) > 0 ) {
    $idx = 1;
    foreach( $files as $one ) {
      $req->addParam('file[]',$one);
    }
  }
  $res = $req->execute();
}

#
# EOF
#
?>