<?php

function leaderboards_process_commands($cmd,$opts)
{
  switch( $cmd ) {
  case 'LIST':
    return leaderboards_list($opts);
  case 'GET':
    return leaderboards_get($opts);
  case 'BADGES':
    return leaderboards_badges($opts);
  case 'LEADERS':
    return leaderboards_leaders($opts);
  }
}

function leaderboards_list($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
    echo <<<EOT
usage: list
list leaderboards
EOT;
  }

  $req = new cms_http_request();
  $req->setTarget(BASE_URL.'/leaderboards');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','LIST');

  $res = $req->execute();
  $tmp = json_decode($res,TRUE);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); // woot done.
  return TRUE;
}


function leaderboards_get($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: get id
get information for one leaderboard.
EOT;
  }

  if( count($opts) != 1 ) {
    set_errormsg('leaderboards_get: Missing leaderboard id param');
    return FALSE;
  }
  $the_id = (int)$opts[0];

  $req = new cms_http_request();
  $req->setTarget(BASE_URL.'/leaderboards');
  $req->addParam('op','GET');
  $req->addParam('apikey',_apikey());
  $req->addParam('board',$the_id);

  $res = $req->execute();
  print_r($res);
  $tmp = json_decode($res,TRUE);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); // woot done.
  return TRUE;
}


function leaderboards_badges($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: get leaderboardid
get badge information for one leaderboard.
EOT;
  }

  if( count($opts) != 1 ) {
    set_errormsg('leaderboards_get: Missing leaderboard id param');
    return FALSE;
  }
  $the_id = (int)$opts[0];

  $req = new cms_http_request();
  $req->setTarget(BASE_URL.'/leaderboards');
  $req->addParam('op','BADGES');
  $req->addParam('apikey',_apikey());
  $req->addParam('board',$the_id);

  $res = $req->execute();
  print_r($res);
  $tmp = json_decode($res,TRUE);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); // woot done.
  return TRUE;
}


function leaderboards_leaders($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
    echo <<<EOT
usage: leaders leaderboardid [number [offset]]
leaderboardid = (int) leaderboard identifier
n = Number of results
o = offset
retrieve leader information for a leaderboard.
EOT;
  }

  if( count($opts) < 1 ) {
    set_errormsg('leaderboards_leaders: Missing leaderboard id param');
    return FALSE;
  }
  if( count($opts) > 3 ) {
    set_errormsg('leaderboards_leaders: too manu arguments');
    return FALSE;
  }
  $the_id = (int)$opts[0];

  $req = new cms_http_request();
  $req->setTarget(BASE_URL.'/leaderboards');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','LEADERS');
  $req->addParam('board',$the_id);
  if( isset($opts[1]) ) {
    $req->addParam('n',(int)$opts[1]);
  }
  if( isset($opts[2]) ) {
    $req->addParam('o',(int)$opts[2]);
  }

  $res = $req->execute();
  $tmp = json_decode($res,TRUE);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); // woot done.
  return TRUE;
}


#
# EOF
#
?>