<?php

function friends_process_commands($cmd,$opts)
{
  switch( $cmd )
    {
    case 'LIST':
      return friends_list($opts);

    case 'DEL':
      return friends_del($opts);

    case 'REQUEST':
      return friends_request($opts);

    case 'APPROVE':
      return friends_approve($opts);

    case 'DENY':
      return friends_deny($opts);
      
    case 'REQUESTLIST':
      return friends_requestlist($opts);

    case 'DENY':
      return friends_deny($opts);
    }
}

function friends_list($opts)
{
  if( count($opts) && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: list [options]
list my current friends\n
must be logged in to use this function.\n
options:\n
    n=integer : number of friends to return\n
    o=integer : start offset\n
    deep=int  : wether to return array of uid/username pairs.
EOT;
    return TRUE;
  }

  $parms = array();
  foreach( $opts as $opt ) {
    list($k,$v) = explode('=',$opt,2);
    switch( $k ) {
    case 'n':
    case 'o':
    case 'deep':
      $parms[$k] = $v;
      break;
    }
  }
  $uid = get_appdata('uid',-1);
  if( $uid <= 0 ) {
    set_errormsg('Not logged in... nothing to do');
    return FALSE;
  }

  $req = new cms_http_request();
  $req->setMethod('GET');
  $req->setTarget(BASE_URL.'/friends');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','LIST');
  $req->addParam('uid',$uid);
  foreach( $parms as $key => $value ) {
    $req->addParam($key,$value);
  }
  $res = $req->execute();
  $tmp = json_decode($res);
  
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }
  if( isset($tmp->data) )  print_r($tmp->data);
  return TRUE;
}


/*
function friends_add($opts)
{
  if( count($opts) && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: 
list my current friends
must be logged in to use this function.\n
EOT;
    return TRUE;
  }

  if( count($opts) != 1 )
    {
      set_errormsg('add checkin: insufficient arguments');
      return FALSE;
    }
  $uid = get_appdata('uid',-1);
  if( $uid <= 0 )
    {
      set_errormsg('Not logged in... nothing to do');
      return FALSE;
    }

  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/friends');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','ADD');
  $req->addParam('uid',$uid);
  $req->addParam('fuid',$opts[0]);
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' )
    {
      $msg = $tmp->_status;
      if( isset($tmp->_message) )
	{
	  $msg .= ': '.$tmp->_message;
	}
      set_errormsg($msg);
      return FALSE;
    }
  echo "ADDED FRIEND\n";
  return TRUE;
}
*/

function friends_del($opts)
{
  if( count($opts) && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: del <uid>
delete the specified friend from friend list.
must be logged in to use this function.\n
EOT;
    return TRUE;
  }

  if( count($opts) != 1 )
    {
      set_errormsg('add checkin: insufficient arguments');
      return FALSE;
    }
  $uid = get_appdata('uid',-1);
  if( $uid <= 0 )
    {
      set_errormsg('Not logged in... nothing to do');
      return FALSE;
    }

  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/friends');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','DEL');
  $req->addParam('uid',$uid);
  $req->addParam('fuid',$opts[0]);
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' )
    {
      $msg = $tmp->_status;
      if( isset($tmp->_message) )
	{
	  $msg .= ': '.$tmp->_message;
	}
      set_errormsg($msg);
      return FALSE;
    }
  echo "REMOVED FRIEND\n";
  return TRUE;
}


function friends_requestlist()
{
  if( count($opts) && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: requestlist
retrieve a list of friend requests.\n
EOT;
    return TRUE;
  }

  $uid = get_appdata('uid',-1);
  if( $uid <= 0 )
    {
      set_errormsg('Not logged in... nothing to do');
      return FALSE;
    }

  $req = new cms_http_request();
  $req->setMethod('GET');
  $req->setTarget(BASE_URL.'/friends');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','REQUESTLIST');
  $req->addParam('uid',$uid);
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' )
    {
      $msg = $tmp->_status;
      if( isset($tmp->_message) )
	{
	  $msg .= ': '.$tmp->_message;
	}
      set_errormsg($msg);
      return FALSE;
    }
  print_r($tmp);
  echo "OK\n";
  return TRUE;
}


function friends_request($opts)
{
  if( count($opts) && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: request <uid>
send a friend request to the specified user.\n
EOT;
    return TRUE;
  }

  if( count($opts) != 1 )
    {
      set_errormsg('add checkin: insufficient arguments');
      return FALSE;
    }
  $uid = get_appdata('uid',-1);
  if( $uid <= 0 )
    {
      set_errormsg('Not logged in... nothing to do');
      return FALSE;
    }

  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/friends');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','REQUEST');
  $req->addParam('uid',$uid);
  $req->addParam('fuid',$opts[0]);
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' )
    {
      $msg = $tmp->_status;
      if( isset($tmp->_message) )
	{
	  $msg .= ': '.$tmp->_message;
	}
      set_errormsg($msg);
      return FALSE;
    }
  echo "FRIEND REQUEST OK\n";
  return TRUE;
}


function friends_approve($opts)
{
  if( count($opts) && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: approve <uid>
approve the specified user as a friend.
must be logged in to use this function, and the uid must exist in the request list.\n
EOT;
    return TRUE;
  }

  if( count($opts) != 1 )
    {
      set_errormsg('add checkin: insufficient arguments');
      return FALSE;
    }
  $uid = get_appdata('uid',-1);
  if( $uid <= 0 )
    {
      set_errormsg('Not logged in... nothing to do');
      return FALSE;
    }

  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/friends');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','APPROVE');
  $req->addParam('uid',$uid);
  $req->addParam('fuid',$opts[0]);
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' )
    {
      $msg = $tmp->_status;
      if( isset($tmp->_message) )
	{
	  $msg .= ': '.$tmp->_message;
	}
      set_errormsg($msg);
      return FALSE;
    }
  echo "APPROVED FRIEND\n";
  return TRUE;
}


function friends_deny($opts)
{
  if( count($opts) && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: deny <uid>
deny the specified user from becoming a friend.
must be logged in to use this function, and the uid must exist in the request list.\n
EOT;
    return TRUE;
  }

  if( count($opts) != 1 )
    {
      set_errormsg('add checkin: insufficient arguments');
      return FALSE;
    }
  $uid = get_appdata('uid',-1);
  if( $uid <= 0 )
    {
      set_errormsg('Not logged in... nothing to do');
      return FALSE;
    }

  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/friends');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','DENY');
  $req->addParam('uid',$uid);
  $req->addParam('fuid',$opts[0]);
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' )
    {
      $msg = $tmp->_status;
      if( isset($tmp->_message) )
	{
	  $msg .= ': '.$tmp->_message;
	}
      set_errormsg($msg);
      return FALSE;
    }
  echo "DENIED FRIEND\n";
  return TRUE;
}
?>