<?php

function checkins_process_commands($cmd,$opts)
{
  switch( $cmd )
    {
    case 'GET':
      return checkins_get($opts);

    case 'DEL':
      return checkins_del($opts);

    case 'ADD':
      return checkins_add($opts);

    case 'EDIT':
      return checkins_edit($opts);

    case 'BYLOCATION':
      return checkins_bylocation($opts);

    case 'MYLOCATION':
      return checkins_mylocation($opts);

    case 'BYFRIENDS':
      return checkins_byfriends($opts);
    }
}

function checkins_add($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: add loc=location_id [act=activity_id] [msg=string] [file=filename] [tag=uid1,uid2,uid3] [extra_url1=url]
Create a new checkin
uses the currently logged in uid
location id must be specified
activity id, file and msg are optional
multiple files can be uploaded.\n
EOT;
    return TRUE;
  }

  if( count($opts) < 1 ) {
    set_errormsg('add checkin: insufficient arguments');
    return FALSE;
  }
  $uid = get_appdata('uid',-1);
  if( $uid <= 0 ) {
    set_errormsg('Not logged in... nothing to do');
    return FALSE;
  }

  $parms = array();
  $files = array();
  foreach( $opts as $opt ) {
    list($k,$v) = explode('=',$opt,2);
    $k = trim($k);
    $v = trim($v);
    switch( strtolower($k) ) {
    case 'act':
      $k = 'activity';
      $parms[$k] = $v;
      break;

    case 'loc':
      $k = 'location';
      $parms[$k] = $v;
      break;

    case 'msg':
    case 'tag':
      $parms[$k] = $v;
      break;

    case 'file':
      if( !file_exists($v) ) {
	set_errormsg('add checkin: file '.$v.' does not exist');
	return FALSE;
      }
      $files[] = $v;
      break;

    default:
      if( startswith($k,'extra_') ) {
	$parms[$k] = $v;
      }
    }
  }

  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/checkins');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','ADD');
  $req->addParam('owner',$uid);
  foreach( $parms as $key => $v ) {
    $req->addParam($key,$v);
  }
  if( count($files) > 0 ) {
    $idx = 1;
    foreach( $files as $one ) {
      $req->addParam('file'.$idx++,'@'.$one);
    }
  }
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }
  echo "CHECKINID: ".$tmp->data."\n";
  return TRUE;
}


function checkins_get($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: get <id=int> [deep=int]
Retrieve information about a checkin.\n
EOT;
    return TRUE;
  }

  $parms = array();
  foreach( $opts as $one ) {
    list($k,$v) = explode('=',$one,2);
    switch( $k ) {
    case 'id':
      $k = 'cid';
      // fall through
    case 'deep':
      $parms[$k] = (int)$v;
      break;
    }
  }

  if( !isset($parms['cid']) ) {
    set_errormsg('add checkin: insufficient arguments');
    return FALSE;
  }

  $req = new cms_http_request();
  $req->setMethod('GET');
  $req->setTarget(BASE_URL.'/checkins');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','GET');
  foreach( $parms as $k => $v ) {
    $req->addParam($k,$v);
  }
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp)."\n";
  return TRUE;
}


function checkins_del($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: del <checkinid>
Delete the specified checkin.
Uses the currently logged in userid.
The checkin must be created by the logged in user.\n
EOT;
    return TRUE;
  }

  if( count($opts) != 1 ) {
    set_errormsg('add checkin: insufficient arguments');
    return FALSE;
  }
  $uid = get_appdata('uid',-1);
  if( $uid <= 0 ) {
    set_errormsg('Not logged in... nothing to do');
    return FALSE;
  }

  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/checkins');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','DEL');
  $req->addParam('owner',$uid);
  $req->addParam('cid',(int)$opts[0]);
  $res = $req->execute();
  
  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp)."\n";
  return TRUE;
}


function checkins_mycheckins($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: mycheckins [options...]
retrieve a list of checkins from the currently logged in user.
timelimit = integer minutes, default is 0
limit = integer, number of items to return
offset = integer, star position
deep = integer
EOT;
    return TRUE;
  }

  $parms = array();
  if( count($opts) ) {
    foreach( $opts as $one ) {
      list($k,$v) = explode('=',$one,2);
      switch( $k ) {
      case 'limit':
      case 'offset':
      case 'timelimit':
      case 'deep':
	$parms[$k] = (int)$v;
	break;
      }
    }
  }

  $uid = get_appdata('uid',-1);
  if( $uid <= 0 ) {
    set_errormsg('Not logged in... nothing to do');
    return FALSE;
  }

  $req = new cms_http_request();
  $req->setMethod('GET');
  $req->setTarget(BASE_URL.'/checkins');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','MYCHECKINS');
  $req->addParam('owner',$uid);
  foreach( $parms as $key => $v ) {
    $req->addParam($k,$v);
  }
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp)."\n";
  return TRUE;
}


function checkins_edit($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: edit checkinid [del]|[loc=location_id] [act=activity_id] [msg=msg] [extra_XXXXX=val]
edit an existing checkin
the currently logged in user must own the checkin
see the add command
file uploads are not yet supported\n
EOT;
    return TRUE;
  }
  if( count($opts) < 2 ) {
    set_errormsg('edit checkin: insufficient arguments');
    return FALSE;
  }
  $uid = get_appdata('uid',-1);
  if( $uid <= 0 ) {
    set_errormsg('Not logged in... nothing to do');
    return FALSE;
  }
  $cid = (int)$opts[0];
  array_shift($opts);
  $parms = array();
  foreach( $opts as $opt ) {
    list($k,$v) = explode('=',$opt,2);
    $k = strtolower(trim($k));
    $v = trim($v);

    switch($k) {
    case 'act':
    case 'activity':
      $k = 'activity';
      $parms[$k] = $v;
      break;

    case 'loc':
    case 'location':
      $k = 'location';
      $parms[$k] = $v;
      break;

    case 'msg':
      $parms[$k] = $v;
      break;

    case 'del':
      $v = (int)$v;
      $parms[$k] = $v;
      break;

    default:
      if( startswith($k,'extra_') ) {
	$parms[$k] = $v;
      }
    }
  }
  
  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/checkins');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','EDIT');
  $req->addParam('cid',$cid);
  $req->addParam('owner',$uid);
  foreach( $parms as $key => $val ) {
    $req->addParam($key,$val);
  }
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp)."\n";
  return TRUE;
}


function checkins_mylocation($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: mylocation [lat long]
retrieve or set current location
used for checkin information.\n
EOT;
    return TRUE;
  }
  if( count($opts) != 2 ) {
    $loc = get_appdata('loc','');
    if( !$loc ) {
      echo "INFO: Your location is not set\n";
    }
    else {
      echo "INFO: Your location:  lat=".$loc[0].' lon='.$loc[1]."\n";
    }
    return true;
  }
  
  $loc = array($opts[0],$opts[1]);
  set_appdata('loc',$loc);
  return TRUE;
}

function checkins_bylocation($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
retrieve checkins for the specified location
usage: bylocation options
options:
  loc=id (required)
  deep=1 (optional) - enable deep mode
  timelimit=N (optional) - timelimit in minutes
  limit=N = (optional) integer number of articles to return.  default = 50
  offset=N = (optional) integer start position.  default = 0\n
EOT;
    return TRUE;
  }

  $parms = array();
  foreach( $opts as $one ) {
    list($k,$v) = explode('=',$one,2);
    switch( $k ) {
    case 'loc':
      $k = 'lid';
      $v = (int)$v;
      $parms[$k] = $v;
      break;

    case 'deep':
      $v = (int)$v;
      $parms[$k] = $v;
      break;

    case 'timelimit':
      $v = (int)$v;
      $parms[$k] = $v;
      break;

    case 'limit':
      $v = (int)$v;
      $parms[$k] = $v;
      break;

    case 'offset':
      $v = (int)$v;
      $parms[$k] = $v;
      break;

    }
  }

  if( !isset($parms['lid']) ) {
    $msg = 'Error: missing required loc arument';
    set_errormsg($msg);
    return FALSE;
  }

  $req = new cms_http_request();
  $req->setMethod('GET');
  $req->setTarget(BASE_URL.'/checkins');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','BYLOCATION');
  foreach( $parms as $k => $v ) {
    $req->addParam($k,$v);
  }
  $res = $req->execute();

  print_r($res);
  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); // woot done.
  return TRUE;
}


function checkins_byfriends($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: byfriends [opt=value]...
Retrieve information about checkins from my friends.
EOT;
    return TRUE;
  }

  // parse arguments
  $parms = array();
  $parms['n'] = 50;
  $parms['o'] = 0;
  foreach( $opts as $arg ) {
    list($key,$val) = explode('=',$arg,2);
    $key = trim($key);
    $val = trim($val);

    switch( $key ) {
    case 'n':
    case 'o':
    case 'deep':
      $val = (int)$val;
      $parms[$key] = $val;
      break;
    }
  }

  $uid = get_appdata('uid',-1);
  if( $uid <= 0 ) {
    set_errormsg('Not logged in... nothing to do');
    return FALSE;
  }

  $req = new cms_http_request();
  $req->setMethod('GET');
  $req->setTarget(BASE_URL.'/checkins');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','FRIENDS');
  $req->addParam('uid',$uid);
  foreach( $parms as $key => $value ) {
    $req->addParam($key,$value);
  }
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp)."\n";
  return TRUE;
}

?>